/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed.generators.biomes;

import java.io.File;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.generator.BiomeParameterPoint;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.boxed.Boxed;

public abstract class AbstractSeedBiomeProvider
extends BiomeProvider {
    private static final Map<World.Environment, String> ENV_MAP;
    private final Boxed addon;
    protected final int dist;
    private final int spawnX;
    private final int spawnZ;
    protected final Map<BlockFace, SortedMap<Double, Biome>> quadrants;

    protected AbstractSeedBiomeProvider(Boxed boxed, World.Environment env) {
        this.addon = boxed;
        this.dist = this.addon.getSettings().getIslandDistance();
        if (env.equals((Object)World.Environment.NORMAL)) {
            this.spawnX = this.addon.getSettings().getSeedX();
            this.spawnZ = this.addon.getSettings().getSeedZ();
        } else {
            this.spawnX = this.addon.getSettings().getNetherSeedX();
            this.spawnZ = this.addon.getSettings().getNetherSeedZ();
        }
        File biomeFile = new File(this.addon.getDataFolder(), "biomes.yml");
        if (!biomeFile.exists()) {
            this.addon.saveResource("biomes.yml", true);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)biomeFile);
        SortedMap<Double, Biome> northEast = this.loadQuad(config, ENV_MAP.get(env) + ".north-east");
        SortedMap<Double, Biome> southEast = this.loadQuad(config, ENV_MAP.get(env) + ".south-east");
        SortedMap<Double, Biome> northWest = this.loadQuad(config, ENV_MAP.get(env) + ".north-west");
        SortedMap<Double, Biome> southWest = this.loadQuad(config, ENV_MAP.get(env) + ".south-west");
        this.quadrants = new EnumMap<BlockFace, SortedMap<Double, Biome>>(BlockFace.class);
        this.quadrants.put(BlockFace.NORTH_EAST, northEast);
        this.quadrants.put(BlockFace.NORTH_WEST, northWest);
        this.quadrants.put(BlockFace.SOUTH_EAST, southEast);
        this.quadrants.put(BlockFace.SOUTH_WEST, southWest);
    }

    private Biome getQuadrantBiome(BlockFace dir, double d) {
        Map.Entry en = ((TreeMap)this.quadrants.get(dir)).ceilingEntry(d);
        return en == null ? null : (Biome)en.getValue();
    }

    public Biome getBiome(WorldInfo worldInfo, int x, int y, int z, BiomeParameterPoint biomeParameterPoint) {
        return this.getMappedBiome(worldInfo, x, y, z, biomeParameterPoint);
    }

    public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
        throw new IllegalStateException("This method should never be called.");
    }

    private @NonNull Biome getVanillaBiome(WorldInfo worldInfo, int x, int y, int z, BiomeParameterPoint bpb, Biome def) {
        if (worldInfo.getEnvironment() == World.Environment.NORMAL) {
            return this.getNormalBiome(bpb, def);
        }
        return this.getNetherBiome(bpb);
    }

    private @NonNull Biome getNetherBiome(BiomeParameterPoint bpb) {
        double temp = (double)Math.round(bpb.getTemperature() * 10.0) / 10.0;
        double humidity = (double)Math.round(bpb.getHumidity() * 10.0) / 10.0;
        if (temp == -0.5 && humidity == 0.0) {
            return Biome.BASALT_DELTAS;
        }
        if (temp == 0.4 && humidity == 0.0) {
            return Biome.CRIMSON_FOREST;
        }
        if (temp == 0.0 && humidity == -0.5) {
            return Biome.SOUL_SAND_VALLEY;
        }
        if (temp == -0.5 && humidity == 0.5) {
            return Biome.WARPED_FOREST;
        }
        return Biome.NETHER_WASTES;
    }

    private @NonNull Biome getNormalBiome(BiomeParameterPoint bpb, Biome def) {
        double d = bpb.getDepth();
        if (d > 0.2 && d < 0.9) {
            if (bpb.getHumidity() >= 0.4 && bpb.getHumidity() < 1.0) {
                def = Biome.LUSH_CAVES;
            }
            if (bpb.getContinentalness() >= 0.8 && bpb.getContinentalness() <= 1.0) {
                def = Biome.DRIPSTONE_CAVES;
            }
        }
        if (d >= 0.9) {
            def = Biome.DEEP_DARK;
        }
        if (def != null) {
            return def;
        }
        int temp = this.getTemp(bpb.getTemperature());
        int humidity = this.getHumidity(bpb.getHumidity());
        int erosion = this.getErosion(bpb.getErosion());
        double we = bpb.getWeirdness();
        return switch (ContLoc.getCont(bpb.getContinentalness()).ordinal()) {
            case 3 -> this.coastBiome(humidity, temp, erosion, we);
            case 1 -> this.deepOceanBiome(temp);
            case 6 -> this.farInlandBiome(humidity, temp, erosion, we);
            case 5 -> this.midInlandBiome(humidity, temp, erosion, we);
            case 0 -> Biome.MUSHROOM_FIELDS;
            case 4 -> this.nearInlandBiome(humidity, temp, erosion, we);
            case 2 -> this.oceanBiome(temp);
            default -> this.farInlandBiome(humidity, temp, erosion, we);
        };
    }

    private int getErosion(double erosion) {
        if (erosion < -0.78) {
            return 0;
        }
        if (erosion < -0.375) {
            return 1;
        }
        if (erosion < -0.2225) {
            return 2;
        }
        if (erosion < 0.05) {
            return 3;
        }
        if (erosion < 0.45) {
            return 4;
        }
        if (erosion < 0.55) {
            return 5;
        }
        return 6;
    }

    private int getHumidity(double humidity) {
        if (humidity < -0.35) {
            return 0;
        }
        if (humidity < -0.1) {
            return 1;
        }
        if (humidity < 0.1) {
            return 2;
        }
        if (humidity < 0.3) {
            return 3;
        }
        return 4;
    }

    private int getTemp(double temp) {
        if (temp < -0.45) {
            return 0;
        }
        if (temp < -0.15) {
            return 1;
        }
        if (temp < 0.2) {
            return 2;
        }
        if (temp < 0.55) {
            return 3;
        }
        return 4;
    }

    private @NonNull Biome oceanBiome(int temp) {
        return switch (temp) {
            case 0 -> Biome.FROZEN_OCEAN;
            case 1 -> Biome.COLD_OCEAN;
            case 2 -> Biome.OCEAN;
            case 3 -> Biome.LUKEWARM_OCEAN;
            case 4 -> Biome.WARM_OCEAN;
            default -> Biome.OCEAN;
        };
    }

    private @NonNull Biome deepOceanBiome(int temp) {
        return switch (temp) {
            case 0 -> Biome.DEEP_FROZEN_OCEAN;
            case 1 -> Biome.DEEP_COLD_OCEAN;
            case 2 -> Biome.DEEP_OCEAN;
            case 3 -> Biome.DEEP_LUKEWARM_OCEAN;
            case 4 -> Biome.WARM_OCEAN;
            default -> Biome.DEEP_OCEAN;
        };
    }

    private @NonNull Biome farInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        return switch (Ridges.getRidge(AbstractSeedBiomeProvider.convertToY(weirdness)).ordinal()) {
            case 3 -> this.getFarInlandHighBiome(humidity, temperature, erosion, weirdness);
            case 1 -> this.getFarInlandLowBiome(humidity, temperature, erosion, weirdness);
            case 2 -> this.getFarInlandMidBiome(humidity, temperature, erosion, weirdness);
            case 4 -> this.getFarInlandPeaksBiome(humidity, temperature, erosion, weirdness);
            default -> this.getFarInlandValleysBiome(humidity, temperature, erosion, weirdness);
        };
    }

    private @NonNull Biome getFarInlandValleysBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion >= 0 && erosion < 6) {
            if ((double)temperature > 0.0) {
                return Biome.RIVER;
            }
            return Biome.FROZEN_RIVER;
        }
        if (temperature == 0) {
            return Biome.FROZEN_RIVER;
        }
        if (temperature == 1 || temperature == 2) {
            return Biome.SWAMP;
        }
        return Biome.MANGROVE_SWAMP;
    }

    private @NonNull Biome getValleysNearInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        return this.getFarInlandValleysBiome(humidity, temperature, erosion, weirdness);
    }

    private @NonNull Biome getFarInlandPeaksBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0) {
            if (temperature >= 0 && temperature <= 2) {
                if (weirdness < 0.0) {
                    return Biome.JAGGED_PEAKS;
                }
                return Biome.FROZEN_PEAKS;
            }
            if (temperature == 3) {
                return Biome.STONY_PEAKS;
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 1) {
            if (temperature == 0 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature == 0 && humidity > 1) {
                return Biome.GROVE;
            }
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion >= 2 && erosion <= 4) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1 || humidity == 4)) {
                return ShatteredBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        }
        return MiddleBiome.getBiome(humidity, temperature, weirdness);
    }

    private @NonNull Biome getFarInlandMidBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0) {
            if (temperature < 3 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature < 3 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 1) {
            if (temperature == 0 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature == 0 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 2) {
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 3) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1) || humidity == 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        }
        if (temperature == 0) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (temperature == 1 || temperature == 2) {
            return Biome.SWAMP;
        }
        return Biome.MANGROVE_SWAMP;
    }

    private @NonNull Biome getFarInlandLowBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion >= 0 && erosion < 2) {
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion >= 2 && erosion < 5) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1 || humidity == 4)) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        }
        if (temperature == 0) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (temperature == 1 || temperature == 2) {
            return Biome.SWAMP;
        }
        return Biome.MANGROVE_SWAMP;
    }

    private @NonNull Biome getFarInlandHighBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0) {
            if (temperature < 3 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature < 3 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 1) {
            if (temperature == 0 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature == 0 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            if (temperature > 0 && temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 2 || erosion == 3 || erosion == 4) {
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 4 || erosion == 6) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        return ShatteredBiome.getBiome(humidity, temperature, weirdness);
    }

    private @NonNull Biome nearInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        return switch (Ridges.getRidge(AbstractSeedBiomeProvider.convertToY(weirdness)).ordinal()) {
            case 3 -> this.getHighNearInlandBiome(humidity, temperature, erosion, weirdness);
            case 1 -> this.getLowNearInlandBiome(humidity, temperature, erosion, weirdness);
            case 2 -> this.getMidNearInlandBiome(humidity, temperature, erosion, weirdness);
            case 4 -> this.getPeaksNearInlandBiome(humidity, temperature, erosion, weirdness);
            default -> this.getValleysNearInlandBiome(humidity, temperature, erosion, weirdness);
        };
    }

    private @NonNull Biome getPeaksNearInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0) {
            if (temperature >= 0 && temperature <= 2) {
                if (weirdness < 0.0) {
                    return Biome.JAGGED_PEAKS;
                }
                return Biome.FROZEN_PEAKS;
            }
            if (temperature == 3) {
                return Biome.STONY_PEAKS;
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 1) {
            if (temperature == 0 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature == 0 && humidity > 1) {
                return Biome.GROVE;
            }
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion >= 2 && erosion <= 4) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1 || humidity == 4)) {
                return ShatteredBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        }
        return MiddleBiome.getBiome(humidity, temperature, weirdness);
    }

    private @NonNull Biome getMidNearInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0) {
            if (temperature < 3 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature < 3 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 1) {
            if (temperature == 0 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature == 0 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            if (temperature > 0 && temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion >= 2 && erosion <= 4) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1) || humidity == 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        }
        if (temperature == 0) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (temperature == 1 || temperature == 2) {
            return Biome.SWAMP;
        }
        return Biome.MANGROVE_SWAMP;
    }

    private @NonNull Biome getLowNearInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion >= 0 && erosion < 2) {
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion >= 2 && erosion < 5) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1 || humidity == 4)) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        }
        if (temperature == 0) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (temperature == 1 || temperature == 2) {
            return Biome.SWAMP;
        }
        return Biome.MANGROVE_SWAMP;
    }

    private @NonNull Biome getHighNearInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0) {
            if (temperature < 3 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature < 3 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 1) {
            if (temperature == 0 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature == 0 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            if (temperature > 0 && temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion >= 2 && erosion <= 4) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1) || humidity == 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        }
        return MiddleBiome.getBiome(humidity, temperature, weirdness);
    }

    private @NonNull Biome midInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        return switch (Ridges.getRidge(AbstractSeedBiomeProvider.convertToY(weirdness)).ordinal()) {
            case 3 -> this.getHighMidInlandBiome(humidity, temperature, erosion, weirdness);
            case 1 -> this.getLowMidInlandBiome(humidity, temperature, erosion, weirdness);
            case 2 -> this.getMidMidInlandBiome(humidity, temperature, erosion, weirdness);
            case 4 -> this.getPeaksMidInlandBiome(humidity, temperature, erosion, weirdness);
            default -> this.getValleysMidInlandBiome(humidity, temperature, erosion, weirdness);
        };
    }

    private @NonNull Biome getValleysMidInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0 || erosion == 1) {
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion >= 2 && erosion <= 5) {
            if (temperature == 0) {
                return Biome.FROZEN_RIVER;
            }
            return Biome.RIVER;
        }
        if (temperature == 0) {
            return Biome.FROZEN_RIVER;
        }
        if (temperature == 1 || temperature == 2) {
            return Biome.SWAMP;
        }
        return Biome.MANGROVE_SWAMP;
    }

    private @NonNull Biome getPeaksMidInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0 || erosion == 1) {
            if (temperature >= 0 && temperature <= 2) {
                if (weirdness < 0.0) {
                    return Biome.JAGGED_PEAKS;
                }
                return Biome.FROZEN_PEAKS;
            }
            if (temperature == 3) {
                return Biome.STONY_PEAKS;
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 2) {
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 3) {
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 4 || erosion == 6) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        return ShatteredBiome.getBiome(humidity, temperature, weirdness);
    }

    private @NonNull Biome getMidMidInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0) {
            if (temperature < 3 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature < 3 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 1) {
            if (temperature == 0 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature == 0 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            if (temperature > 0 && temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 2 || erosion == 3) {
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 4) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            return ShatteredBiome.getBiome(humidity, temperature, weirdness);
        }
        if (temperature == 0) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (temperature == 1 || temperature == 2) {
            return Biome.SWAMP;
        }
        return Biome.MANGROVE_SWAMP;
    }

    private @NonNull Biome getLowMidInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0 || erosion == 1) {
            if (temperature == 0 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature == 0 && humidity > 1) {
                return Biome.GROVE;
            }
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 2 || erosion == 3) {
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (temperature == 0) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (temperature == 1 || temperature == 2) {
            return Biome.SWAMP;
        }
        return Biome.MANGROVE_SWAMP;
    }

    private @NonNull Biome getHighMidInlandBiome(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0) {
            if (temperature < 3 && weirdness < 0.0) {
                return Biome.JAGGED_PEAKS;
            }
            if (temperature < 3 && weirdness > 0.0) {
                return Biome.FROZEN_PEAKS;
            }
            if (temperature == 3) {
                return Biome.STONY_PEAKS;
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 1) {
            if (temperature < 3 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature < 3 && (humidity == 2 || humidity == 3 || humidity == 4)) {
                return Biome.GROVE;
            }
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 2) {
            return PlateauBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 3) {
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 4) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            return ShatteredBiome.getBiome(humidity, temperature, weirdness);
        }
        return MiddleBiome.getBiome(humidity, temperature, weirdness);
    }

    private @NonNull Biome coastBiome(int humidity, int temperature, int erosion, double weirdness) {
        return switch (Ridges.getRidge(AbstractSeedBiomeProvider.convertToY(weirdness)).ordinal()) {
            case 3 -> this.getHighCoastBionme(humidity, temperature, erosion, weirdness);
            case 1 -> this.getLowCoastBionme(humidity, temperature, erosion, weirdness);
            case 2 -> this.getMidCoastBionme(humidity, temperature, erosion, weirdness);
            case 4 -> this.getPeaksCoastBionme(humidity, temperature, erosion, weirdness);
            default -> this.getValleysCoastBionme(humidity, temperature, erosion, weirdness);
        };
    }

    private @NonNull Biome getValleysCoastBionme(int humidity, int temperature, int erosion, double weirdness) {
        if ((double)temperature > 0.0) {
            return Biome.RIVER;
        }
        return Biome.FROZEN_RIVER;
    }

    private @NonNull Biome getPeaksCoastBionme(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion == 0) {
            if (temperature >= 0 && temperature <= 2) {
                if (weirdness < 0.0) {
                    return Biome.JAGGED_PEAKS;
                }
                return Biome.FROZEN_PEAKS;
            }
            if (temperature == 3) {
                return Biome.STONY_PEAKS;
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion == 1) {
            if (temperature == 0 && (humidity == 0 || humidity == 1)) {
                return Biome.SNOWY_SLOPES;
            }
            if (temperature == 0 && humidity > 1) {
                return Biome.GROVE;
            }
            if (temperature < 4) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            return BadlandBiome.getBiome(humidity, weirdness);
        }
        if (erosion >= 2 && erosion <= 4) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1 || humidity == 4)) {
                return ShatteredBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        }
        return MiddleBiome.getBiome(humidity, temperature, weirdness);
    }

    private @NonNull Biome getMidCoastBionme(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion > 0 && erosion < 3) {
            return Biome.STONY_SHORE;
        }
        if (erosion == 3) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 4) {
            if (weirdness < 0.0) {
                return this.getBeachBiome(temperature);
            }
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            if (weirdness < 0.0) {
                return this.getBeachBiome(temperature);
            }
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1 || humidity == 4)) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        } else if (erosion == 6) {
            if (weirdness < 0.0) {
                return this.getBeachBiome(temperature);
            }
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        return this.getBeachBiome(temperature);
    }

    private @NonNull Biome getLowCoastBionme(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion >= 0 && erosion < 3) {
            return Biome.STONY_SHORE;
        }
        if (erosion >= 3 && erosion < 5) {
            return this.getBeachBiome(temperature);
        }
        if (erosion == 5) {
            if (weirdness < 0.0) {
                return this.getBeachBiome(temperature);
            }
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1 || humidity == 4)) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        }
        return this.getBeachBiome(temperature);
    }

    private @NonNull Biome getHighCoastBionme(int humidity, int temperature, int erosion, double weirdness) {
        if (erosion >= 0 && erosion < 5) {
            return MiddleBiome.getBiome(humidity, temperature, weirdness);
        }
        if (erosion == 5) {
            if (weirdness < 0.0 && (temperature == 0 || temperature == 1 || humidity == 4)) {
                return MiddleBiome.getBiome(humidity, temperature, weirdness);
            }
            if (weirdness > 0.0 && temperature > 2 && temperature <= 4 && humidity >= 0 && humidity <= 4) {
                return Biome.WINDSWEPT_SAVANNA;
            }
        }
        return MiddleBiome.getBiome(humidity, temperature, weirdness);
    }

    Biome getBeachBiome(int t) {
        return switch (t) {
            case 0 -> Biome.SNOWY_BEACH;
            case 4 -> Biome.DESERT;
            default -> Biome.BEACH;
        };
    }

    public static double convertToY(double x) {
        if ((x = Math.clamp(x, -1.0, 1.0)) >= -1.0 && x < -0.5) {
            return 2.0 * x + 1.0;
        }
        if (x >= -0.5 && x < 0.0) {
            return -2.0 * x;
        }
        if (x >= 0.0 && x < 0.5) {
            return 2.0 * x;
        }
        if (x >= 0.5 && x <= 1.0) {
            return -2.0 * x + 1.0;
        }
        throw new IllegalArgumentException("Invalid x value. x must be in the range [-1, 1]. Value = " + x);
    }

    private Biome getMappedBiome(WorldInfo worldInfo, int x, int y, int z, BiomeParameterPoint biomeParameterPoint) {
        Vector l = new Vector(this.spawnX, 0, this.spawnZ);
        Vector s = new Vector(x, 0, z);
        double dis = l.distance(s);
        if (dis > (double)(this.dist * 2)) {
            return this.getVanillaBiome(worldInfo, x, y, z, biomeParameterPoint, null);
        }
        double d = dis / (double)this.dist;
        Vector direction = s.subtract(l);
        Biome result = direction.getBlockX() <= 0 && direction.getBlockZ() <= 0 ? this.getQuadrantBiome(BlockFace.NORTH_WEST, d) : (direction.getBlockX() > 0 && direction.getBlockZ() <= 0 ? this.getQuadrantBiome(BlockFace.NORTH_EAST, d) : (direction.getBlockX() <= 0 && direction.getBlockZ() > 0 ? this.getQuadrantBiome(BlockFace.SOUTH_WEST, d) : this.getQuadrantBiome(BlockFace.SOUTH_EAST, d)));
        if (result == null || result.equals((Object)Biome.CUSTOM)) {
            result = this.getVanillaBiome(worldInfo, x, y, z, biomeParameterPoint, null);
        }
        if (biomeParameterPoint.getDepth() > 0.2) {
            result = this.getVanillaBiome(worldInfo, x, y, z, biomeParameterPoint, null);
        }
        return result;
    }

    public List<Biome> getBiomes(WorldInfo worldInfo) {
        return Registry.BIOME.stream().filter(b -> !b.equals((Object)Biome.CUSTOM)).toList();
    }

    private SortedMap<Double, Biome> loadQuad(YamlConfiguration config, String sector) {
        TreeMap<Double, Biome> result = new TreeMap<Double, Biome>();
        if (!config.contains(sector)) {
            return result;
        }
        for (String ring : config.getStringList(sector)) {
            String[] split = ring.split(":");
            if (split.length == 2) {
                try {
                    double d = Double.parseDouble(split[0]);
                    Biome biome = Biome.valueOf((String)split[1].toUpperCase(Locale.ENGLISH));
                    if (biome == null) {
                        this.addon.logError(split[1].toUpperCase(Locale.ENGLISH) + " is an unknown biome on this server.");
                        result.put(d, Biome.CUSTOM);
                        continue;
                    }
                    result.put(d, biome);
                }
                catch (Exception e) {
                    this.addon.logError(sector + ": " + split[0] + " does not seem to be a double. For integers add a .0 to the end");
                }
                continue;
            }
            this.addon.logError(ring + " must be in the format ratio:biome where ratio is a double.");
        }
        return result;
    }

    static {
        EnumMap<World.Environment, String> e = new EnumMap<World.Environment, String>(World.Environment.class);
        e.put(World.Environment.NORMAL, "distribution.overworld");
        e.put(World.Environment.NETHER, "distribution.nether");
        e.put(World.Environment.THE_END, "distribution.the_end");
        ENV_MAP = Collections.unmodifiableMap(e);
    }

    private static enum ContLoc {
        MUSHROOM_FIELDS(-1.2, -1.05),
        DEEP_OCEAN(-1.05, -0.455),
        OCEAN(-0.455, -0.19),
        COAST(-0.19, -0.11),
        NEAR_INLAND(-0.11, 0.03),
        MID_INLAND(0.03, 0.3),
        FAR_INLAND(0.3, 10.0);

        private double min;
        private double max;

        private ContLoc(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public static ContLoc getCont(double continentalness) {
            for (ContLoc c : ContLoc.values()) {
                if (!(continentalness >= c.min) || !(continentalness < c.max)) continue;
                return c;
            }
            throw new IllegalArgumentException("contloc out of spec value = " + continentalness);
        }
    }

    private static enum Ridges {
        VALLEYS(-1.0, -0.85),
        LOW(-0.85, -0.6),
        MID(-0.6, 0.2),
        HIGH(0.2, 0.7),
        PEAKS(0.7, 1.0);

        private double low;
        private double high;

        private Ridges(double low, double high) {
            this.low = low;
            this.high = high;
        }

        public static Ridges getRidge(double erosion) {
            for (Ridges r : Ridges.values()) {
                if (!(erosion >= r.low) || !(erosion < r.high)) continue;
                return r;
            }
            return MID;
        }
    }

    private static enum BadlandBiome {
        HZONE0(0, Biome.BADLANDS, Biome.ERODED_BADLANDS),
        HZONE1(1, Biome.BADLANDS, Biome.ERODED_BADLANDS),
        HZONE2(2, Biome.BADLANDS, Biome.BADLANDS),
        HZONE3(3, Biome.WOODED_BADLANDS, Biome.WOODED_BADLANDS),
        HZONE4(4, Biome.WOODED_BADLANDS, Biome.WOODED_BADLANDS);

        private int humidityZone;
        private Biome biome;
        private Biome biome2;

        private BadlandBiome(int h, Biome biome, Biome biome2) {
            this.humidityZone = h;
            this.biome = biome;
            this.biome2 = biome2;
        }

        public static Biome getBiome(int humidity, double weirdness) {
            for (BadlandBiome mb : BadlandBiome.values()) {
                if (mb.humidityZone != humidity) continue;
                if (weirdness < 0.0) {
                    return mb.biome;
                }
                return mb.biome2;
            }
            throw new IllegalArgumentException("badlands biome h = " + humidity);
        }
    }

    private static enum MiddleBiome {
        X00(0, 0, Biome.SNOWY_PLAINS, Biome.ICE_SPIKES),
        X01(0, 1, Biome.PLAINS, Biome.PLAINS),
        X02(0, 2, Biome.FLOWER_FOREST, Biome.SUNFLOWER_PLAINS),
        x03(0, 3, Biome.SAVANNA, Biome.SAVANNA),
        X04(0, 4, Biome.DESERT, Biome.DESERT),
        X10(1, 0, Biome.SNOWY_PLAINS, Biome.SNOWY_PLAINS),
        X11(1, 1, Biome.PLAINS, Biome.PLAINS),
        X12(1, 2, Biome.PLAINS, Biome.PLAINS),
        X13(1, 3, Biome.SAVANNA, Biome.SAVANNA),
        X14(1, 4, Biome.DESERT, Biome.DESERT),
        X20(2, 0, Biome.SNOWY_PLAINS, Biome.SNOWY_TAIGA),
        X21(2, 1, Biome.FOREST, Biome.FOREST),
        X22(2, 2, Biome.FOREST, Biome.FOREST),
        X23(2, 3, Biome.FOREST, Biome.PLAINS),
        X24(2, 4, Biome.DESERT, Biome.DESERT),
        X30(3, 0, Biome.SNOWY_TAIGA, Biome.SNOWY_TAIGA),
        X31(3, 1, Biome.TAIGA, Biome.TAIGA),
        X32(3, 2, Biome.BIRCH_FOREST, Biome.OLD_GROWTH_BIRCH_FOREST),
        X33(3, 3, Biome.JUNGLE, Biome.SPARSE_JUNGLE),
        X34(3, 4, Biome.DESERT, Biome.DESERT),
        X40(4, 0, Biome.TAIGA, Biome.TAIGA),
        X41(4, 1, Biome.OLD_GROWTH_SPRUCE_TAIGA, Biome.OLD_GROWTH_PINE_TAIGA),
        X42(4, 2, Biome.DARK_FOREST, Biome.DARK_FOREST),
        X43(4, 3, Biome.JUNGLE, Biome.BAMBOO_JUNGLE),
        X44(4, 4, Biome.DESERT, Biome.DESERT);

        private int temperature;
        private int humidity;
        private Biome biome;
        private Biome weirdBiome;

        private MiddleBiome(int h, int t, Biome b, Biome weirdBiome) {
            this.humidity = h;
            this.temperature = t;
            this.weirdBiome = weirdBiome;
            this.biome = b;
        }

        public static Biome getBiome(int humidity, int temperature, double weirdness) {
            for (MiddleBiome mb : MiddleBiome.values()) {
                if (mb.humidity != humidity || mb.temperature != temperature) continue;
                if (weirdness < 0.0) {
                    return mb.biome;
                }
                return mb.weirdBiome;
            }
            throw new IllegalArgumentException("middle biome h = " + humidity + " t = " + temperature);
        }
    }

    private static enum ShatteredBiome {
        X00(0, 0, Biome.WINDSWEPT_GRAVELLY_HILLS, Biome.WINDSWEPT_GRAVELLY_HILLS),
        X01(0, 1, Biome.WINDSWEPT_GRAVELLY_HILLS, Biome.WINDSWEPT_GRAVELLY_HILLS),
        X02(0, 2, Biome.WINDSWEPT_HILLS, Biome.WINDSWEPT_HILLS),
        X03(0, 3, Biome.SAVANNA, Biome.SAVANNA),
        X04(0, 4, Biome.DESERT, Biome.DESERT),
        X10(1, 0, Biome.WINDSWEPT_GRAVELLY_HILLS, Biome.WINDSWEPT_GRAVELLY_HILLS),
        X11(1, 1, Biome.WINDSWEPT_GRAVELLY_HILLS, Biome.WINDSWEPT_GRAVELLY_HILLS),
        X12(1, 2, Biome.WINDSWEPT_HILLS, Biome.WINDSWEPT_HILLS),
        X13(1, 3, Biome.SAVANNA_PLATEAU, Biome.SAVANNA_PLATEAU),
        X14(1, 4, Biome.DESERT, Biome.DESERT),
        X20(2, 0, Biome.WINDSWEPT_HILLS, Biome.WINDSWEPT_HILLS),
        X21(2, 1, Biome.WINDSWEPT_HILLS, Biome.WINDSWEPT_HILLS),
        X22(2, 2, Biome.WINDSWEPT_HILLS, Biome.WINDSWEPT_HILLS),
        X23(2, 3, Biome.FOREST, Biome.FOREST),
        X24(2, 4, Biome.DESERT, Biome.DESERT),
        X30(3, 0, Biome.WINDSWEPT_FOREST, Biome.WINDSWEPT_FOREST),
        X31(3, 1, Biome.WINDSWEPT_FOREST, Biome.WINDSWEPT_FOREST),
        X32(3, 2, Biome.WINDSWEPT_FOREST, Biome.WINDSWEPT_FOREST),
        X33(3, 3, Biome.JUNGLE, Biome.SPARSE_JUNGLE),
        X34(3, 4, Biome.DESERT, Biome.DESERT),
        X40(4, 0, Biome.WINDSWEPT_FOREST, Biome.WINDSWEPT_FOREST),
        X41(4, 1, Biome.WINDSWEPT_FOREST, Biome.WINDSWEPT_FOREST),
        X42(4, 2, Biome.WINDSWEPT_FOREST, Biome.WINDSWEPT_FOREST),
        X43(4, 3, Biome.JUNGLE, Biome.BAMBOO_JUNGLE),
        X44(4, 4, Biome.DESERT, Biome.DESERT);

        private int temperature;
        private int humidity;
        private Biome biome;
        private Biome weirdBiome;

        private ShatteredBiome(int h, int t, Biome b, Biome weirdBiome) {
            this.humidity = h;
            this.temperature = t;
            this.weirdBiome = weirdBiome;
            this.biome = b;
        }

        public static Biome getBiome(int h, int t, double we) {
            for (ShatteredBiome mb : ShatteredBiome.values()) {
                if (mb.humidity != h || mb.temperature != t) continue;
                if (we < 0.0) {
                    return mb.biome;
                }
                return mb.weirdBiome;
            }
            throw new IllegalArgumentException("shattered biome h = " + h + " t = " + t);
        }
    }

    private static enum PlateauBiome {
        X00(0, 0, Biome.SNOWY_PLAINS, Biome.ICE_SPIKES),
        x01(0, 1, Biome.MEADOW, Biome.CHERRY_GROVE),
        X02(0, 2, Biome.MEADOW, Biome.CHERRY_GROVE),
        x03(0, 3, Biome.SAVANNA_PLATEAU, Biome.SAVANNA_PLATEAU),
        X04(0, 4, Biome.BADLANDS, Biome.ERODED_BADLANDS),
        X10(1, 0, Biome.SNOWY_PLAINS, Biome.SNOWY_PLAINS),
        x11(1, 1, Biome.MEADOW, Biome.MEADOW),
        X12(1, 2, Biome.MEADOW, Biome.CHERRY_GROVE),
        x13(1, 3, Biome.SAVANNA_PLATEAU, Biome.SAVANNA_PLATEAU),
        X14(1, 4, Biome.BADLANDS, Biome.ERODED_BADLANDS),
        X20(2, 0, Biome.SNOWY_PLAINS, Biome.SNOWY_TAIGA),
        x21(2, 1, Biome.FOREST, Biome.MEADOW),
        X22(2, 2, Biome.MEADOW, Biome.BIRCH_FOREST),
        x23(2, 3, Biome.FOREST, Biome.FOREST),
        X24(2, 4, Biome.BADLANDS, Biome.BADLANDS),
        X30(3, 0, Biome.SNOWY_TAIGA, Biome.SNOWY_TAIGA),
        x31(3, 1, Biome.TAIGA, Biome.MEADOW),
        X32(3, 2, Biome.MEADOW, Biome.BIRCH_FOREST),
        x33(3, 3, Biome.FOREST, Biome.FOREST),
        X34(3, 4, Biome.WOODED_BADLANDS, Biome.WOODED_BADLANDS),
        X40(4, 0, Biome.SNOWY_TAIGA, Biome.SNOWY_TAIGA),
        X41(4, 1, Biome.OLD_GROWTH_SPRUCE_TAIGA, Biome.OLD_GROWTH_PINE_TAIGA),
        X42(4, 2, Biome.DARK_FOREST, Biome.DARK_FOREST),
        x43(4, 3, Biome.JUNGLE, Biome.JUNGLE),
        X44(4, 4, Biome.WOODED_BADLANDS, Biome.WOODED_BADLANDS);

        private int temp;
        private int humidity;
        private Biome b;
        private Biome weirdBiome;

        private PlateauBiome(int humidity, int temp, Biome b, Biome weirdBiome) {
            this.humidity = humidity;
            this.temp = temp;
            this.weirdBiome = weirdBiome;
            this.b = b;
        }

        public static Biome getBiome(int humidity, int temp, double weirdness) {
            for (PlateauBiome mb : PlateauBiome.values()) {
                if (mb.humidity != humidity || mb.temp != temp) continue;
                if (weirdness < 0.0) {
                    return mb.b;
                }
                return mb.weirdBiome;
            }
            throw new IllegalArgumentException("plateau biome h = " + humidity + " t = " + temp);
        }
    }
}

