/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed.generators.chunks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBlock;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintEntity;
import world.bentobox.bentobox.util.Pair;
import world.bentobox.boxed.Boxed;

public abstract class AbstractBoxedChunkGenerator
extends ChunkGenerator {
    protected final Boxed addon;
    protected static int size;
    protected final Map<Pair<Integer, Integer>, ChunkStore> chunks = new HashMap<Pair<Integer, Integer>, ChunkStore>();

    public AbstractBoxedChunkGenerator(Boxed addon) {
        this.addon = addon;
        size = (int)((double)addon.getSettings().getIslandDistance() / 16.0);
    }

    public void setChunk(int x, int z, Chunk chunk) {
        HashMap<Vector, Biome> chunkBiomes = new HashMap<Vector, Biome>();
        for (int xx = 0; xx < 16; xx += 4) {
            for (int zz = 0; zz < 16; zz += 4) {
                for (int yy = chunk.getWorld().getMinHeight(); yy < chunk.getWorld().getMaxHeight(); yy += 4) {
                    chunkBiomes.put(new Vector(xx, yy, zz), chunk.getBlock(xx, yy, zz).getBiome());
                }
            }
        }
        this.chunks.put((Pair<Integer, Integer>)new Pair((Object)x, (Object)z), new ChunkStore(chunk.getChunkSnapshot(), this.getEnts(chunk), this.getTileEnts(chunk), chunkBiomes));
    }

    protected abstract List<EntityData> getEnts(Chunk var1);

    protected abstract List<ChestData> getTileEnts(Chunk var1);

    public @Nullable ChunkStore getChunk(int x, int z) {
        return this.chunks.get(new Pair((Object)x, (Object)z));
    }

    public boolean canSpawn(World world, int x, int z) {
        return true;
    }

    public static int repeatCalc(int chunkCoord) {
        return Math.floorMod(chunkCoord + size, size * 2) - size;
    }

    public Map<Pair<Integer, Integer>, ChunkStore> getChunks() {
        return this.chunks;
    }

    public boolean shouldGenerateNoise() {
        return false;
    }

    public boolean shouldGenerateSurface() {
        return false;
    }

    public boolean shouldGenerateCaves() {
        return false;
    }

    public boolean shouldGenerateDecorations() {
        return false;
    }

    public boolean shouldGenerateMobs() {
        return true;
    }

    public boolean shouldGenerateStructures() {
        return this.addon.getSettings().isAllowStructures();
    }

    public record ChunkStore(ChunkSnapshot snapshot, List<EntityData> bpEnts, List<ChestData> chests, Map<Vector, Biome> chunkBiomes) {
    }

    public record ChestData(Vector relativeLoc, BlueprintBlock chest) {
    }

    public record EntityData(Vector relativeLoc, BlueprintEntity entity) {
    }
}

