/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed.generators.chunks;

import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Entity;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBlock;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintCreatureSpawner;
import world.bentobox.bentobox.util.Pair;
import world.bentobox.boxed.Boxed;
import world.bentobox.boxed.generators.chunks.AbstractBoxedChunkGenerator;
import world.bentobox.boxed.generators.chunks.BoxedChunkGenerator;

public class BoxedBlockPopulator
extends BlockPopulator {
    private final Boxed addon;

    public BoxedBlockPopulator(Boxed addon) {
        this.addon = addon;
    }

    public void populate(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, LimitedRegion limitedRegion) {
        Map<Pair<Integer, Integer>, AbstractBoxedChunkGenerator.ChunkStore> chunks = this.addon.getChunkGenerator(worldInfo.getEnvironment()).getChunks();
        World world = Bukkit.getWorld((UUID)worldInfo.getUID());
        int xx = BoxedChunkGenerator.repeatCalc(chunkX);
        int zz = BoxedChunkGenerator.repeatCalc(chunkZ);
        Pair coords = new Pair((Object)xx, (Object)zz);
        if (chunks.containsKey(coords)) {
            AbstractBoxedChunkGenerator.ChunkStore data = chunks.get(coords);
            data.bpEnts().forEach(e -> {
                Location l = this.getLoc(world, e.relativeLoc().clone(), chunkX, chunkZ);
                if (limitedRegion.isInRegion(l)) {
                    Entity ent = limitedRegion.spawnEntity(l, e.entity().getType());
                    e.entity().configureEntity(ent);
                }
            });
            limitedRegion.getTileEntities().forEach(te -> {
                int teX = BoxedChunkGenerator.repeatCalc(te.getX() >> 4);
                int teZ = BoxedChunkGenerator.repeatCalc(te.getZ() >> 4);
                if (teX == xx && teZ == zz) {
                    for (AbstractBoxedChunkGenerator.ChestData cd : data.chests()) {
                        Location chestLoc = this.getLoc(world, cd.relativeLoc().clone(), chunkX, chunkZ);
                        if (!limitedRegion.isInRegion(chestLoc) || !te.getLocation().equals((Object)chestLoc)) continue;
                        this.setBlockState((BlockState)te, cd.chest());
                    }
                }
            });
        }
    }

    private Location getLoc(World w, Vector v, int chunkX, int chunkZ) {
        v.add(new Vector(chunkX << 4, 0, chunkZ << 4));
        return v.toLocation(w);
    }

    public void setBlockState(BlockState bs, BlueprintBlock bpBlock) {
        if (bs instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)bs;
            Inventory ih = holder.getInventory();
            for (int i = 0; i < ih.getSize(); ++i) {
                ih.setItem(i, (ItemStack)bpBlock.getInventory().get(i));
            }
        } else if (bs instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)bs;
            this.setSpawner(spawner, bpBlock.getCreatureSpawner());
        } else if (bs instanceof Banner) {
            Banner banner = (Banner)bs;
            if (bpBlock.getBannerPatterns() != null) {
                bpBlock.getBannerPatterns().removeIf(Objects::isNull);
                banner.setPatterns(bpBlock.getBannerPatterns());
                banner.update(true, false);
            }
        }
    }

    public void setSpawner(CreatureSpawner spawner, BlueprintCreatureSpawner s) {
        spawner.setSpawnedType(s.getSpawnedType());
        spawner.setMaxNearbyEntities(s.getMaxNearbyEntities());
        int delay = Math.max(s.getMinSpawnDelay(), s.getMaxSpawnDelay());
        if (delay < 1) {
            delay = 120;
        }
        spawner.setMaxSpawnDelay(delay);
        delay = Math.max(s.getMinSpawnDelay(), 1);
        spawner.setMinSpawnDelay(delay);
        spawner.setDelay(s.getDelay());
        int range = Math.max(s.getRequiredPlayerRange(), 0);
        spawner.setRequiredPlayerRange(range);
        spawner.setSpawnRange(s.getSpawnRange());
        spawner.update(true, false);
    }
}

