/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed.generators.chunks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBlock;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintCreatureSpawner;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintEntity;
import world.bentobox.boxed.Boxed;
import world.bentobox.boxed.generators.chunks.AbstractBoxedChunkGenerator;
import world.bentobox.boxed.generators.chunks.BoxedBlockPopulator;

public class BoxedChunkGenerator
extends AbstractBoxedChunkGenerator {
    private final BlockPopulator boxedBlockPopulator;

    public BoxedChunkGenerator(Boxed addon) {
        super(addon);
        this.boxedBlockPopulator = new BoxedBlockPopulator(addon);
    }

    public BiomeProvider getDefaultBiomeProvider(WorldInfo worldInfo) {
        return this.addon.getBoxedBiomeProvider();
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        if (!world.getPopulators().contains(this.boxedBlockPopulator)) {
            world.getPopulators().add(this.boxedBlockPopulator);
        }
        return world.getPopulators();
    }

    @Override
    protected List<AbstractBoxedChunkGenerator.EntityData> getEnts(Chunk chunk) {
        return this.setEntities(Arrays.stream(chunk.getEntities()).filter(Objects::nonNull).filter(e -> !(e instanceof Player)).filter(e -> e instanceof LivingEntity).map(LivingEntity.class::cast).toList());
    }

    @Override
    protected List<AbstractBoxedChunkGenerator.ChestData> getTileEnts(Chunk chunk) {
        return Arrays.stream(chunk.getTileEntities()).map(t -> new AbstractBoxedChunkGenerator.ChestData(this.getLocInChunk(t.getLocation()), this.getBluePrintBlock(t.getBlock()))).toList();
    }

    private List<AbstractBoxedChunkGenerator.EntityData> setEntities(Collection<LivingEntity> entities) {
        ArrayList<AbstractBoxedChunkGenerator.EntityData> bpEnts = new ArrayList<AbstractBoxedChunkGenerator.EntityData>();
        for (LivingEntity entity : entities) {
            AbstractHorse horse;
            Colorable c;
            BlueprintEntity bpe = new BlueprintEntity();
            bpe.setType(entity.getType());
            bpe.setCustomName(entity.getCustomName());
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                this.setVillager(villager, bpe);
            }
            if (entity instanceof Colorable && (c = (Colorable)entity).getColor() != null) {
                bpe.setColor(c.getColor());
            }
            if (entity instanceof Tameable) {
                bpe.setTamed(Boolean.valueOf(((Tameable)entity).isTamed()));
            }
            if (entity instanceof ChestedHorse) {
                bpe.setChest(Boolean.valueOf(((ChestedHorse)entity).isCarryingChest()));
            }
            if (entity instanceof Ageable && !((Ageable)entity).isAdult()) {
                bpe.setAdult(Boolean.valueOf(false));
            }
            if (entity instanceof AbstractHorse) {
                horse = (AbstractHorse)entity;
                bpe.setDomestication(horse.getDomestication());
                bpe.setInventory(new HashMap());
                for (int i = 0; i < horse.getInventory().getSize(); ++i) {
                    ItemStack item = horse.getInventory().getItem(i);
                    if (item == null) continue;
                    bpe.getInventory().put(i, item);
                }
            }
            if (entity instanceof Horse) {
                horse = (Horse)entity;
                bpe.setStyle(horse.getStyle());
            }
            bpEnts.add(new AbstractBoxedChunkGenerator.EntityData(this.getLocInChunk(entity.getLocation()), bpe));
        }
        return bpEnts;
    }

    private Vector getLocInChunk(Location l) {
        return new Vector(Math.floorMod(l.getBlockX(), 16), l.getBlockY(), Math.floorMod(l.getBlockZ(), 16));
    }

    private void setVillager(Villager v, BlueprintEntity bpe) {
        bpe.setExperience(Integer.valueOf(v.getVillagerExperience()));
        bpe.setLevel(Integer.valueOf(v.getVillagerLevel()));
        bpe.setProfession(v.getProfession());
        bpe.setVillagerType(v.getVillagerType());
    }

    private BlueprintBlock getBluePrintBlock(Block block) {
        BlockState blockState = block.getState();
        BlueprintBlock b = new BlueprintBlock(block.getBlockData().getAsString());
        if (blockState instanceof Sign) {
            Sign sign = (Sign)blockState;
            b.setSignLines(Arrays.asList(sign.getLines()));
            b.setGlowingText(sign.isGlowingText());
        }
        if (blockState instanceof InventoryHolder) {
            InventoryHolder ih = (InventoryHolder)blockState;
            b.setInventory(new HashMap());
            for (int i = 0; i < ih.getInventory().getSize(); ++i) {
                ItemStack item = ih.getInventory().getItem(i);
                if (item == null) continue;
                b.getInventory().put(i, item);
            }
        }
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            b.setCreatureSpawner(this.getSpawner(spawner));
        }
        if (blockState instanceof Banner) {
            Banner banner = (Banner)blockState;
            b.setBannerPatterns(banner.getPatterns());
        }
        return b;
    }

    private BlueprintCreatureSpawner getSpawner(CreatureSpawner spawner) {
        BlueprintCreatureSpawner cs = new BlueprintCreatureSpawner();
        cs.setSpawnedType(spawner.getSpawnedType());
        cs.setDelay(spawner.getDelay());
        cs.setMaxNearbyEntities(spawner.getMaxNearbyEntities());
        cs.setMaxSpawnDelay(spawner.getMaxSpawnDelay());
        cs.setMinSpawnDelay(spawner.getMinSpawnDelay());
        cs.setRequiredPlayerRange(spawner.getRequiredPlayerRange());
        cs.setSpawnRange(spawner.getSpawnRange());
        return cs;
    }

    public void generateNoise(WorldInfo worldInfo, Random r, int chunkX, int chunkZ, ChunkGenerator.ChunkData cd) {
        int zz;
        int height = worldInfo.getMaxHeight();
        int minY = worldInfo.getMinHeight();
        int xx = BoxedChunkGenerator.repeatCalc(chunkX);
        AbstractBoxedChunkGenerator.ChunkStore chunk = this.getChunk(xx, zz = BoxedChunkGenerator.repeatCalc(chunkZ));
        if (chunk == null) {
            return;
        }
        this.copyChunkVerbatim(cd, chunk.snapshot(), minY, height);
    }

    private void copyChunkVerbatim(ChunkGenerator.ChunkData cd, ChunkSnapshot chunk, int minY, int height) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = minY; y < height; ++y) {
                    cd.setBlock(x, y, z, chunk.getBlockData(x, y, z));
                }
            }
        }
    }
}

