/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed.listeners;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.UUID;
import java.util.stream.StreamSupport;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.api.events.island.IslandNewIslandEvent;
import world.bentobox.bentobox.api.events.team.TeamJoinedEvent;
import world.bentobox.bentobox.api.events.team.TeamLeaveEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;
import world.bentobox.boxed.Boxed;

public class AdvancementListener
implements Listener {
    private static final Material[] MATS = Material.values();
    private final Boxed addon;
    private final Advancement netherAdvancement;
    private final Advancement netherFortressAdvancement;
    private final Advancement endAdvancement;
    private final Advancement netherRoot;
    private final Advancement endRoot;

    public AdvancementListener(Boxed addon) {
        this.addon = addon;
        this.netherAdvancement = AdvancementListener.getAdvancement("minecraft:story/enter_the_nether");
        this.endAdvancement = AdvancementListener.getAdvancement("minecraft:story/enter_the_end");
        this.netherFortressAdvancement = AdvancementListener.getAdvancement("minecraft:nether/find_fortress");
        this.netherRoot = AdvancementListener.getAdvancement("minecraft:nether/root");
        this.endRoot = AdvancementListener.getAdvancement("minecraft:end/root");
    }

    public static Advancement getAdvancement(String key) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Bukkit.advancementIterator(), 16), false).filter(a -> a.getKey().toString().equals(key)).findFirst().orElse(null);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onAdvancement(PlayerAdvancementDoneEvent e) {
        if (!e.getPlayer().getGameMode().equals((Object)GameMode.SURVIVAL) || this.addon.getSettings().isIgnoreAdvancements()) {
            return;
        }
        if (this.addon.inWorld(e.getPlayer().getWorld())) {
            if (this.addon.getSettings().isDenyVisitorAdvancements() && !this.addon.getIslands().getIslandAt(e.getPlayer().getLocation()).map(i -> i.getMemberSet().contains((Object)e.getPlayer().getUniqueId())).orElse(false).booleanValue()) {
                e.getAdvancement().getCriteria().forEach(c -> e.getPlayer().getAdvancementProgress(e.getAdvancement()).revokeCriteria(c));
                User u = User.getInstance((Player)e.getPlayer());
                if (u != null && this.addon.getAdvManager().getScore(e.getAdvancement().getKey().getKey()) > 0) {
                    u.notify("boxed.adv-disallowed", new String[]{"[name]", e.getPlayer().getName(), "[description]", this.keyToString(u, e.getAdvancement().getKey())});
                }
                return;
            }
            int score = this.addon.getAdvManager().addAdvancement(e.getPlayer(), e.getAdvancement());
            if (score != 0) {
                User user = User.getInstance((Player)e.getPlayer());
                Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> this.tellTeam(user, e.getAdvancement().getKey(), score));
            }
        }
    }

    private void tellTeam(User user, NamespacedKey key, int score) {
        Island island = this.addon.getIslands().getIsland(this.addon.getOverWorld(), user);
        if (island == null) {
            return;
        }
        island.getMemberSet().stream().map(User::getInstance).filter(User::isOnline).forEach(u -> {
            this.informPlayer((User)u, key, score);
            this.grantAdv((User)u, this.addon.getAdvManager().getIsland(island).getAdvancements());
        });
        if (this.addon.getSettings().isBroadcastAdvancements()) {
            Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("bukkit.broadcast.user")).map(User::getInstance).forEach(u -> u.sendMessage("boxed.user-completed", new String[]{"[name]", user.getName(), "[description]", this.keyToString((User)u, key)}));
        }
    }

    public void syncAdvancements(User user) {
        if (this.addon.getSettings().isIgnoreAdvancements()) {
            return;
        }
        Island box = this.addon.getIslands().getIsland(this.addon.getOverWorld(), user);
        if (box != null) {
            this.grantAdv(user, this.addon.getAdvManager().getIsland(box).getAdvancements());
            int diff = this.addon.getAdvManager().checkIslandSize(box);
            if (diff > 0) {
                user.sendMessage("boxed.size-changed", new String[]{"[number]", String.valueOf(diff)});
                user.getPlayer().playSound(Objects.requireNonNull(user.getLocation()), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
            } else if (diff < 0) {
                user.sendMessage("boxed.size-decreased", new String[]{"[number]", String.valueOf(Math.abs(diff))});
                user.getPlayer().playSound(Objects.requireNonNull(user.getLocation()), Sound.ENTITY_VILLAGER_DEATH, 1.0f, 2.0f);
            }
        }
    }

    private void informPlayer(User user, NamespacedKey key, int score) {
        user.getPlayer().playSound(Objects.requireNonNull(user.getLocation()), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
        user.sendMessage("boxed.completed", new String[]{"[name]", this.keyToString(user, key)});
        user.sendMessage("boxed.size-changed", new String[]{"[number]", String.valueOf(score)});
    }

    private String keyToString(User user, NamespacedKey key) {
        String adv = user.getTranslationOrNothing("boxed.advancements." + key.toString(), new String[0]);
        if (adv.isEmpty()) {
            adv = Util.prettifyText((String)key.getKey().substring(key.getKey().lastIndexOf("/") + 1));
        }
        return adv;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPortal(PlayerPortalEvent e) {
        if (!this.addon.inWorld(e.getPlayer().getWorld()) || !e.getPlayer().getGameMode().equals((Object)GameMode.SURVIVAL) || this.addon.getSettings().isIgnoreAdvancements()) {
            return;
        }
        if (e.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.NETHER_PORTAL)) {
            AdvancementListener.giveAdv(e.getPlayer(), this.netherAdvancement);
            AdvancementListener.giveAdv(e.getPlayer(), this.netherRoot);
        } else if (e.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.END_PORTAL)) {
            AdvancementListener.giveAdv(e.getPlayer(), this.endAdvancement);
            AdvancementListener.giveAdv(e.getPlayer(), this.endRoot);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent e) {
        if (!this.addon.getSettings().isNetherGenerate() || !Util.sameWorld((World)e.getPlayer().getWorld(), (World)this.addon.getNetherWorld()) || this.addon.getSettings().isIgnoreAdvancements()) {
            return;
        }
        if (e.getTo().getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.NETHER_BRICKS)) {
            AdvancementListener.giveAdv(e.getPlayer(), this.netherFortressAdvancement);
        }
    }

    public static void giveAdv(Player player, Advancement adv) {
        if (adv != null && !player.getAdvancementProgress(adv).isDone()) {
            adv.getCriteria().forEach(arg_0 -> ((AdvancementProgress)player.getAdvancementProgress(adv)).awardCriteria(arg_0));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent e) {
        User user = User.getInstance((Player)e.getPlayer());
        if (this.addon.inWorld(e.getPlayer().getWorld())) {
            this.syncAdvancements(user);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerEnterWorld(PlayerChangedWorldEvent e) {
        User user = User.getInstance((Player)e.getPlayer());
        if (Util.sameWorld((World)this.addon.getOverWorld(), (World)e.getPlayer().getWorld())) {
            this.syncAdvancements(user);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTeamJoinTime(TeamJoinedEvent e) {
        User user = User.getInstance((UUID)e.getPlayerUUID());
        if (user != null && this.addon.getSettings().isOnJoinResetAdvancements() && user.isOnline() && this.addon.getOverWorld().equals((Object)Util.getWorld((World)user.getWorld()))) {
            this.clearAndSetAdv(user, this.addon.getSettings().isOnJoinResetAdvancements(), this.addon.getSettings().getOnJoinGrantAdvancements());
            this.syncAdvancements(user);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTeamLeaveTime(TeamLeaveEvent e) {
        if (this.addon.getSettings().isIgnoreAdvancements()) {
            return;
        }
        User user = User.getInstance((UUID)e.getPlayerUUID());
        if (user != null && this.addon.getSettings().isOnJoinResetAdvancements() && user.isOnline() && this.addon.getOverWorld().equals((Object)Util.getWorld((World)user.getWorld()))) {
            this.clearAndSetAdv(user, this.addon.getSettings().isOnLeaveResetAdvancements(), this.addon.getSettings().getOnLeaveGrantAdvancements());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFirstTime(IslandNewIslandEvent e) {
        if (this.addon.getSettings().isIgnoreAdvancements()) {
            return;
        }
        User user = User.getInstance((UUID)e.getPlayerUUID());
        if (user != null) {
            this.clearAndSetAdv(user, this.addon.getSettings().isOnJoinResetAdvancements(), this.addon.getSettings().getOnJoinGrantAdvancements());
        }
    }

    private void clearAndSetAdv(User user, boolean clear, List<String> list) {
        if (!user.isOnline()) {
            return;
        }
        if (clear) {
            this.clearAdv(user);
        }
        this.grantAdv(user, list);
    }

    private void grantAdv(User user, List<String> list) {
        Iterator it = Bukkit.advancementIterator();
        while (it.hasNext()) {
            Advancement a = (Advancement)it.next();
            AdvancementProgress progress = user.getPlayer().getAdvancementProgress(a);
            if (!list.contains(a.getKey().toString()) || progress.isDone()) continue;
            a.getCriteria().forEach(arg_0 -> ((AdvancementProgress)progress).awardCriteria(arg_0));
        }
    }

    private void clearAdv(User user) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.addon.getPlugin(), () -> Arrays.stream(Statistic.values()).forEach(s -> this.resetStats(user, (Statistic)s)));
        Iterator it = Bukkit.advancementIterator();
        while (it.hasNext()) {
            Advancement a = (Advancement)it.next();
            AdvancementProgress p = user.getPlayer().getAdvancementProgress(a);
            p.getAwardedCriteria().forEach(arg_0 -> ((AdvancementProgress)p).revokeCriteria(arg_0));
        }
    }

    private void resetStats(User user, Statistic s) {
        switch (s.getType()) {
            case BLOCK: {
                Arrays.stream(MATS).filter(Material::isBlock).forEach(m -> user.getPlayer().setStatistic(s, m, 0));
                break;
            }
            case ITEM: {
                Arrays.stream(MATS).filter(Material::isItem).forEach(m -> user.getPlayer().setStatistic(s, m, 0));
                break;
            }
            case ENTITY: {
                Arrays.stream(EntityType.values()).filter(EntityType::isAlive).forEach(m -> user.getPlayer().setStatistic(s, m, 0));
                break;
            }
            case UNTYPED: {
                user.getPlayer().setStatistic(s, 0);
            }
        }
    }
}

