/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed.listeners;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;
import world.bentobox.boxed.Boxed;

public class EnderPearlListener
implements Listener {
    private final Boxed addon;
    private Set<Player> movingPlayer = new HashSet<Player>();

    public EnderPearlListener(Boxed addon) {
        this.addon = addon;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        if (e.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && this.movingPlayer.contains(e.getPlayer())) {
            this.movingPlayer.remove(e.getPlayer());
            return;
        }
        if (!this.addon.inWorld(e.getFrom()) || !e.getPlayer().getGameMode().equals((Object)GameMode.SURVIVAL) || e.getTo() != null && !this.addon.inWorld(e.getTo()) || this.addon.getIslands().getSpawn(e.getFrom().getWorld()).map(spawn -> spawn.onIsland(e.getTo())).orElse(false).booleanValue()) {
            return;
        }
        User u = User.getInstance((Player)e.getPlayer());
        if (e.getTo() != null) {
            this.addon.getIslands().getIslandAt(e.getTo()).ifPresent(i -> {
                if (!i.onIsland(e.getTo())) {
                    u.sendMessage("boxed.general.errors.no-teleport-outside", new String[0]);
                    this.addon.logWarning(e.getPlayer().getName() + " tried to teleport outside of their box from " + String.valueOf(e.getFrom()) + " to " + String.valueOf(e.getTo()));
                    e.setCancelled(true);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEnderPearlLand(ProjectileHitEvent e) {
        EnderPearl ep;
        if (!(e.getEntityType().equals((Object)EntityType.ENDER_PEARL) && e.getHitBlock() != null && this.addon.inWorld(e.getHitBlock().getLocation()) && Boxed.ALLOW_MOVE_BOX.isSetForWorld(e.getHitBlock().getWorld()))) {
            return;
        }
        Location l = e.getHitBlock().getRelative(BlockFace.UP).getLocation();
        World w = e.getHitBlock().getWorld();
        Projectile projectile = e.getEntity();
        if (projectile instanceof EnderPearl && (projectile = (ep = (EnderPearl)projectile).getShooter()) instanceof Player) {
            Player player = (Player)projectile;
            User u = User.getInstance((Player)player);
            Island is = this.addon.getIslands().getIsland(w, u);
            if (is == null) {
                return;
            }
            this.addon.getIslands().getIslandAt(u.getLocation()).ifPresent(fromIsland -> {
                if (!is.getUniqueId().equals(fromIsland.getUniqueId())) {
                    return;
                }
                this.addon.getIslands().getIslandAt(l).ifPresentOrElse(toIsland -> {
                    if (fromIsland.getUniqueId().equals(toIsland.getUniqueId())) {
                        if (!toIsland.onIsland(l)) {
                            this.moveBox(u, (Island)fromIsland, l);
                            Util.teleportAsync((Entity)player, (Location)l, (PlayerTeleportEvent.TeleportCause)PlayerTeleportEvent.TeleportCause.ENDER_PEARL);
                        }
                    } else {
                        e.setCancelled(true);
                        u.sendMessage("boxed.general.errors.no-teleport-outside", new String[0]);
                        this.addon.logWarning("Enderpearl: " + player.getName() + " tried to teleport between boxes from " + String.valueOf(fromIsland.getCenter()) + " to " + String.valueOf(toIsland.getCenter()));
                    }
                }, () -> {
                    e.setCancelled(true);
                    u.sendMessage("boxed.general.errors.no-teleport-outside", new String[0]);
                    this.addon.logWarning("Enderpearl: " + player.getName() + " tried to teleport between boxes from " + String.valueOf(fromIsland.getCenter()) + " to some place outside");
                });
            });
        }
    }

    private void moveBox(User u, Island fromIsland, Location l) {
        fromIsland.getMemberSet().forEach(uuid -> this.addon.getIslands().setHomeLocation(uuid, l));
        try {
            fromIsland.setProtectionCenter(l);
            fromIsland.setSpawnPoint(l.getWorld().getEnvironment(), l);
            u.getPlayer().playSound(l, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 2.0f);
            this.movingPlayer.add(u.getPlayer());
        }
        catch (IOException e1) {
            this.addon.logError("Could not move box " + e1.getMessage());
        }
    }
}

