/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed.listeners;

import com.google.common.base.Enums;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.loot.LootTables;
import org.bukkit.plugin.Plugin;
import org.bukkit.structure.Structure;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.events.BentoBoxReadyEvent;
import world.bentobox.bentobox.api.events.island.IslandCreatedEvent;
import world.bentobox.bentobox.api.events.island.IslandDeleteEvent;
import world.bentobox.bentobox.api.events.island.IslandResettedEvent;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Pair;
import world.bentobox.bentobox.util.Util;
import world.bentobox.boxed.Boxed;
import world.bentobox.boxed.objects.BoxedJigsawBlock;
import world.bentobox.boxed.objects.BoxedStructureBlock;
import world.bentobox.boxed.objects.IslandStructures;
import world.bentobox.boxed.objects.ToBePlacedStructures;

public class NewAreaListener
implements Listener {
    private static final Map<Integer, EntityType> BUTCHER_ANIMALS = Map.of(0, EntityType.COW, 1, EntityType.SHEEP, 2, EntityType.PIG);
    private static final List<BlockFace> CARDINALS = List.of(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);
    private static final List<String> JAR_STRUCTURES = List.of("bee", "pillager", "polar_bear", "axolotl", "allay", "parrot", "frog");
    private static final List<String> STRUCTURES = List.of("ancient_city", "bastion_remnant", "bastion", "buried_treasure", "desert_pyramid", "end_city", "fortress", "igloo", "jungle_pyramid", "mansion", "mineshaft", "mineshaft_mesa", "monument", "nether_fossil", "ocean_ruin_cold", "ocean_ruin_warm", "pillager_outpost", "ruined_portal_desert", "ruined_portal_jungle", "ruined_portal_mountain", "ruined_portal_nether", "ruined_portal_ocean", "ruined_portal_swamp", "ruined_portal", "shipwreck_beached", "shipwreck", "stronghold", "swamp_hut", "village_desert", "village_plains", "village_savanna", "village_snowy", "village_taiga");
    private final Boxed addon;
    private final File structureFile;
    private final Queue<ToBePlacedStructures.StructureRecord> itemsToBuild = new LinkedList<ToBePlacedStructures.StructureRecord>();
    private final Map<Pair<Integer, Integer>, List<ToBePlacedStructures.StructureRecord>> pending;
    private final Map<String, IslandStructures> islandStructureCache = new HashMap<String, IslandStructures>();
    private static final Random rand = new Random();
    private boolean pasting = true;
    private static final Gson gson = new Gson();
    private static final String TODO = "ToDo";
    private static final String COULD_NOT_LOAD = "Could not load ";
    private final Database<IslandStructures> handler;
    private final Database<ToBePlacedStructures> toPlace;
    private static String bukkitVersion = "v" + Bukkit.getBukkitVersion().replace('.', '_').replace('-', '_');
    private static String pluginPackageName;

    public NewAreaListener(Boxed addon) {
        this.addon = addon;
        pluginPackageName = ((Object)((Object)addon)).getClass().getPackage().getName();
        addon.saveResource("structures.yml", false);
        this.structureFile = new File(addon.getDataFolder(), "structures.yml");
        this.handler = new Database((Addon)addon, IslandStructures.class);
        this.toPlace = new Database((Addon)addon, ToBePlacedStructures.class);
        this.pending = this.loadToDos().getReadyToBuild();
        this.runStructurePrinter();
    }

    private void runStructurePrinter() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.addon.getPlugin(), this::buildStructure, 100L, 60L);
        for (String js : JAR_STRUCTURES) {
            this.addon.saveResource("structures/" + js + ".nbt", false);
            File structureFile = new File(this.addon.getDataFolder(), "structures/" + js + ".nbt");
            try {
                Structure s = Bukkit.getStructureManager().loadStructure(structureFile);
                Bukkit.getStructureManager().registerStructure(NamespacedKey.fromString((String)("minecraft:boxed/" + js)), s);
                this.addon.log("Loaded " + js + ".nbt");
            }
            catch (IOException e) {
                this.addon.logError("Error trying to load " + structureFile.getAbsolutePath());
                this.addon.getPlugin().logStacktrace((Throwable)e);
            }
        }
    }

    private void buildStructure() {
        if (!this.pasting && !this.itemsToBuild.isEmpty()) {
            ToBePlacedStructures.StructureRecord item = this.itemsToBuild.poll();
            this.placeStructure(item);
        }
    }

    private void placeStructure(ToBePlacedStructures.StructureRecord item) {
        this.pasting = true;
        Structure structure = Bukkit.getStructureManager().loadStructure(NamespacedKey.fromString((String)item.structure()));
        if (structure == null) {
            BentoBox.getInstance().logError(COULD_NOT_LOAD + item.structure());
            return;
        }
        structure.place(item.location(), true, item.rot(), item.mirror(), -1, 1.0f, rand);
        this.addon.log(item.name() + " placed at " + item.location().getWorld().getName() + " " + Util.xyz((Vector)item.location().toVector()));
        BoundingBox bb = NewAreaListener.removeJigsaw(item);
        this.addon.getIslands().getIslandAt(item.location()).map(Island::getUniqueId).ifPresent(id -> {
            if (item.location().getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
                this.getIslandStructData((String)id).addNetherStructure(bb, item.name());
            } else {
                this.getIslandStructData((String)id).addStructure(bb, item.name());
            }
            this.handler.saveObjectAsync((Object)this.getIslandStructData((String)id));
        });
        this.pasting = false;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBentoBoxReady(BentoBoxReadyEvent event) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.addon.getPlugin(), () -> {
            this.addon.saveResource("templates.yml", false);
            File templateFile = new File(this.addon.getDataFolder(), "templates.yml");
            if (templateFile.exists()) {
                YamlConfiguration loader = YamlConfiguration.loadConfiguration((File)templateFile);
                List list = loader.getStringList("templates");
                for (String struct : list) {
                    if (struct.endsWith("/")) continue;
                    Bukkit.getStructureManager().loadStructure(NamespacedKey.fromString((String)struct));
                }
            }
            this.pasting = false;
        });
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent e) {
        Chunk chunk = e.getChunk();
        if (!this.addon.inWorld(chunk.getWorld())) {
            return;
        }
        Pair chunkCoords = new Pair((Object)chunk.getX(), (Object)chunk.getZ());
        if (this.pending.containsKey(chunkCoords)) {
            Iterator<ToBePlacedStructures.StructureRecord> it = this.pending.get(chunkCoords).iterator();
            while (it.hasNext()) {
                ToBePlacedStructures.StructureRecord item = it.next();
                if (!item.location().getWorld().equals((Object)e.getWorld())) continue;
                this.itemsToBuild.add(item);
                it.remove();
            }
            ToBePlacedStructures tbd = new ToBePlacedStructures();
            tbd.setReadyToBuild(this.pending);
            this.toPlace.saveObjectAsync((Object)tbd);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        if (!this.addon.inWorld(e.getFrom().getWorld()) || e.getFrom().toVector().equals((Object)e.getTo().toVector())) {
            return;
        }
        this.addon.getIslands().getIslandAt(e.getTo()).ifPresent(island -> {
            String islandId = island.getUniqueId();
            IslandStructures is = this.getIslandStructData(islandId);
            Map<BoundingBox, String> structures = e.getTo().getWorld().getEnvironment().equals((Object)World.Environment.NETHER) ? is.getNetherStructureBoundingBoxMap() : is.getStructureBoundingBoxMap();
            for (Map.Entry<BoundingBox, String> en : structures.entrySet()) {
                if (!en.getKey().contains(e.getTo().toVector())) continue;
                for (String s : STRUCTURES) {
                    if (!en.getValue().startsWith(s)) continue;
                    this.giveAdvFromCriteria(e.getPlayer(), s);
                }
            }
        });
    }

    private void giveAdvFromCriteria(Player player, String string) {
        Bukkit.advancementIterator().forEachRemaining(ad -> {
            if (!player.getAdvancementProgress(ad).isDone()) {
                for (String crit : ad.getCriteria()) {
                    if (!crit.equals(string)) continue;
                    player.getAdvancementProgress(ad).awardCriteria(crit);
                    break;
                }
            }
        });
    }

    private IslandStructures getIslandStructData(String islandId) {
        if (this.islandStructureCache.containsKey(islandId)) {
            return this.islandStructureCache.get(islandId);
        }
        IslandStructures struct = this.handler.objectExists(islandId) ? (IslandStructures)this.handler.loadObject(islandId) : new IslandStructures(islandId);
        this.islandStructureCache.put(islandId, struct);
        return struct;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onIslandCreated(IslandCreatedEvent event) {
        this.setUpIsland(event.getIsland());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onIslandReset(IslandResettedEvent event) {
        this.setUpIsland(event.getIsland());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onIslandDeleted(IslandDeleteEvent event) {
        String deletedIslandId = event.getIsland().getUniqueId();
        this.islandStructureCache.remove(deletedIslandId);
        for (List<ToBePlacedStructures.StructureRecord> records : this.pending.values()) {
            records.removeIf(record -> event.getIsland().inIslandSpace(record.location()));
        }
        this.pending.values().removeIf(list -> list.isEmpty());
        Map<Pair<Integer, Integer>, List<ToBePlacedStructures.StructureRecord>> readyToBuild = this.loadToDos().getReadyToBuild();
        boolean dbChanged = false;
        for (List<ToBePlacedStructures.StructureRecord> records : readyToBuild.values()) {
            if (!records.removeIf(record -> event.getIsland().inIslandSpace(record.location()))) continue;
            dbChanged = true;
        }
        if (dbChanged) {
            ToBePlacedStructures tbd = new ToBePlacedStructures();
            tbd.setReadyToBuild(readyToBuild);
            this.toPlace.saveObjectAsync((Object)tbd);
        }
    }

    private void setUpIsland(Island island) {
        if (!this.addon.inWorld(island.getWorld())) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.structureFile);
        Location center = island.getProtectionCenter();
        for (String env : config.getKeys(false)) {
            World.Environment e = (World.Environment)Enums.getIfPresent(World.Environment.class, (String)env.toUpperCase(Locale.ENGLISH)).orNull();
            if (e == null) {
                this.addon.logError("Error in structures.yml - unknown environment " + env);
                continue;
            }
            this.place(config.getConfigurationSection(env), center, e);
        }
    }

    private void place(ConfigurationSection section, Location center, World.Environment env) {
        World world;
        if (section == null) {
            return;
        }
        World world2 = world = env.equals((Object)World.Environment.NORMAL) ? this.addon.getOverWorld() : this.addon.getNetherWorld();
        if (world == null) {
            return;
        }
        HashMap<Pair, List> readyToBuild = new HashMap<Pair, List>();
        for (String vector : section.getKeys(false)) {
            String[] nameParts = section.getString(vector).split(",");
            String name = nameParts[0].strip();
            StructureRotation rotation = nameParts.length > 1 ? (StructureRotation)Enums.getIfPresent(StructureRotation.class, (String)nameParts[1].strip().toUpperCase(Locale.ENGLISH)).or((Object)StructureRotation.NONE) : StructureRotation.NONE;
            Mirror mirror = nameParts.length > 2 ? (Mirror)Enums.getIfPresent(Mirror.class, (String)nameParts[2].strip().toUpperCase(Locale.ENGLISH)).or((Object)Mirror.NONE) : Mirror.NONE;
            boolean noMobs = nameParts.length > 3 && "NO_MOBS".equalsIgnoreCase(nameParts[3].strip());
            Structure structure = Bukkit.getStructureManager().loadStructure(NamespacedKey.fromString((String)("minecraft:" + name)));
            if (structure == null) {
                BentoBox.getInstance().logError(COULD_NOT_LOAD + name);
                return;
            }
            Object[] coords = vector.split(",");
            if (coords.length > 2) {
                int x = Integer.parseInt(coords[0].strip()) + center.getBlockX();
                int y = Integer.parseInt(((String)coords[1]).strip());
                int z = Integer.parseInt(((String)coords[2]).strip()) + center.getBlockZ();
                Location location = new Location(world, (double)x, (double)y, (double)z);
                readyToBuild.computeIfAbsent(new Pair((Object)(x >> 4), (Object)(z >> 4)), k -> new ArrayList()).add(new ToBePlacedStructures.StructureRecord(name, "minecraft:" + name, location, rotation, mirror, noMobs, Collections.emptyMap()));
                this.itemsToBuild.add(new ToBePlacedStructures.StructureRecord(name, "minecraft:" + name, location, rotation, mirror, noMobs, Collections.emptyMap()));
                continue;
            }
            this.addon.logError("Structure file syntax error: " + vector + ": " + Arrays.toString(coords));
        }
        ToBePlacedStructures tbd = this.loadToDos();
        Map<Pair<Integer, Integer>, List<ToBePlacedStructures.StructureRecord>> mergedMap = tbd.getReadyToBuild();
        readyToBuild.forEach((key, value) -> mergedMap.merge((Pair<Integer, Integer>)key, (List<ToBePlacedStructures.StructureRecord>)value, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }));
        tbd.setReadyToBuild(mergedMap);
        this.toPlace.saveObjectAsync((Object)tbd);
    }

    public static BoundingBox removeJigsaw(ToBePlacedStructures.StructureRecord item) {
        Location loc = item.location();
        Structure structure = Bukkit.getStructureManager().loadStructure(NamespacedKey.fromString((String)item.structure()));
        if (structure == null) {
            BentoBox.getInstance().logError(COULD_NOT_LOAD + item.structure());
            return new BoundingBox();
        }
        StructureRotation structureRotation = item.rot();
        String key = item.name();
        Location otherCorner = switch (structureRotation) {
            default -> throw new MatchException(null, null);
            case StructureRotation.CLOCKWISE_180 -> loc.clone().add(new Vector(-structure.getSize().getX(), structure.getSize().getY(), -structure.getSize().getZ()));
            case StructureRotation.CLOCKWISE_90 -> loc.clone().add(new Vector(-structure.getSize().getZ(), structure.getSize().getY(), structure.getSize().getX()));
            case StructureRotation.COUNTERCLOCKWISE_90 -> loc.clone().add(new Vector(structure.getSize().getZ(), structure.getSize().getY(), -structure.getSize().getX()));
            case StructureRotation.NONE -> loc.clone().add(new Vector(structure.getSize().getX(), structure.getSize().getY(), structure.getSize().getZ()));
        };
        BoundingBox bb = BoundingBox.of((Location)loc, (Location)otherCorner);
        int x = (int)bb.getMinX();
        while ((double)x <= bb.getMaxX()) {
            int y = (int)bb.getMinY();
            while ((double)y <= bb.getMaxY()) {
                int z = (int)bb.getMinZ();
                while ((double)z <= bb.getMaxZ()) {
                    Block b = loc.getWorld().getBlockAt(x, y, z);
                    if (b.getType().equals((Object)Material.JIGSAW)) {
                        NewAreaListener.processJigsaw(b, structureRotation, item.noMobs() == false);
                    } else if (b.getType().equals((Object)Material.STRUCTURE_BLOCK)) {
                        NewAreaListener.processStructureBlock(b);
                    }
                    if (key.contains("underwater_ruin") && b.getType().equals((Object)Material.AIR)) {
                        b.setType(Material.WATER);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return bb;
    }

    private static void processStructureBlock(Block b) {
        Block downBlock;
        String data = Util.getMetaData().nmsData(b);
        if (data.isEmpty()) {
            return;
        }
        BoxedStructureBlock bsb = (BoxedStructureBlock)gson.fromJson(data, BoxedStructureBlock.class);
        b.setType(Material.STRUCTURE_VOID);
        Enums.getIfPresent(EntityType.class, (String)bsb.getMetadata().toUpperCase(Locale.ENGLISH)).toJavaUtil().ifPresent(type -> b.getWorld().spawnEntity(b.getRelative(BlockFace.UP).getLocation(), type));
        if (bsb.getMetadata().contains("chest") && (downBlock = b.getRelative(BlockFace.DOWN)).getType().equals((Object)Material.CHEST)) {
            Waterlogged wl;
            Chest chest = (Chest)downBlock.getState();
            chest.setLootTable(LootTables.BURIED_TREASURE.getLootTable());
            chest.update();
            BlockData blockData = chest.getBlockData();
            if (blockData instanceof Waterlogged && (wl = (Waterlogged)blockData).isWaterlogged()) {
                b.setType(Material.WATER);
            }
        }
    }

    private static void processJigsaw(Block b, StructureRotation structureRotation, boolean pasteMobs) {
        try {
            String data = Util.getMetaData().nmsData(b);
            if (data.isEmpty()) {
                return;
            }
            BoxedJigsawBlock bjb = (BoxedJigsawBlock)gson.fromJson(data, BoxedJigsawBlock.class);
            String finalState = NewAreaListener.correctDirection(bjb.getFinal_state(), structureRotation);
            BlockData bd = Bukkit.createBlockData((String)finalState);
            b.setBlockData(bd);
            if (!bjb.getPool().equalsIgnoreCase("minecraft:empty") && pasteMobs) {
                NewAreaListener.spawnMob(b, bjb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void spawnMob(Block b, BoxedJigsawBlock bjb) {
        Entity e;
        EntityType type;
        switch (bjb.getPool()) {
            case "minecraft:bastion/mobs/piglin": {
                EntityType entityType = EntityType.PIGLIN;
                break;
            }
            case "minecraft:bastion/mobs/hoglin": {
                EntityType entityType = EntityType.HOGLIN;
                break;
            }
            case "minecraft:bastion/mobs/piglin_melee": {
                EntityType entityType = EntityType.PIGLIN_BRUTE;
                break;
            }
            case "minecraft:village/common/cats": {
                EntityType entityType = EntityType.CAT;
                break;
            }
            case "minecraft:village/common/horses": {
                EntityType entityType = EntityType.HORSE;
                break;
            }
            case "minecraft:village/common/sheep": {
                EntityType entityType = EntityType.SHEEP;
                break;
            }
            case "minecraft:village/common/pigs": {
                EntityType entityType = EntityType.PIG;
                break;
            }
            case "minecraft:village/common/cows": {
                EntityType entityType = EntityType.COW;
                break;
            }
            case "minecraft:village/common/iron_golem": {
                EntityType entityType = EntityType.IRON_GOLEM;
                break;
            }
            case "minecraft:village/common/butcher_animals": 
            case "minecraft:village/common/animals": {
                EntityType entityType = BUTCHER_ANIMALS.get(rand.nextInt(3));
                break;
            }
            default: {
                EntityType entityType = type = null;
            }
        }
        if (type == null && bjb.getPool().startsWith("minecraft:boxed/")) {
            String entString = bjb.getPool().toUpperCase(Locale.ENGLISH).substring(16, bjb.getPool().length());
            type = (EntityType)Enums.getIfPresent(EntityType.class, (String)entString).orNull();
        }
        if (bjb.getPool().contains("zombie/villagers")) {
            type = EntityType.ZOMBIE_VILLAGER;
        } else if (bjb.getPool().contains("villagers")) {
            type = EntityType.VILLAGER;
        }
        if (type != null && (e = b.getWorld().spawnEntity(b.getRelative(BlockFace.UP).getLocation(), type)) != null) {
            e.setPersistent(true);
        }
    }

    private static String correctDirection(String finalState, StructureRotation sr) {
        if (sr.equals((Object)StructureRotation.NONE)) {
            return finalState;
        }
        BlockFace oldDirection = NewAreaListener.getDirection(finalState);
        BlockFace newDirection = NewAreaListener.getNewDirection(oldDirection, sr);
        if (newDirection.equals((Object)BlockFace.SELF)) {
            return finalState;
        }
        return finalState.replace(oldDirection.name().toLowerCase(Locale.ENGLISH), newDirection.name().toLowerCase(Locale.ENGLISH));
    }

    private static BlockFace getNewDirection(BlockFace oldDirection, StructureRotation sr) {
        if (sr.equals((Object)StructureRotation.CLOCKWISE_180)) {
            return oldDirection.getOppositeFace();
        }
        if (sr.equals((Object)StructureRotation.CLOCKWISE_90)) {
            return switch (oldDirection) {
                case BlockFace.EAST -> BlockFace.SOUTH;
                case BlockFace.NORTH -> BlockFace.EAST;
                case BlockFace.SOUTH -> BlockFace.WEST;
                case BlockFace.WEST -> BlockFace.NORTH;
                default -> BlockFace.SELF;
            };
        }
        if (sr.equals((Object)StructureRotation.COUNTERCLOCKWISE_90)) {
            return switch (oldDirection) {
                case BlockFace.EAST -> BlockFace.NORTH;
                case BlockFace.NORTH -> BlockFace.WEST;
                case BlockFace.SOUTH -> BlockFace.EAST;
                case BlockFace.WEST -> BlockFace.SOUTH;
                default -> BlockFace.SELF;
            };
        }
        return BlockFace.SELF;
    }

    private static BlockFace getDirection(String finalState) {
        return CARDINALS.stream().filter(bf -> finalState.contains(bf.name().toLowerCase(Locale.ENGLISH))).findFirst().orElse(BlockFace.SELF);
    }

    private ToBePlacedStructures loadToDos() {
        if (!this.toPlace.objectExists(TODO)) {
            return new ToBePlacedStructures();
        }
        ToBePlacedStructures list = (ToBePlacedStructures)this.toPlace.loadObject(TODO);
        if (list == null) {
            return new ToBePlacedStructures();
        }
        if (!list.getReadyToBuild().isEmpty()) {
            this.addon.log("Loaded " + list.getReadyToBuild().size() + " structure todos.");
        }
        return list;
    }
}

