/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface SchemaValidator<T> {
    public ValidationResult validate(T var1);

    public DetailedValidationResult validateDetailed(T var1);

    public String getSupportedSchemaVersion();

    public boolean isCompatibleWith(String var1);

    public static class DetailedValidationResult {
        private final boolean valid;
        private final List<String> errors;
        private final List<String> warnings;

        public DetailedValidationResult(boolean valid, List<String> errors, List<String> warnings) {
            this.valid = valid;
            this.errors = new ArrayList<String>(errors);
            this.warnings = new ArrayList<String>(warnings);
        }

        public static DetailedValidationResult valid() {
            return new DetailedValidationResult(true, Collections.emptyList(), Collections.emptyList());
        }

        public static DetailedValidationResult invalid(List<String> errors) {
            return new DetailedValidationResult(false, errors, Collections.emptyList());
        }

        public static DetailedValidationResult invalidWithWarnings(List<String> errors, List<String> warnings) {
            return new DetailedValidationResult(false, errors, warnings);
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<String> getErrors() {
            return new ArrayList<String>(this.errors);
        }

        public List<String> getWarnings() {
            return new ArrayList<String>(this.warnings);
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.valid ? "Valid" : "Invalid");
            if (!this.errors.isEmpty()) {
                sb.append(" (").append(this.errors.size()).append(" errors)");
            }
            if (!this.warnings.isEmpty()) {
                sb.append(" (").append(this.warnings.size()).append(" warnings)");
            }
            return sb.toString();
        }
    }

    public static class ValidationResult {
        private final boolean valid;
        private final String errorMessage;

        public ValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessage = errorMessage;
        }

        public static ValidationResult valid() {
            return new ValidationResult(true, null);
        }

        public static ValidationResult invalid(String errorMessage) {
            return new ValidationResult(false, errorMessage);
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String toString() {
            return this.valid ? "Valid" : "Invalid: " + this.errorMessage;
        }
    }
}

