/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions.storage;

import com.kneaf.core.exceptions.core.BaseKneafException;
import com.kneaf.core.exceptions.utils.ExceptionContext;
import com.kneaf.core.exceptions.utils.ExceptionSeverity;

public class DatabaseException
extends BaseKneafException {
    private final DatabaseErrorType errorType;
    private final String databaseType;
    private final String key;

    private DatabaseException(Builder builder) {
        super(builder);
        this.errorType = builder.errorType;
        this.databaseType = builder.databaseType;
        this.key = builder.key;
    }

    public DatabaseErrorType getErrorType() {
        return this.errorType;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public DatabaseException withContext(ExceptionContext context) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().message(this.getMessage())).cause(this.getCause())).errorCode(this.getErrorCode())).severity(this.getSeverity())).context(context)).suggestion(this.getSuggestion())).logged(this.isLogged())).errorType(this.errorType).databaseType(this.databaseType).key(this.key).build();
    }

    @Override
    public DatabaseException withSuggestion(String suggestion) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().message(this.getMessage())).cause(this.getCause())).errorCode(this.getErrorCode())).severity(this.getSeverity())).context(this.getContext())).suggestion(suggestion)).logged(this.isLogged())).errorType(this.errorType).databaseType(this.databaseType).key(this.key).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DatabaseException asyncOperationFailed(String operation, String databaseType, String key, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)DatabaseException.builder().errorType(DatabaseErrorType.ASYNC_OPERATION_FAILED).databaseType(databaseType).key(key).message(String.format("Async %s operation failed", operation))).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Check external dependencies and services")).build();
    }

    public static DatabaseException nativeLibraryError(String databaseType, String message, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)DatabaseException.builder().errorType(DatabaseErrorType.NATIVE_LIBRARY_ERROR).databaseType(databaseType).message(message)).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Check external dependencies and services")).build();
    }

    public static DatabaseException connectionFailed(String databaseType, String message, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)DatabaseException.builder().errorType(DatabaseErrorType.CONNECTION_FAILED).databaseType(databaseType).message(message)).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Check external dependencies and services")).build();
    }

    public static DatabaseException transactionFailed(String databaseType, String message, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)DatabaseException.builder().errorType(DatabaseErrorType.TRANSACTION_FAILED).databaseType(databaseType).message(message)).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Check application logs for detailed error information")).build();
    }

    public static DatabaseException validationFailed(String databaseType, String key, String message) {
        return ((Builder)((Builder)((Builder)DatabaseException.builder().errorType(DatabaseErrorType.VALIDATION_FAILED).databaseType(databaseType).key(key).message(message)).severity(ExceptionSeverity.WARNING)).suggestion("Verify configuration settings and parameters")).build();
    }

    public static class Builder
    extends BaseKneafException.Builder<Builder> {
        private DatabaseErrorType errorType;
        private String databaseType;
        private String key;

        @Override
        protected Builder self() {
            return this;
        }

        public Builder errorType(DatabaseErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder databaseType(String databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.errorType == null) {
                throw new IllegalArgumentException("Error type cannot be null");
            }
        }

        public DatabaseException build() {
            this.validate();
            if (this.errorCode == null && this.errorType != null) {
                this.errorCode = this.errorType.getErrorCode();
            }
            if (this.severity == null) {
                this.severity = ExceptionSeverity.ERROR;
            }
            return new DatabaseException(this);
        }
    }

    public static enum DatabaseErrorType {
        CONNECTION_FAILED("DB001", "Database connection failed"),
        OPERATION_FAILED("DB001", "Database operation failed"),
        TRANSACTION_FAILED("DB002", "Database transaction failed"),
        VALIDATION_FAILED("DB003", "Database validation failed"),
        BACKUP_FAILED("DB004", "Database backup failed"),
        MAINTENANCE_FAILED("DB005", "Database maintenance failed"),
        NATIVE_LIBRARY_ERROR("NAT006", "Native database library error"),
        ASYNC_OPERATION_FAILED("DB006", "Async database operation failed");

        private final String errorCode;
        private final String description;

        private DatabaseErrorType(String errorCode, String description) {
            this.errorCode = errorCode;
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

