/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.monitoring;

import com.kneaf.core.performance.monitoring.EntityProcessor;
import com.kneaf.core.performance.monitoring.PerformanceConfig;
import com.kneaf.core.performance.monitoring.PerformanceMetricsLogger;
import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class ThreadPoolManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final PerformanceConfig CONFIG = PerformanceConfig.load();
    private static ThreadPoolExecutor serverTaskExecutor = null;
    private static final Object EXECUTOR_LOCK = new Object();
    private static final ExecutorMetrics EXECUTOR_METRICS = new ExecutorMetrics();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getExecutor() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor == null || serverTaskExecutor.isShutdown()) {
                ThreadPoolManager.createAdvancedThreadPool();
            }
            return serverTaskExecutor;
        }
    }

    private static void createAdvancedThreadPool() {
        int availableProcessors;
        AtomicInteger threadIndex = new AtomicInteger(0);
        ThreadFactory factory = r -> {
            Thread t = new Thread(r, "kneaf-perf-worker-" + threadIndex.getAndIncrement());
            t.setDaemon(true);
            return t;
        };
        int coreThreads = CONFIG.getMinThreadpoolSize();
        int maxThreads = CONFIG.getMaxThreadpoolSize();
        if (CONFIG.isCpuAwareThreadSizing()) {
            availableProcessors = Runtime.getRuntime().availableProcessors();
            double cpuLoad = ThreadPoolManager.getSystemCpuLoad();
            maxThreads = cpuLoad < CONFIG.getCpuLoadThreshold() ? Math.min(maxThreads, availableProcessors) : Math.clamp((long)(availableProcessors / 2), 1, maxThreads);
            coreThreads = Math.min(coreThreads, maxThreads);
        }
        if (CONFIG.isAdaptiveThreadPool()) {
            availableProcessors = Runtime.getRuntime().availableProcessors();
            maxThreads = ThreadPoolManager.clamp(availableProcessors - 1, 1, maxThreads);
            coreThreads = Math.min(coreThreads, maxThreads);
        }
        LinkedBlockingQueue<Runnable> workQueue = CONFIG.isWorkStealingEnabled() ? new LinkedBlockingQueue(CONFIG.getWorkStealingQueueSize()) : new LinkedBlockingQueue<Runnable>();
        serverTaskExecutor = new ThreadPoolExecutor(coreThreads, maxThreads, (long)CONFIG.getThreadPoolKeepAliveSeconds(), TimeUnit.SECONDS, workQueue, factory);
        serverTaskExecutor.allowCoreThreadTimeOut(true);
        ThreadPoolManager.EXECUTOR_METRICS.currentThreadCount = coreThreads;
        ThreadPoolManager.EXECUTOR_METRICS.peakThreadCount = coreThreads;
    }

    private static double getSystemCpuLoad() {
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            double systemLoad = osBean.getSystemLoadAverage();
            if (systemLoad < 0.0) {
                int availableProcessors = osBean.getAvailableProcessors();
                return Math.min(1.0, systemLoad / (double)availableProcessors);
            }
            int availableProcessors = osBean.getAvailableProcessors();
            return Math.min(1.0, systemLoad / (double)availableProcessors);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static int clamp(int v, int min, int max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static double clamp(double v, double min, double max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor != null) {
                try {
                    serverTaskExecutor.shutdown();
                    if (!serverTaskExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        serverTaskExecutor.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    serverTaskExecutor.shutdownNow();
                }
                finally {
                    serverTaskExecutor = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExecutorMetrics() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor == null) {
                return "{\"status\":\"not_initialized\"}";
            }
            return EXECUTOR_METRICS.toJson();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExecutorStatus() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor == null) {
                return "Executor not initialized";
            }
            return String.format("ThreadPoolExecutor[core=%d, max=%d, current=%d, active=%d, queue=%d, completed=%d]", serverTaskExecutor.getCorePoolSize(), serverTaskExecutor.getMaximumPoolSize(), serverTaskExecutor.getPoolSize(), serverTaskExecutor.getActiveCount(), serverTaskExecutor.getQueue().size(), serverTaskExecutor.getCompletedTaskCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExecutorHealthy() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            int maxQueueSize;
            if (serverTaskExecutor == null || serverTaskExecutor.isShutdown() || serverTaskExecutor.isTerminated()) {
                return false;
            }
            int queueSize = serverTaskExecutor.getQueue().size();
            int n = maxQueueSize = CONFIG.isWorkStealingEnabled() ? CONFIG.getWorkStealingQueueSize() : 1000;
            if ((double)queueSize > (double)maxQueueSize * 0.9) {
                return false;
            }
            double utilization = this.getExecutorUtilization();
            return serverTaskExecutor.getPoolSize() < serverTaskExecutor.getMaximumPoolSize() || !(utilization > 0.95);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExecutorQueueSize() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor == null) {
                return 0;
            }
            return serverTaskExecutor.getQueue().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getExecutorUtilization() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor == null) {
                return 0.0;
            }
            int activeThreads = serverTaskExecutor.getActiveCount();
            int poolSize = Math.max(1, serverTaskExecutor.getPoolSize());
            return (double)activeThreads / (double)poolSize;
        }
    }

    public void submitAsyncOptimizations(MinecraftServer server, EntityProcessor.EntityDataCollection data, boolean shouldProfile) {
        try {
            this.getExecutor().submit(() -> this.performAsyncOptimization(server, data, shouldProfile));
        }
        catch (Exception e) {
            LOGGER.debug("Executor rejected task; running synchronously", (Throwable)e);
        }
    }

    private void performAsyncOptimization(MinecraftServer server, EntityProcessor.EntityDataCollection data, boolean shouldProfile) {
        try {
            long processingStart = shouldProfile ? System.nanoTime() : 0L;
            EntityProcessor entityProcessor = new EntityProcessor();
            EntityProcessor.OptimizationResults results = entityProcessor.processOptimizations(data);
            if (shouldProfile) {
                long durationMs = (System.nanoTime() - processingStart) / 1000000L;
                PerformanceMetricsLogger.logLine(String.format("PERF: async_processing duration=%.2fms", durationMs));
            }
            server.execute(() -> this.applyOptimizationResults(server, results, shouldProfile));
        }
        catch (Exception e) {
            LOGGER.warn("Error during async processing of optimizations", (Throwable)e);
        }
    }

    private void applyOptimizationResults(MinecraftServer server, EntityProcessor.OptimizationResults results, boolean shouldProfile) {
        try {
            long applicationStart = shouldProfile ? System.nanoTime() : 0L;
            EntityProcessor entityProcessor = new EntityProcessor();
            entityProcessor.applyOptimizations(server, results);
            if (shouldProfile) {
                long durationMs = (System.nanoTime() - applicationStart) / 1000000L;
                PerformanceMetricsLogger.logLine(String.format("PERF: async_application duration=%.2fms", durationMs));
            }
            entityProcessor.removeItems(server, results.itemResult());
        }
        catch (Exception e) {
            LOGGER.warn("Error applying optimizations on server thread", (Throwable)e);
        }
    }

    public static final class ExecutorMetrics {
        public long totalTasksSubmitted = 0L;
        public long totalTasksCompleted = 0L;
        public long totalTasksRejected = 0L;
        public long currentQueueSize = 0L;
        public double currentUtilization = 0.0;
        public int currentThreadCount = 0;
        public int peakThreadCount = 0;
        public long lastScaleUpTime = 0L;
        public long lastScaleDownTime = 0L;
        public int scaleUpCount = 0;
        public int scaleDownCount = 0;

        public String toJson() {
            return String.format("{\"totalTasksSubmitted\":%d,\"totalTasksCompleted\":%d,\"totalTasksRejected\":%d,\"currentQueueSize\":%d,\"currentUtilization\":%.2f,\"currentThreadCount\":%d,\"peakThreadCount\":%d,\"scaleUpCount\":%d,\"scaleDownCount\":%d}", this.totalTasksSubmitted, this.totalTasksCompleted, this.totalTasksRejected, this.currentQueueSize, this.currentUtilization, this.currentThreadCount, this.peakThreadCount, this.scaleUpCount, this.scaleDownCount);
        }
    }
}

