/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.spatial;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VillagerGroup {
    private final long groupId;
    private final float centerX;
    private final float centerY;
    private final float centerZ;
    private final List<Long> villagerIds;
    private final String groupType;
    private final byte aiTickRate;
    private final int hierarchyLevel;
    private final long cellKey;
    private final Instant lastUpdateTime;
    private final float groupRadius;
    private final Map<String, Object> metadata;
    private boolean needsUpdate;
    private float lastKnownMovement;
    private Instant lastMovementCheck;

    public VillagerGroup(long groupId, float centerX, float centerY, float centerZ, List<Long> villagerIds, String groupType, byte aiTickRate, int hierarchyLevel, long cellKey, float groupRadius) {
        this.groupId = groupId;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.villagerIds = villagerIds;
        this.groupType = groupType;
        this.aiTickRate = aiTickRate;
        this.hierarchyLevel = hierarchyLevel;
        this.cellKey = cellKey;
        this.groupRadius = groupRadius;
        this.lastUpdateTime = Instant.now();
        this.metadata = new ConcurrentHashMap<String, Object>();
        this.needsUpdate = false;
        this.lastKnownMovement = 0.0f;
        this.lastMovementCheck = Instant.now();
    }

    public VillagerGroup(long groupId, float centerX, float centerY, float centerZ, List<Long> villagerIds, String groupType, byte aiTickRate) {
        this(groupId, centerX, centerY, centerZ, villagerIds, groupType, aiTickRate, 0, 0L, 16.0f);
    }

    public long getGroupId() {
        return this.groupId;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public float getCenterZ() {
        return this.centerZ;
    }

    public List<Long> getVillagerIds() {
        return this.villagerIds;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public byte getAiTickRate() {
        return this.aiTickRate;
    }

    public int getHierarchyLevel() {
        return this.hierarchyLevel;
    }

    public long getCellKey() {
        return this.cellKey;
    }

    public float getGroupRadius() {
        return this.groupRadius;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean needsUpdate(float movementThreshold) {
        if (this.needsUpdate) {
            return true;
        }
        long secondsSinceCheck = Instant.now().minusSeconds(1L).compareTo(this.lastMovementCheck);
        if (secondsSinceCheck > 0L) {
            return false;
        }
        return switch (this.groupType) {
            case "breeding" -> {
                if (this.lastKnownMovement > movementThreshold * 0.7f) {
                    yield true;
                }
                yield false;
            }
            case "working" -> {
                if (this.lastKnownMovement > movementThreshold * 0.5f) {
                    yield true;
                }
                yield false;
            }
            case "village" -> {
                if (this.lastKnownMovement > movementThreshold * 0.3f) {
                    yield true;
                }
                yield false;
            }
            default -> this.lastKnownMovement > movementThreshold;
        };
    }

    public void updateMovement(long villagerId, float movementDistance) {
        if (movementDistance > this.lastKnownMovement) {
            this.lastKnownMovement = movementDistance;
            this.needsUpdate = true;
            this.lastMovementCheck = Instant.now();
        }
        this.metadata.compute("movementStats", (k, v) -> {
            HashMap<String, Float> stats = (HashMap<String, Float>)v;
            if (stats == null) {
                stats = new HashMap<String, Float>();
                stats.put("total", Float.valueOf(0.0f));
                stats.put("max", Float.valueOf(0.0f));
                stats.put("count", Float.valueOf(0.0f));
            }
            stats.put("total", Float.valueOf(((Float)stats.get("total")).floatValue() + movementDistance));
            stats.put("max", Float.valueOf(Math.max(((Float)stats.get("max")).floatValue(), movementDistance)));
            stats.put("count", Float.valueOf(((Float)stats.get("count")).floatValue() + 1.0f));
            return stats;
        });
    }

    public void resetUpdateFlag() {
        this.needsUpdate = false;
        this.lastKnownMovement = 0.0f;
    }

    public byte calculateOptimalAiTickRate() {
        float density = (float)this.villagerIds.size() / (float)((double)(this.groupRadius * this.groupRadius) * Math.PI);
        if (density > 0.5f) {
            return 1;
        }
        if (density > 0.2f) {
            return 2;
        }
        if (density > 0.1f) {
            return 4;
        }
        return 8;
    }

    public long[] getCellCoordinates() {
        return new long[]{this.cellKey >> 40, this.cellKey >> 20 & 0xFFFFFL, this.cellKey & 0xFFFFFL};
    }

    public boolean overlapsWith(VillagerGroup other) {
        float dx = this.centerX - other.centerX;
        float dy = this.centerY - other.centerY;
        float dz = this.centerZ - other.centerZ;
        float distance = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        return distance < (this.groupRadius + other.groupRadius) * 0.5f;
    }
}

