/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.utils;

import com.kneaf.core.protocol.core.ProtocolLogger;
import com.kneaf.core.protocol.core.ProtocolValidator;
import com.kneaf.core.protocol.utils.ProtocolLoggerImpl;
import com.kneaf.core.protocol.utils.ProtocolValidatorImpl;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ProtocolContext {
    private final String traceId;
    private final String operation;
    private final String protocolFormat;
    private final String protocolVersion;
    private final Instant startTime;
    private final Map<String, Object> metadata;
    private final ProtocolLogger logger;
    private final ProtocolValidator<?> validator;

    private ProtocolContext(Builder builder) {
        this.traceId = builder.traceId;
        this.operation = builder.operation;
        this.protocolFormat = builder.protocolFormat;
        this.protocolVersion = builder.protocolVersion;
        this.startTime = builder.startTime;
        this.metadata = new HashMap<String, Object>(builder.metadata);
        this.logger = builder.logger;
        this.validator = builder.validator;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getProtocolFormat() {
        return this.protocolFormat;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Map<String, Object> getMetadata() {
        return new HashMap<String, Object>(this.metadata);
    }

    public ProtocolLogger getLogger() {
        return this.logger;
    }

    public ProtocolValidator<?> getValidator() {
        return this.validator;
    }

    public void addMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public Object getMetadata(String key) {
        return this.metadata.get(key);
    }

    public long getElapsedTime() {
        return Duration.between(this.startTime, Instant.now()).toMillis();
    }

    public ProtocolContext withMetadata(Map<String, Object> additionalMetadata) {
        HashMap<String, Object> newMetadata = new HashMap<String, Object>(this.metadata);
        newMetadata.putAll(additionalMetadata);
        return new Builder().traceId(this.traceId).operation(this.operation).protocolFormat(this.protocolFormat).protocolVersion(this.protocolVersion).startTime(this.startTime).metadata(newMetadata).logger(this.logger).validator(this.validator).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProtocolContext createDefault(String operation) {
        return ProtocolContext.builder().operation(operation).build();
    }

    public static ProtocolContext forJson(String operation) {
        return ProtocolContext.builder().operation(operation).protocolFormat("json").build();
    }

    public static ProtocolContext forBinary(String operation) {
        return ProtocolContext.builder().operation(operation).protocolFormat("binary").build();
    }

    public static class Builder {
        private String traceId;
        private String operation;
        private String protocolFormat = "json";
        private String protocolVersion = "2.0";
        private Instant startTime = Instant.now();
        private Map<String, Object> metadata = new HashMap<String, Object>();
        private ProtocolLogger logger;
        private ProtocolValidator<?> validator;

        public Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder protocolFormat(String protocolFormat) {
            this.protocolFormat = protocolFormat;
            return this;
        }

        public Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = new HashMap<String, Object>(metadata);
            return this;
        }

        public Builder addMetadata(String key, Object value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder logger(ProtocolLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder validator(ProtocolValidator<?> validator) {
            this.validator = validator;
            return this;
        }

        public ProtocolContext build() {
            if (this.traceId == null) {
                this.traceId = UUID.randomUUID().toString();
            }
            if (this.operation == null) {
                throw new IllegalStateException("Operation is required");
            }
            if (this.logger == null) {
                this.logger = new ProtocolLoggerImpl("ProtocolContext");
            }
            if (this.validator == null) {
                this.validator = new ProtocolValidatorImpl<Object>(Object.class, 0xA00000, this.protocolVersion);
            }
            return new ProtocolContext(this);
        }
    }
}

