/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.client;

import com.kneaf.core.exceptions.utils.ExceptionContext;
import com.kneaf.core.exceptions.utils.ExceptionSeverity;
import com.kneaf.core.exceptions.utils.ExceptionUtils;
import com.kneaf.core.network.NetworkHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public final class PerformanceOverlayClient {
    private static final int MAX_LINES = 40;
    private static final Deque<String> LINES = new ArrayDeque<String>(40);
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformanceOverlayClient.class);
    private static final String COMPONENT_NAME = "PerformanceOverlayClient";
    private static final String OPERATION_NETWORK_REGISTER = "NetworkRegistration";
    private static final String OPERATION_HUD_REGISTER = "HudRegistration";
    private static final String OPERATION_RENDER = "PerformanceRendering";
    private static final String OPERATION_PACKET_PROCESSING = "PacketProcessing";
    private static final long ERROR_HANDLING_THRESHOLD_NANOS = 1000000L;
    private static long errorHandlingTimeNanos = 0L;
    private static int errorCount = 0;

    private PerformanceOverlayClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleException(Throwable exception, String operation, String context, ExceptionSeverity severity) {
        long startTime;
        block10: {
            if (exception == null) {
                return;
            }
            startTime = System.nanoTime();
            try {
                if (severity == null) {
                    severity = ExceptionUtils.determineSeverity(exception);
                }
                ++errorCount;
                HashMap<String, Object> contextData = new HashMap<String, Object>();
                contextData.put("operation", operation);
                if (context != null) {
                    contextData.put("context", context);
                }
                contextData.put("clientActive", Minecraft.getInstance() != null);
                contextData.put("thread", Thread.currentThread().getName());
                contextData.put("errorCount", errorCount);
                String errorMessage = String.format("Performance overlay %s failed: %s", operation, exception.getMessage());
                if (severity.isAtLeast(ExceptionSeverity.ERROR)) {
                    ExceptionContext.Builder contextBuilder = ExceptionContext.builder().operation(operation).component(COMPONENT_NAME);
                    for (Map.Entry entry : contextData.entrySet()) {
                        contextBuilder.addContext((String)entry.getKey(), entry.getValue());
                    }
                    ExceptionUtils.logExceptionWithContext(LOGGER, severity, errorMessage, exception, contextBuilder.build());
                } else {
                    ExceptionUtils.logException(LOGGER, severity, errorMessage, exception);
                }
                PerformanceOverlayClient.assessPerformanceImpact(exception, operation, severity);
                if (severity != ExceptionSeverity.CRITICAL) break block10;
                PerformanceOverlayClient.handleCriticalError(exception, operation);
            }
            catch (Throwable throwable) {
                long endTime = System.nanoTime();
                long handlingTime = endTime - startTime;
                errorHandlingTimeNanos += handlingTime;
                if (handlingTime > 1000000L) {
                    LOGGER.warn("Error handling took {} ms for operation {} (threshold: {} ms)", new Object[]{handlingTime / 1000000L, operation, 1L});
                }
                throw throwable;
            }
        }
        long endTime = System.nanoTime();
        long handlingTime = endTime - startTime;
        errorHandlingTimeNanos += handlingTime;
        if (handlingTime > 1000000L) {
            LOGGER.warn("Error handling took {} ms for operation {} (threshold: {} ms)", new Object[]{handlingTime / 1000000L, operation, 1L});
        }
    }

    private static void assessPerformanceImpact(Throwable exception, String operation, ExceptionSeverity severity) {
        if (severity.isAtLeast(ExceptionSeverity.ERROR)) {
            LOGGER.warn("Performance impact detected in {}: {}. Severity: {}", new Object[]{operation, exception.getClass().getSimpleName(), severity.getName()});
            HashMap<String, String> perfContext = new HashMap<String, String>();
            perfContext.put("severity", severity.getName());
            perfContext.put("exceptionType", exception.getClass().getSimpleName());
            perfContext.put("operation", operation);
            perfContext.put("impact", "potential_performance_degradation");
            LOGGER.debug("Performance impact context: {}", perfContext);
        }
    }

    private static void handleCriticalError(Throwable exception, String operation) {
        LOGGER.error("CRITICAL ERROR in {}: {}. System stability may be compromised.", (Object)operation, (Object)exception.getMessage());
        LOGGER.error("Critical error stack trace: ", exception);
        LOGGER.warn("Continuing with degraded performance overlay functionality due to critical error");
    }

    public static Map<String, Object> getErrorHandlingStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalErrorCount", errorCount);
        stats.put("totalErrorHandlingTimeMs", errorHandlingTimeNanos / 1000000L);
        stats.put("averageErrorHandlingTimeMs", errorCount > 0 ? errorHandlingTimeNanos / (long)errorCount / 1000000L : 0L);
        stats.put("thresholdExceededCount", errorHandlingTimeNanos > 1000000L ? 1 : 0);
        return stats;
    }

    public static void resetErrorStats() {
        errorCount = 0;
        errorHandlingTimeNanos = 0L;
        LOGGER.debug("Error handling statistics reset");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerClient(FMLClientSetupEvent event) {
        try {
            Class<?> clientPlayNetworking = Class.forName("net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking");
            Class<?> serverPlayPacketConsumer = Class.forName("net.fabricmc.fabric.api.networking.v1.PacketConsumer");
            Method register = clientPlayNetworking.getMethod("register", ResourceLocation.class, serverPlayPacketConsumer);
            Object consumer = Proxy.newProxyInstance(PerformanceOverlayClient.class.getClassLoader(), new Class[]{serverPlayPacketConsumer}, (proxy, method, args) -> {
                if (args != null && args.length > 1 && args[1] != null) {
                    try {
                        Object buf = args[1];
                        Method readUtf = buf.getClass().getMethod("readUtf", Integer.TYPE);
                        String msg = (String)readUtf.invoke(buf, Short.MAX_VALUE);
                        PerformanceOverlayClient.onPerformanceLineReceived(msg);
                    }
                    catch (Exception ex) {
                        PerformanceOverlayClient.handleException(ex, OPERATION_PACKET_PROCESSING, "Failed to read packet data", ExceptionSeverity.WARNING);
                    }
                }
                return null;
            });
            register.invoke(null, NetworkHandler.PERFORMANCE_CHANNEL, consumer);
            return;
        }
        catch (ClassNotFoundException ignored) {
            LOGGER.debug("Fabric API not available for performance overlay network registration");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            PerformanceOverlayClient.handleException(e, OPERATION_NETWORK_REGISTER, "Fabric network registration method error", ExceptionSeverity.INFO);
        }
        try {
            Class<?> hudCallbackClass = Class.forName("net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback");
            Field eventField = hudCallbackClass.getField("EVENT");
            Object eventObj = eventField.get(null);
            Method registerHud = eventObj.getClass().getMethod("register", hudCallbackClass);
            Object hudListener = Proxy.newProxyInstance(PerformanceOverlayClient.class.getClassLoader(), new Class[]{hudCallbackClass}, (proxy, method, args) -> {
                try {
                    float partial = 0.0f;
                    if (args != null && args.length > 1 && args[1] instanceof Float) {
                        partial = ((Float)args[1]).floatValue();
                    }
                    PerformanceOverlayClient.renderLinesUsingFont(args != null && args.length > 0 ? args[0] : null, partial);
                }
                catch (Throwable t) {
                    PerformanceOverlayClient.handleException(t, OPERATION_RENDER, "HUD rendering error during registration", ExceptionSeverity.WARNING);
                }
                return null;
            });
            registerHud.invoke(eventObj, hudListener);
            return;
        }
        catch (ClassNotFoundException cnf) {
            LOGGER.debug("Fabric HudRenderCallback not available for performance overlay");
        }
        catch (Throwable t) {
            PerformanceOverlayClient.handleException(t, OPERATION_HUD_REGISTER, "Critical error during HUD registration", ExceptionSeverity.ERROR);
        }
        try {
            Minecraft mc = Minecraft.getInstance();
            Object conn = null;
            try {
                Method getConnection = mc.getClass().getMethod("getConnection", new Class[0]);
                conn = getConnection.invoke((Object)mc, new Object[0]);
            }
            catch (Exception ex) {
                PerformanceOverlayClient.handleException(ex, OPERATION_NETWORK_REGISTER, "Failed to get connection from Minecraft client", ExceptionSeverity.INFO);
            }
            if (conn == null) return;
        }
        catch (Throwable t) {
            PerformanceOverlayClient.handleException(t, OPERATION_NETWORK_REGISTER, "Critical error during vanilla network registration", ExceptionSeverity.WARNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPerformanceLineReceived(String line) {
        if (line == null) {
            return;
        }
        Deque<String> deque = LINES;
        synchronized (deque) {
            if (LINES.size() >= 40) {
                LINES.removeFirst();
            }
            LINES.addLast(line);
        }
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc != null && mc.gui != null) {
                try {
                    mc.gui.getChat().addMessage((Component)Component.literal((String)line));
                }
                catch (Throwable t) {
                    PerformanceOverlayClient.handleException(t, OPERATION_PACKET_PROCESSING, "Failed to add chat message", ExceptionSeverity.INFO);
                }
            }
        }
        catch (Throwable t) {
            PerformanceOverlayClient.handleException(t, OPERATION_PACKET_PROCESSING, "Critical error in performance line processing", ExceptionSeverity.WARNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderOverlay(GuiGraphics graphics, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.player == null) {
            return;
        }
        int x = 10;
        int y = 10;
        Objects.requireNonNull(mc.font);
        int lineHeight = 9 + 2;
        Deque<String> deque = LINES;
        synchronized (deque) {
            int i = 0;
            for (String s : LINES) {
                int yy = y + i * lineHeight;
                graphics.drawString(mc.font, s, x, yy, 0xFFFFFF, false);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderLinesUsingFont(Object poseStack, float partialTicks) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            Font font = mc.font;
            if (font == null) {
                return;
            }
            int x = 10;
            int y = 10;
            Objects.requireNonNull(mc.font);
            int lineHeight = 9 + 2;
            Deque<String> deque = LINES;
            synchronized (deque) {
                int i = 0;
                for (String s : LINES) {
                    int yy = y + i * lineHeight;
                    try {
                        try {
                            Method draw = font.getClass().getMethod("draw", GuiGraphics.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                            draw.invoke((Object)font, null, s, x, yy, 0xFFFFFF);
                        }
                        catch (NoSuchMethodException ns) {
                            try {
                                Method draw2 = font.getClass().getMethod("draw", String.class, Float.TYPE, Float.TYPE, Integer.TYPE);
                                draw2.invoke((Object)font, s, Float.valueOf(x), Float.valueOf(yy), 0xFFFFFF);
                            }
                            catch (NoSuchMethodException ns2) {
                                Method draw3 = font.getClass().getMethod("drawString", String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                                draw3.invoke((Object)font, s, x, yy, 0xFFFFFF);
                            }
                        }
                    }
                    catch (Throwable t) {
                        PerformanceOverlayClient.handleException(t, OPERATION_RENDER, "Individual line render error", ExceptionSeverity.DEBUG);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            PerformanceOverlayClient.handleException(t, OPERATION_RENDER, "Critical rendering error in performance overlay", ExceptionSeverity.ERROR);
        }
    }
}

