/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.config;

public class ResourceConfiguration {
    private final int resourceCleanupIntervalSeconds;
    private final int resourceHealthCheckIntervalSeconds;
    private final int maxResourceAgeMinutes;
    private final boolean resourcePoolEnabled;
    private final int resourcePoolMaxSize;
    private final int resourcePoolInitialSize;

    private ResourceConfiguration(Builder builder) {
        this.resourceCleanupIntervalSeconds = builder.resourceCleanupIntervalSeconds;
        this.resourceHealthCheckIntervalSeconds = builder.resourceHealthCheckIntervalSeconds;
        this.maxResourceAgeMinutes = builder.maxResourceAgeMinutes;
        this.resourcePoolEnabled = builder.resourcePoolEnabled;
        this.resourcePoolMaxSize = builder.resourcePoolMaxSize;
        this.resourcePoolInitialSize = builder.resourcePoolInitialSize;
        this.validate();
    }

    private void validate() {
        if (this.resourceCleanupIntervalSeconds <= 0) {
            throw new IllegalArgumentException("Resource cleanup interval must be positive");
        }
        if (this.resourceHealthCheckIntervalSeconds <= 0) {
            throw new IllegalArgumentException("Resource health check interval must be positive");
        }
        if (this.maxResourceAgeMinutes <= 0) {
            throw new IllegalArgumentException("Max resource age must be positive");
        }
        if (this.resourcePoolMaxSize <= 0) {
            throw new IllegalArgumentException("Resource pool max size must be positive");
        }
        if (this.resourcePoolInitialSize < 0) {
            throw new IllegalArgumentException("Resource pool initial size cannot be negative");
        }
        if (this.resourcePoolInitialSize > this.resourcePoolMaxSize) {
            throw new IllegalArgumentException("Resource pool initial size cannot exceed max size");
        }
    }

    public int getResourceCleanupIntervalSeconds() {
        return this.resourceCleanupIntervalSeconds;
    }

    public int getResourceHealthCheckIntervalSeconds() {
        return this.resourceHealthCheckIntervalSeconds;
    }

    public int getMaxResourceAgeMinutes() {
        return this.maxResourceAgeMinutes;
    }

    public boolean isResourcePoolEnabled() {
        return this.resourcePoolEnabled;
    }

    public int getResourcePoolMaxSize() {
        return this.resourcePoolMaxSize;
    }

    public int getResourcePoolInitialSize() {
        return this.resourcePoolInitialSize;
    }

    public String toString() {
        return String.format("ResourceConfiguration{resourceCleanupIntervalSeconds=%d, resourceHealthCheckIntervalSeconds=%d, maxResourceAgeMinutes=%d, resourcePoolEnabled=%s, resourcePoolMaxSize=%d, resourcePoolInitialSize=%d}", this.resourceCleanupIntervalSeconds, this.resourceHealthCheckIntervalSeconds, this.maxResourceAgeMinutes, this.resourcePoolEnabled, this.resourcePoolMaxSize, this.resourcePoolInitialSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int resourceCleanupIntervalSeconds = 300;
        private int resourceHealthCheckIntervalSeconds = 60;
        private int maxResourceAgeMinutes = 30;
        private boolean resourcePoolEnabled = true;
        private int resourcePoolMaxSize = 100;
        private int resourcePoolInitialSize = 10;

        public Builder resourceCleanupIntervalSeconds(int resourceCleanupIntervalSeconds) {
            this.resourceCleanupIntervalSeconds = resourceCleanupIntervalSeconds;
            return this;
        }

        public Builder resourceHealthCheckIntervalSeconds(int resourceHealthCheckIntervalSeconds) {
            this.resourceHealthCheckIntervalSeconds = resourceHealthCheckIntervalSeconds;
            return this;
        }

        public Builder maxResourceAgeMinutes(int maxResourceAgeMinutes) {
            this.maxResourceAgeMinutes = maxResourceAgeMinutes;
            return this;
        }

        public Builder resourcePoolEnabled(boolean resourcePoolEnabled) {
            this.resourcePoolEnabled = resourcePoolEnabled;
            return this;
        }

        public Builder resourcePoolMaxSize(int resourcePoolMaxSize) {
            this.resourcePoolMaxSize = resourcePoolMaxSize;
            return this;
        }

        public Builder resourcePoolInitialSize(int resourcePoolInitialSize) {
            this.resourcePoolInitialSize = resourcePoolInitialSize;
            return this;
        }

        public ResourceConfiguration build() {
            return new ResourceConfiguration(this);
        }
    }
}

