/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import java.nio.ByteBuffer;

public final class BinaryZeroCopyFacade {
    public native byte[] nativeDeserializeMobInput(ByteBuffer var1);

    public native int nativeSerializeMobResult(ByteBuffer var1, ByteBuffer var2);

    public native int nativeCalculateMobResultSize(ByteBuffer var1);

    static {
        System.loadLibrary("rustperf");
    }

    public static class ZeroCopyWrapper {
        private final BinaryZeroCopyFacade facade = new BinaryZeroCopyFacade();

        public byte[] deserializeMobInput(ByteBuffer buffer) {
            if (!buffer.isDirect()) {
                throw new IllegalArgumentException("Buffer must be direct ByteBuffer for zero-copy operations");
            }
            return this.facade.nativeDeserializeMobInput(buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] serializeMobResult(ByteBuffer resultBuffer) {
            if (!resultBuffer.isDirect()) {
                throw new IllegalArgumentException("Buffer must be direct ByteBuffer for zero-copy operations");
            }
            int requiredSize = this.facade.nativeCalculateMobResultSize(resultBuffer);
            if (requiredSize <= 0) {
                return new byte[0];
            }
            ByteBuffer outputBuffer = ByteBuffer.allocateDirect(requiredSize);
            try {
                int bytesWritten = this.facade.nativeSerializeMobResult(resultBuffer, outputBuffer);
                if (bytesWritten > 0) {
                    outputBuffer.flip();
                    byte[] result = new byte[bytesWritten];
                    outputBuffer.get(result);
                    byte[] byArray = result;
                    return byArray;
                }
                byte[] byArray = new byte[]{};
                return byArray;
            }
            finally {
                outputBuffer.clear();
            }
        }

        public static ByteBuffer createDirectBuffer(int capacity) {
            return ByteBuffer.allocateDirect(capacity);
        }

        public String getNativeVersion() {
            return "1.0.0";
        }
    }
}

