/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

public final class CacheNativeBridge {
    public static final int POLICY_LRU = 0;
    public static final int POLICY_LFU = 1;
    public static final int POLICY_FIFO = 2;
    public static final int POLICY_PRIORITY = 3;

    public native boolean nativeInitializeCache(boolean var1, int var2, int var3, boolean var4);

    public native byte[] nativeCachePut(String var1, byte[] var2, int var3);

    public native byte[] nativeCacheGet(String var1);

    public native byte[] nativeCacheRemove(String var1);

    public native boolean nativeCacheClear();

    public native String nativeGetCacheStats();

    public native boolean nativeIsCacheEnabled();

    static {
        System.loadLibrary("rustperf");
    }

    public static class CacheWrapper {
        private final CacheNativeBridge bridge = new CacheNativeBridge();
        private boolean isEnabled = false;

        public CacheWrapper(boolean enabled, int policy, int capacity) {
            this.initialize(enabled, policy, capacity, true);
        }

        public boolean initialize(boolean enabled, int policy, int capacity, boolean collectStats) {
            this.isEnabled = enabled;
            return this.bridge.nativeInitializeCache(enabled, policy, capacity, collectStats);
        }

        public byte[] put(String key, byte[] value, int priority) {
            if (!this.isEnabled) {
                return value;
            }
            return this.bridge.nativeCachePut(key, value, priority);
        }

        public byte[] get(String key) {
            if (!this.isEnabled) {
                return null;
            }
            return this.bridge.nativeCacheGet(key);
        }

        public byte[] remove(String key) {
            if (!this.isEnabled) {
                return null;
            }
            return this.bridge.nativeCacheRemove(key);
        }

        public void clear() {
            if (this.isEnabled) {
                this.bridge.nativeCacheClear();
            }
        }

        public String getStats() {
            if (!this.isEnabled) {
                return "{\"cacheEnabled\":false}";
            }
            return this.bridge.nativeGetCacheStats();
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean enabled) {
            if (this.isEnabled != enabled) {
                this.isEnabled = enabled;
                this.initialize(enabled, 0, 1000, true);
            }
        }
    }
}

