/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.core;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class ArrayListPool<T> {
    private final Queue<ArrayList<T>> pool = new ConcurrentLinkedQueue<ArrayList<T>>();
    private final int initialCapacity;

    public ArrayListPool() {
        this(16);
    }

    public ArrayListPool(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public ArrayList<T> acquire() {
        ArrayList<Object> list = this.pool.poll();
        if (list == null) {
            list = new ArrayList(this.initialCapacity);
        } else {
            list.clear();
        }
        return list;
    }

    public void release(ArrayList<T> list) {
        if (list != null && this.pool.size() < 100) {
            this.pool.offer(list);
        }
    }
}

