/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.core;

import com.kneaf.core.data.entity.EntityData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class EntityFlyweightFactory {
    private final Map<String, EntityData> entityFlyweights = new ConcurrentHashMap<String, EntityData>();
    private final Map<String, Map<String, Object>> configFlyweights = new ConcurrentHashMap<String, Map<String, Object>>();
    public static final String ENTITY_CONFIG_KEY = "system.entity.config";
    public static final String WORLD_BOUNDS_KEY = "system.world.bounds";
    public static final String PROCESSING_PARAMS_KEY = "system.processing.params";
    public static final String DEFAULT_ENTITY_PROPS_KEY = "default.entity.properties";

    EntityFlyweightFactory() {
    }

    public EntityData getEntityFlyweight(String key, EntityData prototype) {
        return this.entityFlyweights.computeIfAbsent(key, k -> {
            try {
                return prototype;
            }
            catch (Exception e) {
                return prototype;
            }
        });
    }

    public Map<String, Object> getEntityConfig() {
        return this.configFlyweights.computeIfAbsent(ENTITY_CONFIG_KEY, k -> new HashMap(32));
    }

    public Map<String, Object> getWorldBounds() {
        return this.configFlyweights.computeIfAbsent(WORLD_BOUNDS_KEY, k -> new HashMap(16));
    }

    public Map<String, Object> getDefaultEntityProperties() {
        return this.configFlyweights.computeIfAbsent(DEFAULT_ENTITY_PROPS_KEY, k -> new HashMap(16));
    }

    public void clear() {
        this.entityFlyweights.clear();
        this.configFlyweights.clear();
    }
}

