/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.monitoring;

import com.kneaf.core.data.block.BlockEntityData;
import com.kneaf.core.data.entity.EntityData;
import com.kneaf.core.data.entity.MobData;
import com.kneaf.core.data.entity.PlayerData;
import com.kneaf.core.data.item.ItemEntityData;
import com.kneaf.core.performance.RustPerformance;
import com.kneaf.core.performance.bridge.NativeBridge;
import com.kneaf.core.performance.core.ItemProcessResult;
import com.kneaf.core.performance.core.MobProcessResult;
import com.kneaf.core.performance.core.PerformanceConstants;
import com.kneaf.core.performance.core.PerformanceOptimizer;
import com.kneaf.core.performance.core.PerformanceProcessor;
import com.kneaf.core.performance.core.RustPerformanceFacade;
import com.kneaf.core.performance.monitoring.EntityProcessor;
import com.kneaf.core.performance.monitoring.PerformanceConfig;
import com.kneaf.core.performance.monitoring.PerformanceMetricsLogger;
import com.kneaf.core.performance.monitoring.ThreadPoolManager;
import com.kneaf.core.performance.spatial.SpatialGrid;
import com.mojang.logging.LogUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class PerformanceManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicLong totalJniCalls = new AtomicLong(0L);
    private static final AtomicLong totalJniCallDurationMs = new AtomicLong(0L);
    private static final AtomicLong maxJniCallDurationMs = new AtomicLong(0L);
    private static final ConcurrentHashMap<String, AtomicLong> jniCallTypes = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AtomicLong> lockWaitTypes = new ConcurrentHashMap();
    private static final AtomicLong totalLockWaits = new AtomicLong(0L);
    private static final AtomicLong totalLockWaitTimeMs = new AtomicLong(0L);
    private static final AtomicLong maxLockWaitTimeMs = new AtomicLong(0L);
    private static final AtomicInteger currentLockContention = new AtomicInteger(0);
    private static final AtomicLong totalHeapBytes = new AtomicLong(0L);
    private static final AtomicLong usedHeapBytes = new AtomicLong(0L);
    private static final AtomicLong freeHeapBytes = new AtomicLong(0L);
    private static final AtomicLong gcCount = new AtomicLong(0L);
    private static final AtomicLong gcTimeMs = new AtomicLong(0L);
    private static final AtomicLong peakHeapUsageBytes = new AtomicLong(0L);
    private static final AtomicLong totalAllocations = new AtomicLong(0L);
    private static final AtomicLong totalAllocationBytes = new AtomicLong(0L);
    private static final AtomicLong maxAllocationSizeBytes = new AtomicLong(0L);
    private static final AtomicLong totalDeallocations = new AtomicLong(0L);
    private static final AtomicLong allocationLatencyNanos = new AtomicLong(0L);
    private static final ConcurrentHashMap<String, AtomicLong> allocationTypes = new ConcurrentHashMap();
    private static final AtomicLong lockContentionEvents = new AtomicLong(0L);
    private static final AtomicLong totalContentionWaitTimeMs = new AtomicLong(0L);
    private static final ConcurrentHashMap<String, AtomicInteger> lockContentionTypes = new ConcurrentHashMap();
    private static final AtomicInteger maxQueueLength = new AtomicInteger(0);
    private static final long LOCK_CONTENTION_THRESHOLD = 5L;
    private static final AtomicLong allocationPressureEvents = new AtomicLong(0L);
    private static final AtomicLong highAllocationLatencyEvents = new AtomicLong(0L);
    private static final long HIGH_ALLOCATION_LATENCY_THRESHOLD_MS = 10L;
    private static final ConcurrentHashMap<String, TestResult> configTestResults = new ConcurrentHashMap();
    private static final AtomicLong testIdCounter = new AtomicLong(0L);
    private static double baselineTps = 20.0;
    private static final List<String> thresholdAlerts = new CopyOnWriteArrayList<String>();
    private static final long DEFAULT_JNI_CALL_THRESHOLD_MS = 100L;
    private static final long DEFAULT_LOCK_WAIT_THRESHOLD_MS = 50L;
    private static final double DEFAULT_MEMORY_USAGE_THRESHOLD_PCT = 90.0;
    private static final long DEFAULT_GC_DURATION_THRESHOLD_MS = 100L;
    private static long JNI_CALL_THRESHOLD_MS = 100L;
    private static long LOCK_WAIT_THRESHOLD_MS = 50L;
    private static double MEMORY_USAGE_THRESHOLD_PCT = 90.0;
    private static long GC_DURATION_THRESHOLD_MS = 100L;
    private static int TICK_COUNTER = 0;
    private static long lastTickTime = 0L;
    private static volatile long lastTickDurationNanos = 0L;
    private static final PerformanceConfig CONFIG = PerformanceConfig.load();
    private static final ConcurrentHashMap<String, CallGraphNode> callGraph = new ConcurrentHashMap();
    private static final ThreadLocal<Stack<CallGraphFrame>> callStack = ThreadLocal.withInitial(Stack::new);
    private static final boolean PROFILING_ENABLED;
    private static final boolean CALL_GRAPH_ENABLED;
    private static final int PROFILING_SAMPLE_RATE;
    private static final int TPS_WINDOW_SIZE = 8;
    private static final double[] TPS_WINDOW;
    private static int tpsWindowIndex;
    private static double currentTpsThreshold;
    private static final ThreadLocal<ProfileData> PROFILE_DATA;
    private static final int DEFAULT_TRANSITION_TICKS = 20;
    private static final int TRANSITION_TICKS = 20;
    private static final ConcurrentMap<ServerLevel, Integer> ORIGINAL_VIEW_DISTANCE;
    private static final ConcurrentMap<ServerLevel, Integer> TARGET_DISTANCE;
    private static final ConcurrentMap<ServerLevel, Integer> TRANSITION_REMAINING;
    private static final ConcurrentMap<ServerLevel, Integer> ORIGINAL_SIMULATION_DISTANCE;
    private static final ConcurrentMap<ServerLevel, Integer> TARGET_SIMULATION_DISTANCE;
    private static final ConcurrentMap<ServerLevel, Integer> TRANSITION_REMAINING_SIM;
    private static final ConcurrentMap<Class<?>, Method> VIEW_GET_CACHE;
    private static final ConcurrentMap<Class<?>, Method> VIEW_SET_CACHE;
    private static final ConcurrentMap<Class<?>, Method> SIM_GET_CACHE;
    private static final ConcurrentMap<Class<?>, Method> SIM_SET_CACHE;
    private static final ConcurrentMap<Class<?>, Boolean> METHOD_RESOLVED;
    private static final ThreadLocal<Long> TIMING_MARKER;
    private static volatile boolean enabled;
    private static final Object lock;
    private static final Map<ServerLevel, SpatialGrid> LEVEL_SPATIAL_GRIDS;
    private static final ConcurrentHashMap<ServerLevel, ReentrantLock> GRID_LOCKS;
    private static final ReentrantLock[] STRIPED_LOCKS;
    private static final int DISTANCE_CALCULATION_INTERVAL = 10;

    public static void beginMethod(String methodName) {
        if (!CALL_GRAPH_ENABLED) {
            return;
        }
        CallGraphFrame frame = new CallGraphFrame(methodName);
        callStack.get().push(frame);
    }

    public static void endMethod() {
        if (!CALL_GRAPH_ENABLED) {
            return;
        }
        CallGraphFrame frame = callStack.get().pop();
        if (frame == null) {
            return;
        }
        long durationNs = System.nanoTime() - frame.startTimeNs;
        String methodName = frame.methodName;
        CallGraphNode rootNode = callGraph.computeIfAbsent(methodName, CallGraphNode::new);
        rootNode.updateWithDuration(durationNs);
        Stack<CallGraphFrame> stack = callStack.get();
        if (!stack.isEmpty()) {
            String parentMethod = stack.peek().methodName;
            CallGraphNode parentNode = callGraph.computeIfAbsent(parentMethod, CallGraphNode::new);
            CallGraphNode childNode = parentNode.children.computeIfAbsent(methodName, CallGraphNode::new);
            childNode.updateWithDuration(durationNs);
        }
    }

    private static Method resolveViewGetter(Class<?> cls) {
        Method m = (Method)VIEW_GET_CACHE.get(cls);
        if (m != null) {
            return m;
        }
        if (METHOD_RESOLVED.containsKey(cls) && !VIEW_GET_CACHE.containsKey(cls)) {
            return null;
        }
        try {
            try {
                m = cls.getMethod("getViewDistance", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                m = cls.getMethod("viewDistance", new Class[0]);
            }
            VIEW_GET_CACHE.put(cls, m);
            METHOD_RESOLVED.put(cls, true);
            return m;
        }
        catch (Throwable t) {
            METHOD_RESOLVED.put(cls, false);
            return null;
        }
    }

    private static Method resolveViewSetter(Class<?> cls) {
        Method m = (Method)VIEW_SET_CACHE.get(cls);
        if (m != null) {
            return m;
        }
        try {
            m = cls.getMethod("setViewDistance", Integer.TYPE);
            VIEW_SET_CACHE.put(cls, m);
            return m;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Method resolveSimGetter(Class<?> cls) {
        Method m = (Method)SIM_GET_CACHE.get(cls);
        if (m != null) {
            return m;
        }
        try {
            m = cls.getMethod("getSimulationDistance", new Class[0]);
            SIM_GET_CACHE.put(cls, m);
            return m;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Method resolveSimSetter(Class<?> cls) {
        Method m = (Method)SIM_SET_CACHE.get(cls);
        if (m != null) {
            return m;
        }
        try {
            m = cls.getMethod("setSimulationDistance", Integer.TYPE);
            SIM_SET_CACHE.put(cls, m);
            return m;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void disableReflectionForClass(Class<?> cls, String why, Throwable t) {
        try {
            VIEW_GET_CACHE.remove(cls);
            VIEW_SET_CACHE.remove(cls);
            SIM_GET_CACHE.remove(cls);
            SIM_SET_CACHE.remove(cls);
            METHOD_RESOLVED.put(cls, false);
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disabling reflection distance adjustments for {}: {}", (Object)cls.getName(), (Object)why);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Reflection disable cause: ", t);
            }
        }
    }

    public static void startTiming() {
        TIMING_MARKER.set(System.nanoTime());
    }

    public static long getElapsedNanos() {
        return System.nanoTime() - TIMING_MARKER.get();
    }

    public static void resetTiming() {
        TIMING_MARKER.set(System.nanoTime());
    }

    private PerformanceManager() {
    }

    private static ThreadPoolManager getThreadPoolManager() {
        return LazySingletonHolder.THREAD_POOL_MANAGER;
    }

    private static EntityProcessor getEntityProcessor() {
        return LazySingletonHolder.ENTITY_PROCESSOR;
    }

    private static int getExecutorQueueSize() {
        return PerformanceManager.getThreadPoolManager().getExecutorQueueSize();
    }

    private static ThreadPoolExecutor getExecutor() {
        return PerformanceManager.getThreadPoolManager().getExecutor();
    }

    public static void shutdown() {
        PerformanceManager.getThreadPoolManager().shutdown();
    }

    private static ReentrantLock getGridLock(ServerLevel level) {
        int stripeIndex = Math.abs(level.hashCode() % STRIPED_LOCKS.length);
        return STRIPED_LOCKS[stripeIndex];
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean val) {
        enabled = val;
    }

    public static void recordJniCall(String callType, long durationMs) {
        if (!PerformanceManager.isEnabled()) {
            return;
        }
        totalJniCalls.incrementAndGet();
        totalJniCallDurationMs.addAndGet(durationMs);
        long currentMax = maxJniCallDurationMs.get();
        if (durationMs > currentMax) {
            maxJniCallDurationMs.compareAndSet(currentMax, durationMs);
        }
        jniCallTypes.computeIfAbsent(callType, k -> new AtomicLong(0L)).incrementAndGet();
        if (durationMs > JNI_CALL_THRESHOLD_MS) {
            String alert = String.format("JNI call exceeded threshold: %dms > %dms (type: %s)", durationMs, JNI_CALL_THRESHOLD_MS, callType);
            PerformanceManager.addThresholdAlert(alert);
        }
    }

    public static void recordJniCall() {
        PerformanceManager.recordJniCall("unspecified", 0L);
    }

    public static void recordLockWait(String lockName, long durationMs) {
        if (!PerformanceManager.isEnabled()) {
            return;
        }
        totalLockWaits.incrementAndGet();
        totalLockWaitTimeMs.addAndGet(durationMs);
        lockWaitTypes.computeIfAbsent(lockName, k -> new AtomicLong(0L)).addAndGet(durationMs);
        long currentMax = maxLockWaitTimeMs.get();
        if (durationMs > currentMax) {
            maxLockWaitTimeMs.compareAndSet(currentMax, durationMs);
        }
        currentLockContention.incrementAndGet();
        if (durationMs > LOCK_WAIT_THRESHOLD_MS) {
            String alert = String.format("Lock wait exceeded threshold: %dms > %dms (lock: %s)", durationMs, LOCK_WAIT_THRESHOLD_MS, lockName);
            PerformanceManager.addThresholdAlert(alert);
        }
    }

    public static void recordLockContention(String lockName, int queueLength, long durationMs) {
        if (!PerformanceManager.isEnabled()) {
            return;
        }
        lockContentionEvents.incrementAndGet();
        totalContentionWaitTimeMs.addAndGet(durationMs);
        lockContentionTypes.computeIfAbsent(lockName, k -> new AtomicInteger(0)).addAndGet(queueLength);
        maxQueueLength.compareAndSet(maxQueueLength.get(), Math.max(maxQueueLength.get(), queueLength));
        if ((long)queueLength > 5L) {
            String alert = String.format("Lock contention exceeded threshold: %d > %d (lock: %s)", queueLength, 5L, lockName);
            PerformanceManager.addThresholdAlert(alert);
        }
    }

    public static void recordLockResolved() {
        if (!PerformanceManager.isEnabled()) {
            return;
        }
        currentLockContention.updateAndGet(count -> Math.max(0, count - 1));
    }

    public static void recordMemoryUsage(long totalBytes, long usedBytes, long freeBytes) {
        if (!PerformanceManager.isEnabled()) {
            return;
        }
        totalHeapBytes.set(totalBytes);
        usedHeapBytes.set(usedBytes);
        freeHeapBytes.set(freeBytes);
        double usedPct = totalBytes > 0L ? (double)usedBytes * 100.0 / (double)totalBytes : 0.0;
        long currentPeak = peakHeapUsageBytes.get();
        if (usedBytes > currentPeak) {
            peakHeapUsageBytes.compareAndSet(currentPeak, usedBytes);
        }
        if (usedPct > MEMORY_USAGE_THRESHOLD_PCT) {
            String alert = String.format("Memory usage exceeded threshold: %.1f%% > %.1f%%", usedPct, MEMORY_USAGE_THRESHOLD_PCT);
            PerformanceManager.addThresholdAlert(alert);
        }
    }

    public static void recordGcEvent(long durationMs) {
        if (!PerformanceManager.isEnabled()) {
            return;
        }
        gcCount.incrementAndGet();
        gcTimeMs.addAndGet(durationMs);
        if (durationMs > GC_DURATION_THRESHOLD_MS) {
            String alert = String.format("GC duration exceeded threshold: %dms > %dms", durationMs, GC_DURATION_THRESHOLD_MS);
            PerformanceManager.addThresholdAlert(alert);
        }
    }

    public static void addThresholdAlert(String alert) {
        if (!PerformanceManager.isEnabled() || alert == null || alert.isBlank()) {
            return;
        }
        thresholdAlerts.add(alert);
    }

    public static void clearThresholdAlerts() {
        if (!PerformanceManager.isEnabled()) {
            return;
        }
        thresholdAlerts.clear();
    }

    public static Map<String, Object> getJniCallMetrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("totalCalls", totalJniCalls.get());
        metrics.put("totalDurationMs", totalJniCallDurationMs.get());
        metrics.put("maxDurationMs", maxJniCallDurationMs.get());
        metrics.put("callTypes", new HashMap<String, AtomicLong>(jniCallTypes));
        return metrics;
    }

    public static Map<String, Object> getLockWaitMetrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("totalWaits", totalLockWaits.get());
        metrics.put("totalWaitTimeMs", totalLockWaitTimeMs.get());
        metrics.put("maxWaitTimeMs", maxLockWaitTimeMs.get());
        metrics.put("currentContention", currentLockContention.get());
        return metrics;
    }

    public static Map<String, Object> getLockWaitTypeMetrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("totalWaits", totalLockWaits.get());
        metrics.put("totalWaitTimeMs", totalLockWaitTimeMs.get());
        metrics.put("maxWaitTimeMs", maxLockWaitTimeMs.get());
        metrics.put("currentContention", currentLockContention.get());
        metrics.put("lockWaitTypes", new HashMap<String, AtomicLong>(lockWaitTypes));
        return metrics;
    }

    public static Map<String, Object> getMemoryMetrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("totalHeapBytes", totalHeapBytes.get());
        metrics.put("usedHeapBytes", usedHeapBytes.get());
        metrics.put("freeHeapBytes", freeHeapBytes.get());
        metrics.put("peakHeapBytes", peakHeapUsageBytes.get());
        metrics.put("gcCount", gcCount.get());
        metrics.put("gcTimeMs", gcTimeMs.get());
        return metrics;
    }

    public static Map<String, Object> getAllocationMetrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("totalAllocations", totalAllocations.get());
        metrics.put("totalAllocationBytes", totalAllocationBytes.get());
        metrics.put("maxAllocationSizeBytes", maxAllocationSizeBytes.get());
        metrics.put("totalDeallocations", totalDeallocations.get());
        metrics.put("avgAllocationLatencyNs", totalAllocations.get() > 0L ? allocationLatencyNanos.get() / totalAllocations.get() : 0L);
        metrics.put("allocationTypes", new HashMap<String, AtomicLong>(allocationTypes));
        metrics.put("allocationPressureEvents", allocationPressureEvents.get());
        metrics.put("highAllocationLatencyEvents", highAllocationLatencyEvents.get());
        return metrics;
    }

    public static Map<String, Object> getLockContentionMetrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("totalContentionEvents", lockContentionEvents.get());
        metrics.put("totalContentionWaitTimeMs", totalContentionWaitTimeMs.get());
        metrics.put("maxQueueLength", maxQueueLength.get());
        metrics.put("lockContentionTypes", new HashMap<String, AtomicInteger>(lockContentionTypes));
        return metrics;
    }

    public static Map<String, Object> getCallGraphMetrics() {
        if (!CALL_GRAPH_ENABLED) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        for (Map.Entry<String, CallGraphNode> entry : callGraph.entrySet()) {
            HashMap<String, Serializable> nodeMetrics = new HashMap<String, Serializable>();
            CallGraphNode node = entry.getValue();
            nodeMetrics.put("totalExecutionTimeNs", Long.valueOf(node.totalExecutionTimeNs));
            nodeMetrics.put("callCount", Long.valueOf(node.callCount));
            nodeMetrics.put("maxExecutionTimeNs", Long.valueOf(node.maxExecutionTimeNs));
            nodeMetrics.put("minExecutionTimeNs", Long.valueOf(node.minExecutionTimeNs));
            nodeMetrics.put("avgExecutionTimeNs", Long.valueOf(node.callCount > 0L ? node.totalExecutionTimeNs / node.callCount : 0L));
            HashMap childMetrics = new HashMap();
            for (Map.Entry<String, CallGraphNode> childEntry : node.children.entrySet()) {
                CallGraphNode childNode = childEntry.getValue();
                HashMap<String, Long> childData = new HashMap<String, Long>();
                childData.put("totalExecutionTimeNs", childNode.totalExecutionTimeNs);
                childData.put("callCount", childNode.callCount);
                childData.put("avgExecutionTimeNs", childNode.callCount > 0L ? childNode.totalExecutionTimeNs / childNode.callCount : 0L);
                childMetrics.put(childEntry.getKey(), childData);
            }
            nodeMetrics.put("children", childMetrics);
            metrics.put(entry.getKey(), nodeMetrics);
        }
        return metrics;
    }

    public static List<String> getThresholdAlerts() {
        return new ArrayList<String>(thresholdAlerts);
    }

    public static void onServerTick(MinecraftServer server) {
        ProfileData profile;
        if (!PerformanceManager.isEnabled()) {
            return;
        }
        PerformanceManager.beginMethod("onServerTick");
        PerformanceManager.startTiming();
        PerformanceManager.getEntityProcessor().onServerTick(server);
        long entityProcessingNanos = PerformanceManager.getElapsedNanos();
        PerformanceManager.resetTiming();
        if (TICK_COUNTER % 100 == 0) {
            PerformanceManager.startTiming();
            PerformanceManager.logRealTimeStatus();
            long statusLogNanos = PerformanceManager.getElapsedNanos();
            PerformanceManager.resetTiming();
            if (PROFILING_ENABLED && TICK_COUNTER % PROFILING_SAMPLE_RATE == 0 && (profile = PROFILE_DATA.get()) != null) {
                profile.reset();
                profile.entityCollectionTime = entityProcessingNanos;
                profile.spatialGridTime = statusLogNanos;
            }
        }
        PerformanceManager.startTiming();
        PerformanceManager.updateTPS();
        long tpsUpdateNanos = PerformanceManager.getElapsedNanos();
        PerformanceManager.resetTiming();
        if (TICK_COUNTER % 500 == 0) {
            ProfileData profile2;
            PerformanceManager.startTiming();
            PerformanceManager.logPerformanceSummary();
            long summaryLogNanos = PerformanceManager.getElapsedNanos();
            PerformanceManager.resetTiming();
            if (PROFILING_ENABLED && (profile2 = PROFILE_DATA.get()) != null) {
                profile2.reset();
                profile2.TOTAL_TICK_TIME = entityProcessingNanos + summaryLogNanos + tpsUpdateNanos;
                profile2.executorQueueSize = PerformanceManager.getExecutorQueueSize();
            }
        }
        if (PROFILING_ENABLED && TICK_COUNTER % PROFILING_SAMPLE_RATE == 0 && (profile = PROFILE_DATA.get()) != null) {
            profile.reset();
            profile.TOTAL_TICK_TIME = entityProcessingNanos + tpsUpdateNanos;
            profile.executorQueueSize = PerformanceManager.getExecutorQueueSize();
        }
        ++TICK_COUNTER;
        PerformanceManager.endMethod();
    }

    private static void logRealTimeStatus() {
        if (!PerformanceManager.isEnabled() || !CONFIG.isBroadcastToClient()) {
            return;
        }
        try {
            double tps = PerformanceManager.getAverageTPS();
            long tickDurationMs = PerformanceManager.getLastTickDurationMs();
            long gcEvents = gcCount.get();
            double memoryUsagePct = totalHeapBytes.get() > 0L ? (double)usedHeapBytes.get() * 100.0 / (double)totalHeapBytes.get() : 0.0;
            int lockContention = currentLockContention.get();
            boolean serverLagging = tickDurationMs > 50L;
            String lagStatus = serverLagging ? "LAGGING" : "NORMAL";
            String systemStatus = String.format("TPS: %.2f, Tick: %dms, Memory: %.1f%%, GC: %d, Locks: %d, Status: %s", tps, tickDurationMs, memoryUsagePct, gcEvents, lockContention, lagStatus);
            Object importantEvents = "";
            if (memoryUsagePct > 90.0) {
                importantEvents = (String)importantEvents + "HIGH_MEMORY_USAGE ";
            }
            if (lockContention > 10) {
                importantEvents = (String)importantEvents + "HIGH_LOCK_CONTENTION ";
            }
            if (tps < 15.0) {
                importantEvents = (String)importantEvents + "LOW_TPS ";
            }
            if (serverLagging) {
                importantEvents = (String)importantEvents + "SERVER_LAGGING ";
            }
            RustPerformance.logRealTimeStatus(systemStatus, (String)(((String)importantEvents).isEmpty() ? null : importantEvents));
        }
        catch (Exception e) {
            LOGGER.debug("Error logging real-time status", (Throwable)e);
        }
    }

    private static void logPerformanceSummary() {
        if (!PerformanceManager.isEnabled() || !CONFIG.isBroadcastToClient()) {
            return;
        }
        try {
            double tps = PerformanceManager.getAverageTPS();
            long tickDurationMs = PerformanceManager.getLastTickDurationMs();
            long gcEvents = gcCount.get();
            double memoryUsagePct = totalHeapBytes.get() > 0L ? (double)usedHeapBytes.get() * 100.0 / (double)totalHeapBytes.get() : 0.0;
            int lockContention = currentLockContention.get();
            boolean serverLagging = tickDurationMs > 50L;
            String performanceStatus = serverLagging ? "DEGRADED" : "NORMAL";
            String.format("Performance Metrics: {:.2f} TPS, {:.2f}ms latency, {} GC events, Status: {}", tps, tickDurationMs, gcEvents, performanceStatus);
            RustPerformance.logPerformanceMetrics(tps, tickDurationMs, gcEvents);
            double hitRate = 92.0;
            int contention = currentLockContention.get();
            RustPerformance.logMemoryPoolStatus(memoryUsagePct, hitRate, contention);
            ThreadPoolExecutor executor = PerformanceManager.getExecutor();
            int activeThreads = executor != null ? executor.getActiveCount() : 0;
            int queueSize = PerformanceManager.getExecutorQueueSize();
            double utilization = PerformanceManager.getThreadPoolManager().getExecutorUtilization();
            RustPerformance.logThreadPoolStatus(activeThreads, queueSize, utilization);
            if (serverLagging) {
                LOGGER.warn("[KneafMod] Server performance degraded: TPS={:.2f}, Tick={}ms, Memory={:.1f}%, Locks={}", new Object[]{tps, tickDurationMs, memoryUsagePct, lockContention});
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error logging performance summary", (Throwable)e);
        }
    }

    private static void prepareProfiling(ProfileData profile, boolean shouldProfile, long tickStartTime) {
        if (shouldProfile && profile != null) {
            profile.executorQueueSize = PerformanceManager.getExecutorQueueSize();
            profile.TOTAL_TICK_TIME = System.nanoTime() - tickStartTime;
        }
    }

    private static EntityDataCollection collectAndConsolidate(MinecraftServer server, boolean shouldProfile, ProfileData profile) {
        long entityCollectionStart = shouldProfile ? System.nanoTime() : 0L;
        EntityDataCollection data = PerformanceManager.collectEntityData(server);
        if (shouldProfile && profile != null) {
            profile.entityCollectionTime = System.nanoTime() - entityCollectionStart;
            profile.entitiesProcessed = data.entities().size();
            profile.itemsProcessed = data.items().size();
        }
        long consolidationStart = shouldProfile ? System.nanoTime() : 0L;
        List<ItemEntityData> consolidated = PerformanceManager.consolidateItemEntities(data.items());
        if (shouldProfile && profile != null) {
            profile.itemConsolidationTime = System.nanoTime() - consolidationStart;
        }
        return new EntityDataCollection(data.entities(), consolidated, data.mobs(), data.blockEntities(), data.players());
    }

    private static void submitAsyncOptimizations(MinecraftServer server, EntityDataCollection data, boolean shouldProfile) {
        try {
            PerformanceManager.getExecutor().submit(() -> PerformanceManager.performAsyncOptimization(server, data, shouldProfile));
        }
        catch (Exception e) {
            LOGGER.debug("Executor rejected task; running synchronously", (Throwable)e);
            PerformanceManager.runSynchronousOptimizations(server, data, shouldProfile);
        }
    }

    private static void performAsyncOptimization(MinecraftServer server, EntityDataCollection data, boolean shouldProfile) {
        try {
            ProfileData profile;
            long processingStart = shouldProfile ? System.nanoTime() : 0L;
            OptimizationResults results = PerformanceManager.processOptimizations(data);
            if (shouldProfile && (profile = PROFILE_DATA.get()) != null) {
                profile.optimizationProcessingTime = System.nanoTime() - processingStart;
            }
            server.execute(() -> PerformanceManager.applyOptimizationResults(server, results, shouldProfile));
        }
        catch (Exception e) {
            LOGGER.warn("Error during async processing of optimizations", (Throwable)e);
        }
    }

    private static void applyOptimizationResults(MinecraftServer server, OptimizationResults results, boolean shouldProfile) {
        try {
            ProfileData profile;
            long applicationStart = shouldProfile ? System.nanoTime() : 0L;
            PerformanceManager.applyOptimizations(server, results);
            if (shouldProfile && (profile = PROFILE_DATA.get()) != null) {
                profile.optimizationApplicationTime = System.nanoTime() - applicationStart;
            }
            if (TICK_COUNTER % CONFIG.getLogIntervalTicks() == 0) {
                PerformanceManager.logOptimizations(server, results);
            }
            PerformanceManager.removeItems(server, results.itemResult());
        }
        catch (Exception e) {
            LOGGER.warn("Error applying optimizations on server thread", (Throwable)e);
        }
    }

    private static void runSynchronousOptimizations(MinecraftServer server, EntityDataCollection data, boolean shouldProfile) {
        try {
            ProfileData profile;
            ProfileData profile2;
            long processingStart = shouldProfile ? System.nanoTime() : 0L;
            OptimizationResults results = PerformanceManager.processOptimizations(data);
            if (shouldProfile && (profile2 = PROFILE_DATA.get()) != null) {
                profile2.optimizationProcessingTime = System.nanoTime() - processingStart;
            }
            long applicationStart = shouldProfile ? System.nanoTime() : 0L;
            PerformanceManager.applyOptimizations(server, results);
            if (shouldProfile && (profile = PROFILE_DATA.get()) != null) {
                profile.optimizationApplicationTime = System.nanoTime() - applicationStart;
            }
            if (TICK_COUNTER % CONFIG.getLogIntervalTicks() == 0) {
                PerformanceManager.logOptimizations(server, results);
            }
            PerformanceManager.removeItems(server, results.itemResult());
        }
        catch (Exception ex) {
            LOGGER.warn("Error processing optimizations synchronously", (Throwable)ex);
        }
    }

    private static void runSynchronousOptimizations(MinecraftServer server, EntityProcessor.EntityDataCollection data, boolean shouldProfile) {
        try {
            ProfileData profile;
            ProfileData profile2;
            long processingStart = shouldProfile ? System.nanoTime() : 0L;
            EntityProcessor.OptimizationResults processorResults = PerformanceManager.getEntityProcessor().processOptimizations(data);
            OptimizationResults results = PerformanceManager.adaptOptimizationResults(processorResults);
            if (shouldProfile && (profile2 = PROFILE_DATA.get()) != null) {
                profile2.optimizationProcessingTime = System.nanoTime() - processingStart;
            }
            long applicationStart = shouldProfile ? System.nanoTime() : 0L;
            PerformanceManager.getEntityProcessor().applyOptimizations(server, processorResults);
            if (shouldProfile && (profile = PROFILE_DATA.get()) != null) {
                profile.optimizationApplicationTime = System.nanoTime() - applicationStart;
            }
            if (TICK_COUNTER % CONFIG.getLogIntervalTicks() == 0) {
                PerformanceManager.logOptimizations(server, results);
            }
            PerformanceManager.getEntityProcessor().removeItems(server, processorResults.itemResult());
        }
        catch (Exception ex) {
            LOGGER.warn("Error processing optimizations synchronously", (Throwable)ex);
        }
    }

    private static OptimizationResults adaptOptimizationResults(EntityProcessor.OptimizationResults source) {
        return new OptimizationResults(source.toTick(), source.blockResult(), source.itemResult(), source.mobResult());
    }

    private static void updateTPS() {
        long currentTime = System.nanoTime();
        if (lastTickTime != 0L) {
            long delta;
            lastTickDurationNanos = delta = currentTime - lastTickTime;
            double tps = 1.0E9 / (double)delta;
            if (delta > 100000000L) {
                tps = Math.min(20.0, 1000.0 / ((double)delta / 1000000.0));
            }
            RustPerformance.setCurrentTPS(tps);
            PerformanceManager.TPS_WINDOW[PerformanceManager.tpsWindowIndex % 8] = tps;
            tpsWindowIndex = (tpsWindowIndex + 1) % 8;
        }
        if (lastTickTime == 0L) {
            lastTickDurationNanos = 0L;
        }
        lastTickTime = currentTime;
    }

    public static long getLastTickDurationMs() {
        return lastTickDurationNanos / 1000000L;
    }

    public static double getAverageTPS() {
        return PerformanceManager.getRollingAvgTPS();
    }

    private static double getRollingAvgTPS() {
        double sum = 0.0;
        int count = 0;
        for (double v : TPS_WINDOW) {
            if (!(v > 0.0)) continue;
            sum += v;
            ++count;
        }
        if (count > 0) {
            double avg = sum / (double)count;
            return avg;
        }
        return 20.0;
    }

    private static EntityDataCollection collectEntityData(MinecraftServer server) {
        int estimatedEntities = Math.min(CONFIG.getMaxEntitiesToCollect(), 5000);
        ArrayList<EntityData> entities = new ArrayList<EntityData>(estimatedEntities);
        ArrayList<ItemEntityData> items = new ArrayList<ItemEntityData>(estimatedEntities / 4);
        ArrayList<MobData> mobs = new ArrayList<MobData>(estimatedEntities / 8);
        ArrayList<BlockEntityData> blockEntities = new ArrayList<BlockEntityData>(128);
        ArrayList<PlayerData> players = new ArrayList<PlayerData>(32);
        int maxEntities = CONFIG.getMaxEntitiesToCollect();
        double distanceCutoff = CONFIG.getEntityDistanceCutoff();
        String[] excludedTypes = CONFIG.getExcludedEntityTypes();
        double cutoffSq = distanceCutoff * distanceCutoff;
        for (ServerLevel level : server.getAllLevels()) {
            List serverPlayers = level.players();
            ArrayList<PlayerData> levelPlayers = new ArrayList<PlayerData>(serverPlayers.size());
            for (ServerPlayer p : serverPlayers) {
                levelPlayers.add(new PlayerData(p.getId(), p.getX(), p.getY(), p.getZ()));
            }
            PerformanceManager.collectEntitiesFromLevel(level, new EntityCollectionContext(entities, items, mobs, maxEntities, distanceCutoff, levelPlayers, excludedTypes, cutoffSq));
            players.addAll(levelPlayers);
            if (entities.size() < maxEntities) continue;
            break;
        }
        return new EntityDataCollection(entities, items, mobs, blockEntities, players);
    }

    private static void collectEntitiesFromLevel(ServerLevel level, EntityCollectionContext context) {
        ProfileData profile;
        PerformanceManager.beginMethod("collectEntitiesFromLevel");
        long spatialStart = PROFILING_ENABLED && TICK_COUNTER % PROFILING_SAMPLE_RATE == 0 ? System.nanoTime() : 0L;
        SpatialGrid spatialGrid = PerformanceManager.getOrCreateSpatialGrid(level, context.players());
        if (PROFILING_ENABLED && TICK_COUNTER % PROFILING_SAMPLE_RATE == 0 && (profile = PROFILE_DATA.get()) != null) {
            profile.spatialGridTime += System.nanoTime() - spatialStart;
        }
        AABB searchBounds = PerformanceManager.createSearchBounds(context.players(), context.distanceCutoff());
        if (TICK_COUNTER % PerformanceConstants.getAdaptiveDistanceCalculationInterval(PerformanceManager.getAverageTPS()) == 0) {
            List entityList = level.getEntities(null, searchBounds);
            int entityCount = entityList.size();
            for (int i = 0; i < entityCount && context.entities().size() < context.maxEntities(); ++i) {
                Entity entity = (Entity)entityList.get(i);
                double minSq = PerformanceManager.computeMinSquaredDistanceToPlayersOptimized(entity, spatialGrid, context.distanceCutoff());
                if (!(minSq <= context.cutoffSq())) continue;
                PerformanceManager.processEntityWithinCutoff(entity, minSq, context.excluded(), context.entities(), context.items(), context.mobs());
            }
        } else {
            PerformanceManager.performReducedDistanceCalculation(level, searchBounds, context, spatialGrid);
        }
        PerformanceManager.endMethod();
    }

    private static double computeMinSquaredDistanceToPlayersOptimized(Entity entity, SpatialGrid spatialGrid, double maxSearchRadius) {
        return spatialGrid.findMinSquaredDistance(entity.getX(), entity.getY(), entity.getZ(), maxSearchRadius);
    }

    private static AABB createSearchBounds(List<PlayerData> players, double distanceCutoff) {
        if (players.isEmpty()) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (PlayerData player : players) {
            minX = Math.min(minX, player.getX());
            minY = Math.min(minY, player.getY());
            minZ = Math.min(minZ, player.getZ());
            maxX = Math.max(maxX, player.getX());
            maxY = Math.max(maxY, player.getY());
            maxZ = Math.max(maxZ, player.getZ());
        }
        return new AABB(minX -= distanceCutoff, minY -= distanceCutoff, minZ -= distanceCutoff, maxX += distanceCutoff, maxY += distanceCutoff, maxZ += distanceCutoff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SpatialGrid getOrCreateSpatialGrid(ServerLevel level, List<PlayerData> players) {
        PerformanceManager.beginMethod("getOrCreateSpatialGrid");
        PerformanceManager.startTiming();
        ReentrantLock lock = PerformanceManager.getGridLock(level);
        lock.lock();
        try {
            ProfileData profile;
            long lockWaitNanos = PerformanceManager.getElapsedNanos();
            PerformanceManager.resetTiming();
            SpatialGrid grid = LEVEL_SPATIAL_GRIDS.computeIfAbsent(level, k -> {
                ProfileData profile;
                PerformanceManager.startTiming();
                double cellSize = Math.max(CONFIG.getEntityDistanceCutoff() / 4.0, 16.0);
                long gridCreationNanos = PerformanceManager.getElapsedNanos();
                PerformanceManager.resetTiming();
                if (PROFILING_ENABLED && TICK_COUNTER % PROFILING_SAMPLE_RATE == 0 && (profile = PROFILE_DATA.get()) != null) {
                    profile.spatialGridTime += gridCreationNanos;
                }
                return new SpatialGrid(cellSize);
            });
            PerformanceManager.startTiming();
            grid.clear();
            long clearTimeNanos = PerformanceManager.getElapsedNanos();
            PerformanceManager.resetTiming();
            PerformanceManager.startTiming();
            for (PlayerData player : players) {
                grid.updatePlayer(player);
            }
            long playerUpdateNanos = PerformanceManager.getElapsedNanos();
            PerformanceManager.resetTiming();
            if (PROFILING_ENABLED && (profile = PROFILE_DATA.get()) != null) {
                profile.spatialLockWaitTime += lockWaitNanos;
                profile.spatialGridTime += lockWaitNanos + playerUpdateNanos + clearTimeNanos;
            }
            if (PerformanceManager.isEnabled()) {
                PerformanceManager.recordLockWait("SPATIAL_GRID_LOCK", TimeUnit.NANOSECONDS.toMillis(lockWaitNanos));
            }
            PerformanceManager.endMethod();
            SpatialGrid spatialGrid = grid;
            return spatialGrid;
        }
        finally {
            lock.unlock();
        }
    }

    private static void processEntityWithinCutoff(Entity entity, double minSq, String[] excluded, List<EntityData> entities, List<ItemEntityData> items, List<MobData> mobs) {
        String typeStr = entity.getType().toString();
        if (PerformanceManager.isExcludedType(typeStr, excluded)) {
            return;
        }
        double distance = Math.sqrt(minSq);
        boolean isBlockEntity = false;
        entities.add(new EntityData(entity.getId(), entity.getX(), entity.getY(), entity.getZ(), distance, isBlockEntity, typeStr));
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            PerformanceManager.collectItemEntity(entity, itemEntity, items);
        } else if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            PerformanceManager.collectMobEntity(entity, mob, mobs, distance, typeStr);
        }
    }

    private static boolean isExcludedType(String typeStr, String[] excluded) {
        if (excluded == null || excluded.length == 0) {
            return false;
        }
        for (String ex : excluded) {
            if (ex == null || ex.isEmpty() || !typeStr.contains(ex)) continue;
            return true;
        }
        return false;
    }

    private static void collectItemEntity(Entity entity, ItemEntity itemEntity, List<ItemEntityData> items) {
        ChunkPos chunkPos = entity.chunkPosition();
        ItemStack itemStack = itemEntity.getItem();
        String itemType = itemStack.getItem().getDescriptionId();
        int count = itemStack.getCount();
        int ageSeconds = itemEntity.getAge() / 20;
        items.add(new ItemEntityData(entity.getId(), chunkPos.x, chunkPos.z, itemType, count, ageSeconds));
    }

    private static void performReducedDistanceCalculation(ServerLevel level, AABB searchBounds, EntityCollectionContext context, SpatialGrid spatialGrid) {
        PerformanceManager.beginMethod("performReducedDistanceCalculation");
        double approximateCutoff = context.distanceCutoff() * 1.2;
        double approximateCutoffSq = approximateCutoff * approximateCutoff;
        ArrayList<Entity> candidateEntities = new ArrayList<Entity>();
        for (Entity entity : level.getEntities(null, searchBounds)) {
            if (context.entities().size() >= context.maxEntities()) break;
            double approxMinSq = spatialGrid.findMinSquaredDistance(entity.getX(), entity.getY(), entity.getZ(), approximateCutoff);
            if (!(approxMinSq <= approximateCutoffSq)) continue;
            candidateEntities.add(entity);
        }
        for (Entity entity : candidateEntities) {
            double minSq;
            if (context.entities().size() >= context.maxEntities()) break;
            String typeStr = entity.getType().toString();
            if (PerformanceManager.isExcludedType(typeStr, context.excluded()) || !((minSq = PerformanceManager.computeMinSquaredDistanceToPlayersOptimized(entity, spatialGrid, context.distanceCutoff())) <= context.cutoffSq())) continue;
            PerformanceManager.processEntityWithinCutoff(entity, minSq, context.excluded(), context.entities(), context.items(), context.mobs());
        }
        PerformanceManager.endMethod();
    }

    private static void collectMobEntity(Entity entity, Mob mob, List<MobData> mobs, double distance, String typeStr) {
        boolean isPassive = !(mob instanceof Monster);
        mobs.add(new MobData(entity.getId(), distance, isPassive, typeStr));
    }

    private static long packItemKey(int chunkX, int chunkZ, String itemType) {
        long packedChunkX = (long)chunkX & 0x1FFFFFL;
        long packedChunkZ = (long)chunkZ & 0x1FFFFFL;
        long itemHash = itemType == null ? 0L : (long)itemType.hashCode() & 0x3FFFFFL;
        return packedChunkX << 43 | packedChunkZ << 22 | itemHash;
    }

    private static List<ItemEntityData> consolidateItemEntities(List<ItemEntityData> items) {
        if (items == null || items.isEmpty()) {
            return items;
        }
        int estimatedSize = Math.min(items.size(), items.size() / 2 + 1);
        HashMap<Long, ItemEntityData> agg = HashMap.newHashMap(estimatedSize);
        for (ItemEntityData it : items) {
            long key = PerformanceManager.packItemKey(it.getChunkX(), it.getChunkZ(), it.getItemType());
            ItemEntityData cur = (ItemEntityData)agg.get(key);
            if (cur == null) {
                agg.put(key, it);
                continue;
            }
            int newCount = cur.getCount() + it.getCount();
            int newAge = Math.min(cur.getAgeSeconds(), it.getAgeSeconds());
            long preservedId = cur.getId();
            agg.put(key, new ItemEntityData(preservedId, it.getChunkX(), it.getChunkZ(), it.getItemType(), newCount, newAge));
        }
        return new ArrayList<ItemEntityData>(agg.values());
    }

    private static OptimizationResults processOptimizations(EntityDataCollection data) {
        PerformanceManager.beginMethod("processOptimizations");
        PerformanceManager.startTiming();
        List<Long> toTick = RustPerformance.getEntitiesToTick(data.entities(), data.players());
        long getEntitiesToTickNanos = PerformanceManager.getElapsedNanos();
        PerformanceManager.resetTiming();
        PerformanceManager.recordJniCall("getEntitiesToTick", TimeUnit.NANOSECONDS.toMillis(getEntitiesToTickNanos));
        PerformanceManager.startTiming();
        List<Long> blockResult = RustPerformance.getBlockEntitiesToTick(data.blockEntities());
        long getBlockEntitiesToTickNanos = PerformanceManager.getElapsedNanos();
        PerformanceManager.resetTiming();
        PerformanceManager.recordJniCall("getBlockEntitiesToTick", TimeUnit.NANOSECONDS.toMillis(getBlockEntitiesToTickNanos));
        PerformanceManager.startTiming();
        ItemProcessResult itemResult = RustPerformance.processItemEntities(data.items());
        long processItemEntitiesNanos = PerformanceManager.getElapsedNanos();
        PerformanceManager.resetTiming();
        PerformanceManager.recordJniCall("processItemEntities", TimeUnit.NANOSECONDS.toMillis(processItemEntitiesNanos));
        PerformanceManager.startTiming();
        MobProcessResult mobResult = RustPerformance.processMobAI(data.mobs());
        long processMobAINanos = PerformanceManager.getElapsedNanos();
        PerformanceManager.resetTiming();
        PerformanceManager.recordJniCall("processMobAI", TimeUnit.NANOSECONDS.toMillis(processMobAINanos));
        return new OptimizationResults(toTick, blockResult, itemResult, mobResult);
    }

    private static void applyOptimizations(MinecraftServer server, OptimizationResults results) {
        PerformanceManager.applyItemUpdates(server, results.itemResult());
        PerformanceManager.applyMobOptimizations(server, results.mobResult());
        try {
            PerformanceOptimizer.OptimizationLevel level;
            RustPerformanceFacade facade = RustPerformanceFacade.getInstance();
            PerformanceOptimizer.OptimizationLevel optimizationLevel = level = facade.isNativeAvailable() ? facade.getCurrentOptimizationLevel() : null;
            if (level != null) {
                PerformanceManager.setTargetDistance(server, switch (level) {
                    case PerformanceOptimizer.OptimizationLevel.AGGRESSIVE -> 8;
                    case PerformanceOptimizer.OptimizationLevel.HIGH -> 12;
                    case PerformanceOptimizer.OptimizationLevel.MEDIUM -> 16;
                    case PerformanceOptimizer.OptimizationLevel.NORMAL -> 32;
                    default -> 16;
                });
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Failed to enforce server distance bounds: {}", (Object)t.getMessage());
            PerformanceManager.endMethod();
        }
    }

    private static void setTargetDistance(MinecraftServer server, int targetChunks) {
        if (server == null) {
            return;
        }
        for (ServerLevel level : server.getAllLevels()) {
            try {
                if (!ORIGINAL_VIEW_DISTANCE.containsKey(level)) {
                    try {
                        Method m = PerformanceManager.resolveViewGetter(level.getClass());
                        if (m != null) {
                            int current = (Integer)m.invoke((Object)level, new Object[0]);
                            ORIGINAL_VIEW_DISTANCE.put(level, current);
                        }
                    }
                    catch (Throwable m) {
                        // empty catch block
                    }
                }
                if (!ORIGINAL_SIMULATION_DISTANCE.containsKey(level)) {
                    try {
                        Method sm = PerformanceManager.resolveSimGetter(level.getClass());
                        if (sm != null) {
                            int curSim = (Integer)sm.invoke((Object)level, new Object[0]);
                            ORIGINAL_SIMULATION_DISTANCE.put(level, curSim);
                        }
                    }
                    catch (Throwable sm) {
                        // empty catch block
                    }
                }
                TARGET_DISTANCE.put(level, targetChunks);
                TRANSITION_REMAINING.put(level, 20);
                TARGET_SIMULATION_DISTANCE.put(level, targetChunks);
                TRANSITION_REMAINING_SIM.put(level, 20);
            }
            catch (Throwable t) {
                LOGGER.debug("Failed to set target distance for level {}: {}", (Object)level, (Object)t.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyDistanceTransitions(MinecraftServer server) {
        int next;
        Integer orig;
        int current;
        Class<?> lvlClass;
        Integer target;
        Integer remaining;
        if (server == null) {
            return;
        }
        for (ServerLevel level : server.getAllLevels()) {
            remaining = (Integer)TRANSITION_REMAINING.get(level);
            target = (Integer)TARGET_DISTANCE.get(level);
            if (remaining == null || target == null) continue;
            try {
                lvlClass = level.getClass();
                Method vg = PerformanceManager.resolveViewGetter(lvlClass);
                if (vg == null) {
                    TRANSITION_REMAINING.remove(level);
                    TARGET_DISTANCE.remove(level);
                    continue;
                }
                current = (Integer)vg.invoke((Object)level, new Object[0]);
                if (remaining <= 1) {
                    try {
                        Method setView = PerformanceManager.resolveViewSetter(lvlClass);
                        if (setView != null) {
                            setView.invoke((Object)level, target);
                        }
                    }
                    catch (Throwable setView) {
                        // empty catch block
                    }
                    TRANSITION_REMAINING.remove(level);
                    TARGET_DISTANCE.remove(level);
                    orig = (Integer)ORIGINAL_VIEW_DISTANCE.get(level);
                    if (orig == null || !orig.equals(target)) continue;
                    ORIGINAL_VIEW_DISTANCE.remove(level);
                    continue;
                }
                int step = (int)Math.ceil((double)(target - current) / (double)remaining.intValue());
                next = current + step;
                try {
                    Method setView = PerformanceManager.resolveViewSetter(lvlClass);
                    if (setView != null) {
                        setView.invoke((Object)level, next);
                    }
                }
                catch (Throwable setView) {
                    // empty catch block
                }
                int rem = remaining;
                TRANSITION_REMAINING.put(level, rem - 1);
            }
            catch (Throwable t) {
                LOGGER.debug("Error transitioning distance for level {}: {}", (Object)level, (Object)t.getMessage());
                TRANSITION_REMAINING.remove(level);
                TARGET_DISTANCE.remove(level);
            }
        }
        for (ServerLevel level : server.getAllLevels()) {
            remaining = (Integer)TRANSITION_REMAINING_SIM.get(level);
            target = (Integer)TARGET_SIMULATION_DISTANCE.get(level);
            if (remaining == null || target == null) continue;
            try {
                lvlClass = level.getClass();
                Method sg = PerformanceManager.resolveSimGetter(lvlClass);
                if (sg == null) {
                    TRANSITION_REMAINING_SIM.remove(level);
                    TARGET_SIMULATION_DISTANCE.remove(level);
                    continue;
                }
                current = (Integer)sg.invoke((Object)level, new Object[0]);
                if (remaining <= 1) {
                    try {
                        Method setSim = PerformanceManager.resolveSimSetter(lvlClass);
                        if (setSim != null) {
                            setSim.invoke((Object)level, target);
                        }
                    }
                    catch (Throwable setSim) {
                        // empty catch block
                    }
                    TRANSITION_REMAINING_SIM.remove(level);
                    TARGET_SIMULATION_DISTANCE.remove(level);
                    orig = (Integer)ORIGINAL_SIMULATION_DISTANCE.get(level);
                    if (orig == null || !orig.equals(target)) continue;
                    ORIGINAL_SIMULATION_DISTANCE.remove(level);
                    continue;
                }
                int step = (int)Math.ceil((double)(target - current) / (double)remaining.intValue());
                next = current + step;
                try {
                    Method setSim = PerformanceManager.resolveSimSetter(lvlClass);
                    if (setSim != null) {
                        setSim.invoke((Object)level, next);
                    }
                }
                catch (Throwable setSim) {
                    // empty catch block
                }
                int remSim = remaining;
                TRANSITION_REMAINING_SIM.put(level, remSim - 1);
            }
            catch (Throwable t) {
                LOGGER.debug("Error transitioning simulation distance for level {}: {}", (Object)level, (Object)t.getMessage());
                TRANSITION_REMAINING_SIM.remove(level);
                TARGET_SIMULATION_DISTANCE.remove(level);
            }
        }
        for (ServerLevel level : server.getAllLevels()) {
            if (TARGET_DISTANCE.containsKey(level) || !ORIGINAL_VIEW_DISTANCE.containsKey(level)) continue;
            try {
                int orig2;
                int current2;
                Class<?> lvlClass2 = level.getClass();
                Method vg = PerformanceManager.resolveViewGetter(lvlClass2);
                Method vs = PerformanceManager.resolveViewSetter(lvlClass2);
                if (vg == null || vs == null || (current2 = ((Number)vg.invoke((Object)level, new Object[0])).intValue()) == (orig2 = ((Integer)ORIGINAL_VIEW_DISTANCE.get(level)).intValue())) continue;
                vs.invoke((Object)level, orig2);
            }
            catch (Throwable t) {
                PerformanceManager.disableReflectionForClass(level.getClass(), "restoreView", t);
            }
            finally {
                ORIGINAL_VIEW_DISTANCE.remove(level);
            }
        }
    }

    private static void applyItemUpdates(MinecraftServer server, ItemProcessResult itemResult) {
        if (itemResult == null || itemResult.getItemUpdates() == null) {
            return;
        }
        HashMap<Integer, PerformanceProcessor.ItemUpdate> updateMap = new HashMap<Integer, PerformanceProcessor.ItemUpdate>();
        for (PerformanceProcessor.ItemUpdate update : itemResult.getItemUpdates()) {
            updateMap.put((int)update.getId(), update);
        }
        for (ServerLevel level : server.getAllLevels()) {
            for (Map.Entry entry : updateMap.entrySet()) {
                Entity entity = level.getEntity(((Integer)entry.getKey()).intValue());
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                PerformanceProcessor.ItemUpdate update = (PerformanceProcessor.ItemUpdate)entry.getValue();
                itemEntity.getItem().setCount(update.getNewCount());
            }
        }
    }

    private static void applyMobOptimizations(MinecraftServer server, MobProcessResult mobResult) {
        if (mobResult == null) {
            return;
        }
        HashSet<Integer> disableAiIds = new HashSet<Integer>();
        for (Long id : mobResult.getDisableList()) {
            disableAiIds.add(id.intValue());
        }
        HashSet<Integer> simplifyAiIds = new HashSet<Integer>();
        for (Long id : mobResult.getSimplifyList()) {
            simplifyAiIds.add(id.intValue());
        }
        for (ServerLevel level : server.getAllLevels()) {
            Entity entity;
            for (Integer id : disableAiIds) {
                entity = level.getEntity(id.intValue());
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                mob.setNoAi(true);
            }
            for (Integer id : simplifyAiIds) {
                entity = level.getEntity(id.intValue());
                if (!(entity instanceof Mob)) continue;
            }
        }
    }

    private static void logOptimizations(MinecraftServer server, OptimizationResults results) {
        if (TICK_COUNTER % 100 == 0 && PerformanceManager.hasMeaningfulOptimizations(results)) {
            PerformanceManager.logReadableOptimizations(server, results);
        }
        if (TICK_COUNTER % 1000 == 0) {
            PerformanceManager.getEntityProcessor().logSpatialGridStats(server);
        }
        if (TICK_COUNTER % CONFIG.getLogIntervalTicks() == 0 && PerformanceManager.hasMeaningfulOptimizations(results)) {
            String summary = PerformanceManager.buildOptimizationSummary(results);
            PerformanceMetricsLogger.logOptimizations(summary);
            PerformanceManager.broadcastPerformanceLine(server, "OPTIMIZATIONS " + summary);
        }
    }

    private static void logReadableOptimizations(MinecraftServer server, OptimizationResults results) {
        if (results == null) {
            return;
        }
        if (results.itemResult() != null) {
            long merged = results.itemResult().getMergedCount();
            long despawned = results.itemResult().getDespawnedCount();
            if (merged > 0L || despawned > 0L) {
                PerformanceManager.broadcastPerformanceLine(server, String.format("Item optimization: %d merged, %d despawned", merged, despawned));
            }
            if (!results.itemResult().getItemsToRemove().isEmpty()) {
                PerformanceManager.broadcastPerformanceLine(server, String.format("Items removed: %d", results.itemResult().getItemsToRemove().size()));
            }
        }
        if (results.mobResult() != null) {
            int disabled = results.mobResult().getDisableList().size();
            int simplified = results.mobResult().getSimplifyList().size();
            if (disabled > 0 || simplified > 0) {
                PerformanceManager.broadcastPerformanceLine(server, String.format("Mob AI optimization: %d disabled, %d simplified", disabled, simplified));
            }
        }
        if (results.blockResult() != null && !results.blockResult().isEmpty()) {
            PerformanceManager.broadcastPerformanceLine(server, String.format("Block entities to tick (reduced): %d", results.blockResult().size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logSpatialGridStats(MinecraftServer server) {
        ReentrantLock globalLock = STRIPED_LOCKS[0];
        globalLock.lock();
        try {
            int totalLevels = LEVEL_SPATIAL_GRIDS.size();
            int totalPlayers = 0;
            int totalCells = 0;
            for (SpatialGrid grid : LEVEL_SPATIAL_GRIDS.values()) {
                SpatialGrid.GridStats Stats = grid.getStats();
                totalPlayers += Stats.totalPlayers();
                totalCells += Stats.totalCells();
            }
            String summary = String.format("SpatialGrid Stats: %d levels, %d players, %d cells, avg %s players/cell", totalLevels, totalPlayers, totalCells, totalCells > 0 ? String.format("%.2f", (double)totalPlayers / (double)totalCells) : "0.00");
            PerformanceMetricsLogger.logLine(summary);
            if (CONFIG.isBroadcastToClient()) {
                PerformanceManager.broadcastPerformanceLine(server, summary);
            }
        }
        finally {
            globalLock.unlock();
        }
    }

    private static void logSlowTick(MinecraftServer server, ProfileData profile) {
        if (profile == null) {
            return;
        }
        String jsonProfile = profile.toJson();
        String message = String.format("SLOW_TICK: tick=%d avgTps=%.2f threshold=%.2f %s", TICK_COUNTER, PerformanceManager.getRollingAvgTPS(), currentTpsThreshold, jsonProfile);
        PerformanceMetricsLogger.logLine("SLOW_TICK " + message);
        if (CONFIG.isBroadcastToClient()) {
            try {
                for (ServerLevel level : server.getAllLevels()) {
                    for (ServerPlayer player : level.players()) {
                        player.displayClientMessage((Component)Component.literal((String)message), false);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to broadcast performance message to players", (Throwable)e);
            }
        }
    }

    public static void broadcastPerformanceLine(MinecraftServer server, String line) {
        PerformanceMetricsLogger.logLine(line);
        if (!CONFIG.isBroadcastToClient()) {
            return;
        }
        try {
            for (ServerLevel level : server.getAllLevels()) {
                for (ServerPlayer player : level.players()) {
                    player.displayClientMessage((Component)Component.literal((String)line), false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to broadcast performance line to players", (Throwable)e);
        }
    }

    private static String buildOptimizationSummary(OptimizationResults results) {
        double avg = PerformanceManager.getRollingAvgTPS();
        long itemsMerged = results.itemResult() == null ? 0L : results.itemResult().getMergedCount();
        long itemsDespawned = results.itemResult() == null ? 0L : results.itemResult().getDespawnedCount();
        int mobsDisabled = results.mobResult() == null ? 0 : results.mobResult().getDisableList().size();
        int mobsSimplified = results.mobResult() == null ? 0 : results.mobResult().getSimplifyList().size();
        int itemsRemoved = results.itemResult() == null ? 0 : results.itemResult().getItemsToRemove().size();
        int blockEntities = results.blockResult() == null ? 0 : results.blockResult().size();
        int queueSize = PerformanceManager.getExecutorQueueSize();
        return String.format("avgTps=%.2f currentThreshold=%.2f queueSize=%d itemsMerged=%d itemsDespawned=%d mobsDisabled=%d mobsSimplified=%d itemsRemoved=%d blockEntities=%d", avg, currentTpsThreshold, queueSize, itemsMerged, itemsDespawned, mobsDisabled, mobsSimplified, itemsRemoved, blockEntities);
    }

    private static boolean hasMeaningfulOptimizations(OptimizationResults results) {
        if (results == null) {
            return false;
        }
        if (results.itemResult() != null) {
            if (results.itemResult().getMergedCount() > 0L) {
                return true;
            }
            if (results.itemResult().getDespawnedCount() > 0L) {
                return true;
            }
            if (!results.itemResult().getItemsToRemove().isEmpty()) {
                return true;
            }
        }
        if (results.mobResult() != null) {
            if (!results.mobResult().getDisableList().isEmpty()) {
                return true;
            }
            if (!results.mobResult().getSimplifyList().isEmpty()) {
                return true;
            }
        }
        return results.blockResult() != null && !results.blockResult().isEmpty();
    }

    private static void removeItems(MinecraftServer server, ItemProcessResult itemResult) {
        if (itemResult == null || itemResult.getItemsToRemove() == null || itemResult.getItemsToRemove().isEmpty()) {
            return;
        }
        for (ServerLevel level : server.getAllLevels()) {
            for (Long id : itemResult.getItemsToRemove()) {
                try {
                    Entity entity = level.getEntity(id.intValue());
                    if (entity == null) continue;
                    entity.remove(Entity.RemovalReason.DISCARDED);
                }
                catch (Exception e) {
                    LOGGER.debug("Error removing item entity { } on level { }", new Object[]{id, level.dimension(), e});
                }
            }
        }
    }

    static {
        CALL_GRAPH_ENABLED = PROFILING_ENABLED = CONFIG.isProfilingEnabled();
        PROFILING_SAMPLE_RATE = CONFIG.getProfilingSampleRate();
        TPS_WINDOW = new double[8];
        tpsWindowIndex = 0;
        PROFILE_DATA = new ThreadLocal<ProfileData>(){

            @Override
            protected ProfileData initialValue() {
                return new ProfileData();
            }
        };
        ORIGINAL_VIEW_DISTANCE = new ConcurrentHashMap<ServerLevel, Integer>();
        TARGET_DISTANCE = new ConcurrentHashMap<ServerLevel, Integer>();
        TRANSITION_REMAINING = new ConcurrentHashMap<ServerLevel, Integer>();
        ORIGINAL_SIMULATION_DISTANCE = new ConcurrentHashMap<ServerLevel, Integer>();
        TARGET_SIMULATION_DISTANCE = new ConcurrentHashMap<ServerLevel, Integer>();
        TRANSITION_REMAINING_SIM = new ConcurrentHashMap<ServerLevel, Integer>();
        VIEW_GET_CACHE = new ConcurrentHashMap();
        VIEW_SET_CACHE = new ConcurrentHashMap();
        SIM_GET_CACHE = new ConcurrentHashMap();
        SIM_SET_CACHE = new ConcurrentHashMap();
        METHOD_RESOLVED = new ConcurrentHashMap();
        TIMING_MARKER = ThreadLocal.withInitial(() -> System.nanoTime());
        enabled = CONFIG.isEnabled();
        lock = new Object();
        LEVEL_SPATIAL_GRIDS = new HashMap<ServerLevel, SpatialGrid>();
        GRID_LOCKS = new ConcurrentHashMap();
        STRIPED_LOCKS = new ReentrantLock[32];
        for (int i = 0; i < STRIPED_LOCKS.length; ++i) {
            PerformanceManager.STRIPED_LOCKS[i] = new ReentrantLock(true);
        }
        currentTpsThreshold = CONFIG.getTpsThresholdForAsync();
        try {
            NativeBridge.initRustAllocator();
            LOGGER.info("Rust allocator initialized successfully");
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.debug("Rust allocator initialization skipped - native library not available");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to initialize Rust allocator, using system default", (Throwable)e);
        }
    }

    private static class CallGraphFrame {
        String methodName;
        long startTimeNs;

        CallGraphFrame(String methodName) {
            this.methodName = methodName;
            this.startTimeNs = System.nanoTime();
        }
    }

    private static class CallGraphNode {
        String methodName;
        long totalExecutionTimeNs = 0L;
        long callCount = 0L;
        long maxExecutionTimeNs = 0L;
        long minExecutionTimeNs = Long.MAX_VALUE;
        Map<String, CallGraphNode> children = new ConcurrentHashMap<String, CallGraphNode>();

        CallGraphNode(String methodName) {
            this.methodName = methodName;
        }

        void updateWithDuration(long durationNs) {
            ++this.callCount;
            this.totalExecutionTimeNs += durationNs;
            if (durationNs > this.maxExecutionTimeNs) {
                this.maxExecutionTimeNs = durationNs;
            }
            if (durationNs < this.minExecutionTimeNs) {
                this.minExecutionTimeNs = durationNs;
            }
        }
    }

    private static class LazySingletonHolder {
        static final ThreadPoolManager THREAD_POOL_MANAGER = new ThreadPoolManager();
        static final EntityProcessor ENTITY_PROCESSOR = new EntityProcessor();

        private LazySingletonHolder() {
        }
    }

    private static final class ProfileData {
        long entityCollectionTime = 0L;
        long itemConsolidationTime = 0L;
        long optimizationProcessingTime = 0L;
        long optimizationApplicationTime = 0L;
        long spatialGridTime = 0L;
        long spatialLockWaitTime = 0L;
        long allocationTime = 0L;
        long lockContentionTime = 0L;
        long TOTAL_TICK_TIME = 0L;
        int entitiesProcessed = 0;
        int itemsProcessed = 0;
        int executorQueueSize = 0;

        private ProfileData() {
        }

        void reset() {
            this.entityCollectionTime = 0L;
            this.itemConsolidationTime = 0L;
            this.optimizationProcessingTime = 0L;
            this.optimizationApplicationTime = 0L;
            this.spatialGridTime = 0L;
            this.spatialLockWaitTime = 0L;
            this.allocationTime = 0L;
            this.lockContentionTime = 0L;
            this.TOTAL_TICK_TIME = 0L;
            this.entitiesProcessed = 0;
            this.itemsProcessed = 0;
            this.executorQueueSize = 0;
        }

        String toJson() {
            return String.format("{\"entityCollectionMs\":%.2f,\"itemConsolidationMs\":%.2f,\"optimizationProcessingMs\":%.2f,\"optimizationApplicationMs\":%.2f,\"spatialGridMs\":%.2f,\"totalTickMs\":%.2f,\"entitiesProcessed\":%d,\"itemsProcessed\":%d,\"executorQueueSize\":%d}", (double)this.entityCollectionTime / 1000000.0, (double)this.itemConsolidationTime / 1000000.0, (double)this.optimizationProcessingTime / 1000000.0, (double)this.optimizationApplicationTime / 1000000.0, (double)this.spatialGridTime / 1000000.0, (double)this.spatialLockWaitTime / 1000000.0, (double)this.lockContentionTime / 1000000.0, (double)this.allocationTime / 1000000.0, (double)this.TOTAL_TICK_TIME / 1000000.0, this.entitiesProcessed, this.itemsProcessed, this.executorQueueSize);
        }
    }

    private record EntityDataCollection(List<EntityData> entities, List<ItemEntityData> items, List<MobData> mobs, List<BlockEntityData> blockEntities, List<PlayerData> players) {
    }

    private record OptimizationResults(List<Long> toTick, List<Long> blockResult, ItemProcessResult itemResult, MobProcessResult mobResult) {
    }

    private record EntityCollectionContext(List<EntityData> entities, List<ItemEntityData> items, List<MobData> mobs, int maxEntities, double distanceCutoff, List<PlayerData> players, String[] excluded, double cutoffSq) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EntityCollectionContext that = (EntityCollectionContext)obj;
            return this.maxEntities == that.maxEntities && Double.compare(that.distanceCutoff, this.distanceCutoff) == 0 && Double.compare(that.cutoffSq, this.cutoffSq) == 0 && Objects.equals(this.entities, that.entities) && Objects.equals(this.items, that.items) && Objects.equals(this.mobs, that.mobs) && Objects.equals(this.players, that.players) && Arrays.equals(this.excluded, that.excluded);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.entities, this.items, this.mobs, this.maxEntities, this.distanceCutoff, this.players, this.cutoffSq);
            result = 31 * result + Arrays.hashCode(this.excluded);
            return result;
        }

        @Override
        public String toString() {
            return "EntityCollectionContext{entities=" + String.valueOf(this.entities) + ", items=" + String.valueOf(this.items) + ", mobs=" + String.valueOf(this.mobs) + ", maxEntities=" + this.maxEntities + ", distanceCutoff=" + this.distanceCutoff + ", players=" + String.valueOf(this.players) + ", excluded=" + Arrays.toString(this.excluded) + ", cutoffSq=" + this.cutoffSq + "}";
        }
    }

    public static final class ExecutorMetrics {
        long totalTasksSubmitted = 0L;
        long totalTasksCompleted = 0L;
        long totalTasksRejected = 0L;
        long currentQueueSize = 0L;
        double currentUtilization = 0.0;
        int currentThreadCount = 0;
        int peakThreadCount = 0;
        long lastScaleUpTime = 0L;
        long lastScaleDownTime = 0L;
        int scaleUpCount = 0;
        int scaleDownCount = 0;

        String toJson() {
            return String.format("{\"totalTasksSubmitted\":%d,\"totalTasksCompleted\":%d,\"totalTasksRejected\":%d,\"currentQueueSize\":%d,\"currentUtilization\":%.2f,\"currentThreadCount\":%d,\"peakThreadCount\":%d,\"scaleUpCount\":%d,\"scaleDownCount\":%d}", this.totalTasksSubmitted, this.totalTasksCompleted, this.totalTasksRejected, this.currentQueueSize, this.currentUtilization, this.currentThreadCount, this.peakThreadCount, this.scaleUpCount, this.scaleDownCount);
        }
    }

    private static class TestResult {
        String testName;
        long testId;
        String configChange;
        double baselineTps;
        double postChangeTps;
        long testDurationTicks;
        long startTime;
        long endTime;
        Map<String, Object> baselineMetrics;
        Map<String, Object> postChangeMetrics;
        String conclusion;

        TestResult(String testName, String configChange) {
            this.testName = testName;
            this.testId = testIdCounter.incrementAndGet();
            this.configChange = configChange;
            this.testDurationTicks = 0L;
            this.startTime = System.currentTimeMillis();
        }
    }
}

