/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface DatabaseAdapter {
    public void putChunk(String var1, byte[] var2) throws IOException;

    public CompletableFuture<Void> putChunkAsync(String var1, byte[] var2);

    public Optional<byte[]> getChunk(String var1) throws IOException;

    public CompletableFuture<Optional<byte[]>> getChunkAsync(String var1);

    public boolean deleteChunk(String var1) throws IOException;

    public CompletableFuture<Boolean> deleteChunkAsync(String var1);

    public boolean hasChunk(String var1) throws IOException;

    public long getChunkCount() throws IOException;

    public DatabaseStats getStats() throws IOException;

    public void performMaintenance() throws IOException;

    public void close() throws IOException;

    public String getDatabaseType();

    public boolean isHealthy();

    public void createBackup(String var1) throws IOException;

    public static class DatabaseStats {
        private final long totalChunks;
        private final long totalSizeBytes;
        private final long readLatencyMs;
        private final long writeLatencyMs;
        private final long lastMaintenanceTime;
        private final boolean isHealthy;
        private final long swapOperationsTotal;
        private final long swapOperationsFailed;
        private final long swapInLatencyMs;
        private final long swapOutLatencyMs;
        private final long memoryMappedFilesActive;

        public DatabaseStats(long totalChunks, long totalSizeBytes, long readLatencyMs, long writeLatencyMs, long lastMaintenanceTime, boolean isHealthy, long swapOperationsTotal, long swapOperationsFailed, long swapInLatencyMs, long swapOutLatencyMs, long memoryMappedFilesActive) {
            this.totalChunks = totalChunks;
            this.totalSizeBytes = totalSizeBytes;
            this.readLatencyMs = readLatencyMs;
            this.writeLatencyMs = writeLatencyMs;
            this.lastMaintenanceTime = lastMaintenanceTime;
            this.isHealthy = isHealthy;
            this.swapOperationsTotal = swapOperationsTotal;
            this.swapOperationsFailed = swapOperationsFailed;
            this.swapInLatencyMs = swapInLatencyMs;
            this.swapOutLatencyMs = swapOutLatencyMs;
            this.memoryMappedFilesActive = memoryMappedFilesActive;
        }

        public long getTotalChunks() {
            return this.totalChunks;
        }

        public long getTotalSizeBytes() {
            return this.totalSizeBytes;
        }

        public long getReadLatencyMs() {
            return this.readLatencyMs;
        }

        public long getWriteLatencyMs() {
            return this.writeLatencyMs;
        }

        public long getLastMaintenanceTime() {
            return this.lastMaintenanceTime;
        }

        public boolean isHealthy() {
            return this.isHealthy;
        }

        public long getSwapOperationsTotal() {
            return this.swapOperationsTotal;
        }

        public long getSwapOperationsFailed() {
            return this.swapOperationsFailed;
        }

        public long getSwapInLatencyMs() {
            return this.swapInLatencyMs;
        }

        public long getSwapOutLatencyMs() {
            return this.swapOutLatencyMs;
        }

        public long getMemoryMappedFilesActive() {
            return this.memoryMappedFilesActive;
        }

        public String toString() {
            return String.format("DatabaseStats{chunks=%d, size=%d bytes, readLatency=%d ms, writeLatency=%d ms, healthy=%s, swapOps=%d, swapFailed=%d, swapInLatency=%d ms, swapOutLatency=%d ms, mmapFiles=%d}", this.totalChunks, this.totalSizeBytes, this.readLatencyMs, this.writeLatencyMs, this.isHealthy, this.swapOperationsTotal, this.swapOperationsFailed, this.swapInLatencyMs, this.swapOutLatencyMs, this.memoryMappedFilesActive);
        }
    }
}

