/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.data.block;

import com.kneaf.core.data.core.DataEntity;
import com.kneaf.core.data.core.DataUtils;
import com.kneaf.core.data.core.Positionable;

public class BlockEntityData
implements DataEntity,
Positionable {
    private final long id;
    private final double distance;
    private final String blockType;
    private final int x;
    private final int y;
    private final int z;

    public BlockEntityData(long id, double distance, String blockType, int x, int y, int z) {
        this.id = id;
        this.distance = distance;
        this.blockType = blockType;
        this.x = x;
        this.y = y;
        this.z = z;
        this.validate();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return "block";
    }

    public double getDistance() {
        return this.distance;
    }

    public String getBlockType() {
        return this.blockType;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public boolean validate() {
        DataUtils.validateNonNegative(this.id, "id");
        DataUtils.validateDistance(this.distance, "distance");
        DataUtils.validateNotEmpty(this.blockType, "blockType");
        return true;
    }

    public String getBlockPosition() {
        return String.format("(%d, %d, %d)", this.x, this.y, this.z);
    }

    public boolean isWithinDistance(double maxDistance) {
        return this.distance <= maxDistance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockEntityData that = (BlockEntityData)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return String.format("BlockEntityData{id=%d, distance=%.2f, type='%s', pos=(%d,%d,%d)}", this.id, this.distance, this.blockType, this.x, this.y, this.z);
    }

    public static class Builder {
        private long id;
        private double distance = 0.0;
        private String blockType = "";
        private int x;
        private int y;
        private int z;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder distance(double distance) {
            this.distance = distance;
            return this;
        }

        public Builder blockType(String blockType) {
            this.blockType = blockType;
            return this;
        }

        public Builder position(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public BlockEntityData build() {
            return new BlockEntityData(this.id, this.distance, this.blockType, this.x, this.y, this.z);
        }
    }
}

