/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.bridge;

import com.google.gson.Gson;
import com.kneaf.core.KneafCore;
import com.kneaf.core.performance.NativeBridge;
import com.kneaf.core.performance.NativeFloatBufferAllocation;
import com.kneaf.core.performance.core.NativeBridgeProvider;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class NativeIntegrationManager
implements NativeBridgeProvider {
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean nativeAvailable = new AtomicBoolean(false);
    private final Map<Long, WorkerInfo> activeWorkers = new ConcurrentHashMap<Long, WorkerInfo>();
    private final AtomicLong nextWorkerId = new AtomicLong(1L);
    private final int defaultConcurrency;
    private final int maxWorkers;

    public NativeIntegrationManager() {
        this.defaultConcurrency = 4;
        this.maxWorkers = 8;
    }

    @Override
    public boolean initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            try {
                NativeBridge.initRustAllocator();
                this.nativeAvailable.set(true);
                KneafCore.LOGGER.info("Native allocator initialized successfully");
                KneafCore.LOGGER.info("Native integration manager initialized successfully");
                return true;
            }
            catch (Throwable t) {
                this.nativeAvailable.set(false);
                KneafCore.LOGGER.warn("Native allocator init failed; native integration unavailable, using Java fallback: { }", (Object)t.getMessage());
                return false;
            }
        }
        return this.nativeAvailable.get();
    }

    public long createWorker(int concurrency) throws RuntimeException {
        if (this.activeWorkers.size() >= this.maxWorkers) {
            throw new RuntimeException("Maximum worker limit reached: " + this.maxWorkers);
        }
        try {
            long workerHandle = NativeBridge.nativeCreateWorker(concurrency);
            if (workerHandle == 0L) {
                throw new RuntimeException("Failed to create native worker");
            }
            long workerId = this.nextWorkerId.getAndIncrement();
            WorkerInfo workerInfo = new WorkerInfo(workerId, workerHandle, concurrency);
            this.activeWorkers.put(workerId, workerInfo);
            KneafCore.LOGGER.debug("Created native worker { } with handle { } and concurrency { }", new Object[]{workerId, workerHandle, concurrency});
            return workerId;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create native worker", e);
        }
    }

    public long createWorker() throws RuntimeException {
        return this.createWorker(this.defaultConcurrency);
    }

    public void destroyWorker(long workerId) throws RuntimeException {
        WorkerInfo workerInfo = this.activeWorkers.remove(workerId);
        if (workerInfo == null) {
            KneafCore.LOGGER.warn("Attempted to destroy non-existent worker: { }", (Object)workerId);
            return;
        }
        try {
            NativeBridge.nativeDestroyWorker(workerInfo.handle);
            KneafCore.LOGGER.debug("Destroyed native worker { }", (Object)workerId);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to destroy native worker " + workerId, e);
        }
    }

    public void pushTask(long workerId, byte[] payload) throws RuntimeException {
        WorkerInfo workerInfo = this.getWorkerInfo(workerId);
        if (payload == null || payload.length == 0) {
            return;
        }
        try {
            NativeBridge.nativePushTask(workerInfo.handle, payload);
            workerInfo.incrementTaskCount();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to push task to worker " + workerId, e);
        }
    }

    public void pushBatch(long workerId, byte[][] payloads) throws RuntimeException {
        WorkerInfo workerInfo = this.getWorkerInfo(workerId);
        if (payloads == null || payloads.length == 0) {
            return;
        }
        try {
            NativeBridge.nativePushBatch(workerInfo.handle, payloads, payloads.length);
            workerInfo.incrementTaskCount(payloads.length);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to push batch to worker " + workerId, e);
        }
    }

    public byte[] pollResult(long workerId) throws RuntimeException {
        WorkerInfo workerInfo = this.getWorkerInfo(workerId);
        try {
            byte[] result = NativeBridge.nativePollResult(workerInfo.handle);
            if (result != null && result.length > 0) {
                workerInfo.incrementResultCount();
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to poll result from worker " + workerId, e);
        }
    }

    public WorkerStatistics getWorkerStatistics(long workerId) throws RuntimeException {
        WorkerInfo workerInfo = this.getWorkerInfo(workerId);
        try {
            long queueDepth = NativeBridge.nativeGetWorkerQueueDepth(workerInfo.handle);
            double avgProcessingMs = NativeBridge.nativeGetWorkerAvgProcessingMs(workerInfo.handle);
            long memoryUsage = NativeBridge.nativeGetWorkerMemoryUsage(workerInfo.handle);
            return new WorkerStatistics(workerId, queueDepth, avgProcessingMs, memoryUsage, workerInfo.getTaskCount(), workerInfo.getResultCount());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get statistics for worker " + workerId, e);
        }
    }

    public Map<Long, WorkerStatistics> getAllWorkerStatistics() {
        ConcurrentHashMap<Long, WorkerStatistics> Stats = new ConcurrentHashMap<Long, WorkerStatistics>();
        for (Long workerId : this.activeWorkers.keySet()) {
            try {
                Stats.put(workerId, this.getWorkerStatistics(workerId));
            }
            catch (RuntimeException e) {
                KneafCore.LOGGER.warn("Failed to get statistics for worker { }: { }", (Object)workerId, (Object)e.getMessage());
            }
        }
        return Stats;
    }

    public void shutdown() {
        if (!this.initialized.get()) {
            return;
        }
        KneafCore.LOGGER.info("Shutting down native integration manager");
        for (Long workerId : this.activeWorkers.keySet()) {
            try {
                this.destroyWorker(workerId);
            }
            catch (Exception e) {
                KneafCore.LOGGER.error("Failed to destroy worker { } during shutdown", (Object)workerId, (Object)e);
            }
        }
        this.activeWorkers.clear();
        this.initialized.set(false);
        this.nativeAvailable.set(false);
        KneafCore.LOGGER.info("Native integration manager shutdown complete");
    }

    @Override
    public boolean isNativeAvailable() {
        return this.nativeAvailable.get();
    }

    @Override
    public byte[] processEntitiesBinary(ByteBuffer input) {
        return new byte[0];
    }

    @Override
    public String processEntitiesJson(String input) {
        return "{ }";
    }

    @Override
    public byte[] processItemEntitiesBinary(ByteBuffer input) {
        return new byte[0];
    }

    @Override
    public String processItemEntitiesJson(String input) {
        return "{ }";
    }

    @Override
    public byte[] processMobAiBinary(ByteBuffer input) {
        return new byte[0];
    }

    @Override
    public String processMobAiJson(String input) {
        return "{ }";
    }

    @Override
    public byte[] processBlockEntitiesBinary(ByteBuffer input) {
        return new byte[0];
    }

    @Override
    public String processBlockEntitiesJson(String input) {
        return "{ }";
    }

    @Override
    public byte[] processVillagerAiBinary(ByteBuffer input) {
        return new byte[0];
    }

    @Override
    public String processVillagerAiJson(String jsonInput) {
        return "{ }";
    }

    @Override
    public String getMemoryStats() {
        ConcurrentHashMap<String, Constable> Stats = new ConcurrentHashMap<String, Constable>();
        Stats.put("activeWorkers", Integer.valueOf(this.activeWorkers.size()));
        Stats.put("nativeAvailable", Boolean.valueOf(this.nativeAvailable.get()));
        return new Gson().toJson(Stats);
    }

    @Override
    public String getCpuStats() {
        ConcurrentHashMap<String, Number> Stats = new ConcurrentHashMap<String, Number>();
        Stats.put("activeWorkers", this.activeWorkers.size());
        Stats.put("avgProcessingMs", this.getNativeWorkerAvgProcessingMs());
        return new Gson().toJson(Stats);
    }

    @Override
    public CompletableFuture<Integer> preGenerateNearbyChunksAsync(int centerX, int centerZ, int radius) {
        return CompletableFuture.completedFuture(0);
    }

    @Override
    public boolean isChunkGenerated(int chunkX, int chunkZ) {
        return false;
    }

    @Override
    public long getGeneratedChunkCount() {
        return 0L;
    }

    @Override
    public int getNativeWorkerQueueDepth() {
        if (this.activeWorkers.isEmpty()) {
            return 0;
        }
        long totalDepth = 0L;
        int count = 0;
        for (Long workerId : this.activeWorkers.keySet()) {
            try {
                WorkerStatistics Stats = this.getWorkerStatistics(workerId);
                totalDepth += Stats.getQueueDepth();
                ++count;
            }
            catch (Exception exception) {}
        }
        return count > 0 ? (int)(totalDepth / (long)count) : 0;
    }

    @Override
    public double getNativeWorkerAvgProcessingMs() {
        if (this.activeWorkers.isEmpty()) {
            return 0.0;
        }
        double totalTime = 0.0;
        int count = 0;
        for (Long workerId : this.activeWorkers.keySet()) {
            try {
                WorkerStatistics Stats = this.getWorkerStatistics(workerId);
                totalTime += Stats.getAvgProcessingMs();
                ++count;
            }
            catch (Exception exception) {}
        }
        return count > 0 ? totalTime / (double)count : 0.0;
    }

    public ByteBuffer generateFloatBuffer(int size, int flags) {
        ByteBuffer b = ByteBuffer.allocateDirect(size * 4).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer fb = b.asFloatBuffer();
        for (int i = 0; i < size; ++i) {
            fb.put(i, i);
        }
        return b;
    }

    public NativeFloatBufferAllocation generateFloatBufferWithShape(long rows, long cols) {
        int count = (int)(rows * cols);
        ByteBuffer buffer = ByteBuffer.allocateDirect(count * 4).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer fb = buffer.asFloatBuffer();
        for (int i = 0; i < count; ++i) {
            fb.put(i, i);
        }
        return new NativeFloatBufferAllocation(buffer, rows, cols);
    }

    public void freeFloatBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        try {
            com.kneaf.core.performance.bridge.NativeBridge.nativeFreeBuffer(buffer);
            return;
        }
        catch (Throwable throwable) {
            block13: {
                try {
                    if (!buffer.isDirect()) break block13;
                    try {
                        Object cleaner = null;
                        try {
                            Method cleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                            cleanerMethod.setAccessible(true);
                            cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
                        }
                        catch (NoSuchMethodException cleanerMethod) {
                            // empty catch block
                        }
                        if (cleaner != null) {
                            Method clean = cleaner.getClass().getMethod("clean", new Class[0]);
                            clean.invoke(cleaner, new Object[0]);
                            return;
                        }
                        try {
                            Field cleanerField = buffer.getClass().getDeclaredField("cleaner");
                            cleanerField.setAccessible(true);
                            Object c = cleanerField.get(buffer);
                            if (c != null) {
                                Method clean = c.getClass().getMethod("clean", new Class[0]);
                                clean.invoke(c, new Object[0]);
                            }
                        }
                        catch (IllegalAccessException | NoSuchFieldException inner) {
                            KneafCore.LOGGER.debug("Could not explicitly free direct ByteBuffer; relying on GC: { }", (Object)inner.getMessage());
                        }
                    }
                    catch (Throwable ex) {
                        KneafCore.LOGGER.debug("Failed explicit direct buffer cleanup: { }", (Object)ex.getMessage());
                    }
                }
                catch (Throwable t) {
                    KneafCore.LOGGER.debug("freeFloatBuffer fallback failed: { }", (Object)t.getMessage());
                }
            }
            return;
        }
    }

    public Map<String, Object> getMemoryStatsMap() {
        ConcurrentHashMap<String, Object> Stats = new ConcurrentHashMap<String, Object>();
        Stats.put("activeWorkers", this.activeWorkers.size());
        Stats.put("nativeAvailable", this.nativeAvailable.get());
        return Stats;
    }

    public Map<String, Object> getCpuStatsMap() {
        ConcurrentHashMap<String, Object> Stats = new ConcurrentHashMap<String, Object>();
        Stats.put("activeWorkers", this.activeWorkers.size());
        Stats.put("avgProcessingMs", this.getNativeWorkerAvgProcessingMs());
        return Stats;
    }

    private WorkerInfo getWorkerInfo(long workerId) throws RuntimeException {
        WorkerInfo workerInfo = this.activeWorkers.get(workerId);
        if (workerInfo == null) {
            throw new RuntimeException("Worker not found: " + workerId);
        }
        return workerInfo;
    }

    private static class WorkerInfo {
        private final long handle;
        private final AtomicLong taskCount = new AtomicLong(0L);
        private final AtomicLong resultCount = new AtomicLong(0L);

        public WorkerInfo(long id, long handle, int concurrency) {
            this.handle = handle;
        }

        public void incrementTaskCount() {
            this.taskCount.incrementAndGet();
        }

        public void incrementTaskCount(int count) {
            this.taskCount.addAndGet(count);
        }

        public void incrementResultCount() {
            this.resultCount.incrementAndGet();
        }

        public long getTaskCount() {
            return this.taskCount.get();
        }

        public long getResultCount() {
            return this.resultCount.get();
        }
    }

    public static class WorkerStatistics {
        private final long workerId;
        private final long queueDepth;
        private final double avgProcessingMs;
        private final long memoryUsage;
        private final long taskCount;
        private final long resultCount;

        public WorkerStatistics(long workerId, long queueDepth, double avgProcessingMs, long memoryUsage, long taskCount, long resultCount) {
            this.workerId = workerId;
            this.queueDepth = queueDepth;
            this.avgProcessingMs = avgProcessingMs;
            this.memoryUsage = memoryUsage;
            this.taskCount = taskCount;
            this.resultCount = resultCount;
        }

        public long getWorkerId() {
            return this.workerId;
        }

        public long getQueueDepth() {
            return this.queueDepth;
        }

        public double getAvgProcessingMs() {
            return this.avgProcessingMs;
        }

        public long getMemoryUsage() {
            return this.memoryUsage;
        }

        public long getTaskCount() {
            return this.taskCount;
        }

        public long getResultCount() {
            return this.resultCount;
        }

        public String toString() {
            return String.format("WorkerStatistics{id=%d, queueDepth=%d, avgProcessingMs=%.2f, memoryUsage=%d, taskCount=%d, resultCount=%d}", this.workerId, this.queueDepth, this.avgProcessingMs, this.memoryUsage, this.taskCount, this.resultCount);
        }
    }
}

