/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.monitoring;

import com.kneaf.core.data.block.BlockEntityData;
import com.kneaf.core.data.entity.EntityData;
import com.kneaf.core.data.entity.MobData;
import com.kneaf.core.data.entity.PlayerData;
import com.kneaf.core.data.item.ItemEntityData;
import com.kneaf.core.performance.RustPerformance;
import com.kneaf.core.performance.bridge.NativeBridge;
import com.kneaf.core.performance.core.ItemProcessResult;
import com.kneaf.core.performance.core.MobProcessResult;
import com.kneaf.core.performance.core.PerformanceConstants;
import com.kneaf.core.performance.core.PerformanceProcessor;
import com.kneaf.core.performance.monitoring.PerformanceConfig;
import com.kneaf.core.performance.monitoring.PerformanceMetricsLogger;
import com.kneaf.core.performance.spatial.SpatialGrid;
import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class PerformanceManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int TICK_COUNTER = 0;
    private static long lastTickTime = 0L;
    private static volatile long lastTickDurationNanos = 0L;
    private static final PerformanceConfig CONFIG = PerformanceConfig.load();
    private static final boolean PROFILING_ENABLED = CONFIG.isProfilingEnabled();
    private static final long SLOW_TICK_THRESHOLD_MS = CONFIG.getSlowTickThresholdMs();
    private static final int PROFILING_SAMPLE_RATE = CONFIG.getProfilingSampleRate();
    private static ThreadPoolExecutor serverTaskExecutor = null;
    private static final Object EXECUTOR_LOCK = new Object();
    private static final ExecutorMetrics EXECUTOR_METRICS = new ExecutorMetrics();
    private static final int TPS_WINDOW_SIZE = 20;
    private static final double[] TPS_WINDOW = new double[20];
    private static int tpsWindowIndex = 0;
    private static double currentTpsThreshold;
    private static final double MIN_TPS_THRESHOLD = 15.0;
    private static final double MAX_TPS_THRESHOLD = 19.5;
    private static final int QUEUE_SIZE_HIGH_THRESHOLD = 10;
    private static final int QUEUE_SIZE_LOW_THRESHOLD = 3;
    private static final double THRESHOLD_ADJUSTMENT_RATE = 0.1;
    private static final ThreadLocal<ProfileData> PROFILE_DATA;
    private static volatile boolean enabled;
    private static final Map<ServerLevel, SpatialGrid> LEVEL_SPATIAL_GRIDS;
    private static final Object SPATIAL_GRID_LOCK;
    private static final int DISTANCE_CALCULATION_INTERVAL = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadPoolExecutor getExecutor() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor == null || serverTaskExecutor.isShutdown()) {
                PerformanceManager.createAdvancedThreadPool();
            }
            return serverTaskExecutor;
        }
    }

    private static void createAdvancedThreadPool() {
        int availableProcessors;
        AtomicInteger threadIndex = new AtomicInteger(0);
        ThreadFactory factory = r -> {
            Thread t = new Thread(r, "kneaf-perf-worker-" + threadIndex.getAndIncrement());
            t.setDaemon(true);
            return t;
        };
        int coreThreads = CONFIG.getMinThreadpoolSize();
        int maxThreads = CONFIG.getMaxThreadpoolSize();
        if (CONFIG.isCpuAwareThreadSizing()) {
            availableProcessors = Runtime.getRuntime().availableProcessors();
            double cpuLoad = PerformanceManager.getSystemCpuLoad();
            maxThreads = cpuLoad < CONFIG.getCpuLoadThreshold() ? Math.min(maxThreads, availableProcessors) : Math.clamp((long)(availableProcessors / 2), 1, maxThreads);
            coreThreads = Math.min(coreThreads, maxThreads);
        }
        if (CONFIG.isAdaptiveThreadPool()) {
            availableProcessors = Runtime.getRuntime().availableProcessors();
            maxThreads = PerformanceManager.clamp(availableProcessors - 1, 1, maxThreads);
            coreThreads = Math.min(coreThreads, maxThreads);
        }
        LinkedBlockingQueue<Runnable> workQueue = CONFIG.isWorkStealingEnabled() ? new LinkedBlockingQueue(CONFIG.getWorkStealingQueueSize()) : new LinkedBlockingQueue<Runnable>();
        serverTaskExecutor = new ThreadPoolExecutor(coreThreads, maxThreads, (long)CONFIG.getThreadPoolKeepAliveSeconds(), TimeUnit.SECONDS, workQueue, factory);
        serverTaskExecutor.allowCoreThreadTimeOut(true);
        PerformanceManager.EXECUTOR_METRICS.currentThreadCount = coreThreads;
        PerformanceManager.EXECUTOR_METRICS.peakThreadCount = coreThreads;
        LOGGER.info("Created advanced ThreadPoolExecutor: core={ }, max={ }, workStealing={ }, cpuAware={ }", new Object[]{coreThreads, maxThreads, CONFIG.isWorkStealingEnabled(), CONFIG.isCpuAwareThreadSizing()});
        currentTpsThreshold = CONFIG.getTpsThresholdForAsync();
    }

    private static double getSystemCpuLoad() {
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            double systemLoad = osBean.getSystemLoadAverage();
            if (systemLoad < 0.0) {
                int availableProcessors = osBean.getAvailableProcessors();
                return Math.min(1.0, systemLoad / (double)availableProcessors);
            }
            int availableProcessors = osBean.getAvailableProcessors();
            return Math.min(1.0, systemLoad / (double)availableProcessors);
        }
        catch (Exception e) {
            LOGGER.debug("Could not get CPU load, using default", (Throwable)e);
            return 0.0;
        }
    }

    private static int clamp(int v, int min, int max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    private static double clamp(double v, double min, double max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor != null) {
                try {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Shutting down ThreadPoolExecutor. Metrics: { }", (Object)EXECUTOR_METRICS.toJson());
                    }
                    serverTaskExecutor.shutdown();
                    if (!serverTaskExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        LOGGER.warn("ThreadPoolExecutor did not terminate gracefully, forcing shutdown");
                        serverTaskExecutor.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    serverTaskExecutor.shutdownNow();
                }
                finally {
                    serverTaskExecutor = null;
                }
            }
        }
        object = SPATIAL_GRID_LOCK;
        synchronized (object) {
            LEVEL_SPATIAL_GRIDS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExecutorMetrics() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor == null) {
                return "{\"status\":\"not_initialized\"}";
            }
            return EXECUTOR_METRICS.toJson();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExecutorStatus() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor == null) {
                return "Executor not initialized";
            }
            return String.format("ThreadPoolExecutor[core=%d, max=%d, current=%d, active=%d, queue=%d, completed=%d]", serverTaskExecutor.getCorePoolSize(), serverTaskExecutor.getMaximumPoolSize(), serverTaskExecutor.getPoolSize(), serverTaskExecutor.getActiveCount(), serverTaskExecutor.getQueue().size(), serverTaskExecutor.getCompletedTaskCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExecutorHealthy() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            int maxQueueSize;
            if (serverTaskExecutor == null || serverTaskExecutor.isShutdown() || serverTaskExecutor.isTerminated()) {
                return false;
            }
            int queueSize = serverTaskExecutor.getQueue().size();
            int n = maxQueueSize = CONFIG.isWorkStealingEnabled() ? CONFIG.getWorkStealingQueueSize() : 1000;
            if ((double)queueSize > (double)maxQueueSize * 0.9) {
                LOGGER.warn("Executor queue is nearly full: { }/{ }", (Object)queueSize, (Object)maxQueueSize);
                return false;
            }
            double utilization = PerformanceManager.getExecutorUtilization();
            if (serverTaskExecutor.getPoolSize() >= serverTaskExecutor.getMaximumPoolSize() && utilization > 0.95) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Executor at max capacity with high utilization: { } threads, { } utilization", (Object)serverTaskExecutor.getPoolSize(), (Object)String.format("%.2f", utilization));
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getExecutorQueueSize() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor == null) {
                return 0;
            }
            return serverTaskExecutor.getQueue().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double getExecutorUtilization() {
        Object object = EXECUTOR_LOCK;
        synchronized (object) {
            if (serverTaskExecutor == null) {
                return 0.0;
            }
            int activeThreads = serverTaskExecutor.getActiveCount();
            int poolSize = Math.max(1, serverTaskExecutor.getPoolSize());
            return (double)activeThreads / (double)poolSize;
        }
    }

    private static void adjustDynamicThreshold() {
        int queueSize = PerformanceManager.getExecutorQueueSize();
        int currentTick = TICK_COUNTER % 20;
        if (queueSize > 10) {
            currentTpsThreshold = Math.max(15.0, currentTpsThreshold - 0.1);
        } else if (queueSize < 3 && currentTick % 5 == 0) {
            currentTpsThreshold = Math.min(19.5, currentTpsThreshold + 0.05);
        }
        currentTpsThreshold = PerformanceManager.clamp(currentTpsThreshold, 15.0, 19.5);
    }

    private PerformanceManager() {
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean val) {
        enabled = val;
    }

    public static void onServerTick(MinecraftServer server) {
        if (!enabled) {
            return;
        }
        long tickStartTime = PROFILING_ENABLED ? System.nanoTime() : 0L;
        ProfileData profile = PROFILING_ENABLED ? PROFILE_DATA.get() : null;
        PerformanceManager.updateTPS();
        if (++TICK_COUNTER % 2 == 0) {
            PerformanceManager.adjustDynamicThreshold();
        }
        if (!PerformanceManager.shouldPerformScan()) {
            if (PROFILING_ENABLED) {
                PROFILE_DATA.remove();
            }
            return;
        }
        boolean shouldProfile = PROFILING_ENABLED && TICK_COUNTER % (PROFILING_SAMPLE_RATE * 2) == 0;
        PerformanceManager.prepareProfiling(profile, shouldProfile, tickStartTime);
        EntityDataCollection data = PerformanceManager.collectAndConsolidate(server, shouldProfile, profile);
        double avgTps = PerformanceManager.getRollingAvgTPS();
        if (avgTps >= currentTpsThreshold) {
            PerformanceManager.submitAsyncOptimizations(server, data, shouldProfile);
        } else {
            PerformanceManager.runSynchronousOptimizations(server, data, shouldProfile);
        }
        if (shouldProfile && profile != null && profile.isSlowTick()) {
            PerformanceManager.logSlowTick(server, profile);
        }
        if (PROFILING_ENABLED) {
            PROFILE_DATA.remove();
        }
    }

    private static boolean shouldPerformScan() {
        return TICK_COUNTER % (CONFIG.getScanIntervalTicks() * 3) == 0;
    }

    private static void prepareProfiling(ProfileData profile, boolean shouldProfile, long tickStartTime) {
        if (shouldProfile && profile != null) {
            profile.executorQueueSize = PerformanceManager.getExecutorQueueSize();
            profile.TOTAL_TICK_TIME = System.nanoTime() - tickStartTime;
        }
    }

    private static EntityDataCollection collectAndConsolidate(MinecraftServer server, boolean shouldProfile, ProfileData profile) {
        long entityCollectionStart = shouldProfile ? System.nanoTime() : 0L;
        EntityDataCollection data = PerformanceManager.collectEntityData(server);
        if (shouldProfile && profile != null) {
            profile.entityCollectionTime = System.nanoTime() - entityCollectionStart;
            profile.entitiesProcessed = data.entities().size();
            profile.itemsProcessed = data.items().size();
        }
        long consolidationStart = shouldProfile ? System.nanoTime() : 0L;
        List<ItemEntityData> consolidated = PerformanceManager.consolidateItemEntities(data.items());
        if (shouldProfile && profile != null) {
            profile.itemConsolidationTime = System.nanoTime() - consolidationStart;
        }
        return new EntityDataCollection(data.entities(), consolidated, data.mobs(), data.blockEntities(), data.players());
    }

    private static void submitAsyncOptimizations(MinecraftServer server, EntityDataCollection data, boolean shouldProfile) {
        try {
            PerformanceManager.getExecutor().submit(() -> PerformanceManager.performAsyncOptimization(server, data, shouldProfile));
        }
        catch (Exception e) {
            LOGGER.debug("Executor rejected task; running synchronously", (Throwable)e);
            PerformanceManager.runSynchronousOptimizations(server, data, shouldProfile);
        }
    }

    private static void performAsyncOptimization(MinecraftServer server, EntityDataCollection data, boolean shouldProfile) {
        try {
            ProfileData profile;
            long processingStart = shouldProfile ? System.nanoTime() : 0L;
            OptimizationResults results = PerformanceManager.processOptimizations(data);
            if (shouldProfile && (profile = PROFILE_DATA.get()) != null) {
                profile.optimizationProcessingTime = System.nanoTime() - processingStart;
            }
            server.execute(() -> PerformanceManager.applyOptimizationResults(server, results, shouldProfile));
        }
        catch (Exception e) {
            LOGGER.warn("Error during async processing of optimizations", (Throwable)e);
        }
    }

    private static void applyOptimizationResults(MinecraftServer server, OptimizationResults results, boolean shouldProfile) {
        try {
            ProfileData profile;
            long applicationStart = shouldProfile ? System.nanoTime() : 0L;
            PerformanceManager.applyOptimizations(server, results);
            if (shouldProfile && (profile = PROFILE_DATA.get()) != null) {
                profile.optimizationApplicationTime = System.nanoTime() - applicationStart;
            }
            if (TICK_COUNTER % CONFIG.getLogIntervalTicks() == 0) {
                PerformanceManager.logOptimizations(server, results);
            }
            PerformanceManager.removeItems(server, results.itemResult());
        }
        catch (Exception e) {
            LOGGER.warn("Error applying optimizations on server thread", (Throwable)e);
        }
    }

    private static void runSynchronousOptimizations(MinecraftServer server, EntityDataCollection data, boolean shouldProfile) {
        try {
            ProfileData profile;
            ProfileData profile2;
            long processingStart = shouldProfile ? System.nanoTime() : 0L;
            OptimizationResults results = PerformanceManager.processOptimizations(data);
            if (shouldProfile && (profile2 = PROFILE_DATA.get()) != null) {
                profile2.optimizationProcessingTime = System.nanoTime() - processingStart;
            }
            long applicationStart = shouldProfile ? System.nanoTime() : 0L;
            PerformanceManager.applyOptimizations(server, results);
            if (shouldProfile && (profile = PROFILE_DATA.get()) != null) {
                profile.optimizationApplicationTime = System.nanoTime() - applicationStart;
            }
            if (TICK_COUNTER % CONFIG.getLogIntervalTicks() == 0) {
                PerformanceManager.logOptimizations(server, results);
            }
            PerformanceManager.removeItems(server, results.itemResult());
        }
        catch (Exception ex) {
            LOGGER.warn("Error processing optimizations synchronously", (Throwable)ex);
        }
    }

    private static void updateTPS() {
        long currentTime = System.nanoTime();
        if (lastTickTime != 0L) {
            long delta;
            lastTickDurationNanos = delta = currentTime - lastTickTime;
            double tps = 1.0E9 / (double)delta;
            double capped = Math.min(tps, 20.0);
            RustPerformance.setCurrentTPS(capped);
            PerformanceManager.TPS_WINDOW[PerformanceManager.tpsWindowIndex % 20] = capped;
            tpsWindowIndex = (tpsWindowIndex + 1) % 20;
        }
        if (lastTickTime == 0L) {
            lastTickDurationNanos = 0L;
        }
        lastTickTime = currentTime;
    }

    public static long getLastTickDurationMs() {
        return lastTickDurationNanos / 1000000L;
    }

    public static double getAverageTPS() {
        return PerformanceManager.getRollingAvgTPS();
    }

    private static double getRollingAvgTPS() {
        double sum = 0.0;
        int count = 0;
        for (double v : TPS_WINDOW) {
            if (!(v > 0.0)) continue;
            sum += v;
            ++count;
        }
        return count == 0 ? 20.0 : sum / (double)count;
    }

    private static EntityDataCollection collectEntityData(MinecraftServer server) {
        int estimatedEntities = Math.min(CONFIG.getMaxEntitiesToCollect(), 5000);
        ArrayList<EntityData> entities = new ArrayList<EntityData>(estimatedEntities);
        ArrayList<ItemEntityData> items = new ArrayList<ItemEntityData>(estimatedEntities / 4);
        ArrayList<MobData> mobs = new ArrayList<MobData>(estimatedEntities / 8);
        ArrayList<BlockEntityData> blockEntities = new ArrayList<BlockEntityData>(128);
        ArrayList<PlayerData> players = new ArrayList<PlayerData>(32);
        int maxEntities = CONFIG.getMaxEntitiesToCollect();
        double distanceCutoff = CONFIG.getEntityDistanceCutoff();
        String[] excludedTypes = CONFIG.getExcludedEntityTypes();
        double cutoffSq = distanceCutoff * distanceCutoff;
        for (ServerLevel level : server.getAllLevels()) {
            List serverPlayers = level.players();
            ArrayList<PlayerData> levelPlayers = new ArrayList<PlayerData>(serverPlayers.size());
            for (ServerPlayer p : serverPlayers) {
                levelPlayers.add(new PlayerData(p.getId(), p.getX(), p.getY(), p.getZ()));
            }
            PerformanceManager.collectEntitiesFromLevel(level, new EntityCollectionContext(entities, items, mobs, maxEntities, distanceCutoff, levelPlayers, excludedTypes, cutoffSq));
            players.addAll(levelPlayers);
            if (entities.size() < maxEntities) continue;
            break;
        }
        return new EntityDataCollection(entities, items, mobs, blockEntities, players);
    }

    private static void collectEntitiesFromLevel(ServerLevel level, EntityCollectionContext context) {
        ProfileData profile;
        long spatialStart = PROFILING_ENABLED && TICK_COUNTER % PROFILING_SAMPLE_RATE == 0 ? System.nanoTime() : 0L;
        SpatialGrid spatialGrid = PerformanceManager.getOrCreateSpatialGrid(level, context.players());
        if (PROFILING_ENABLED && TICK_COUNTER % PROFILING_SAMPLE_RATE == 0 && (profile = PROFILE_DATA.get()) != null) {
            profile.spatialGridTime += System.nanoTime() - spatialStart;
        }
        AABB searchBounds = PerformanceManager.createSearchBounds(context.players(), context.distanceCutoff());
        if (TICK_COUNTER % PerformanceConstants.getAdaptiveDistanceCalculationInterval(PerformanceManager.getAverageTPS()) == 0) {
            List entityList = level.getEntities(null, searchBounds);
            int entityCount = entityList.size();
            for (int i = 0; i < entityCount && context.entities().size() < context.maxEntities(); ++i) {
                Entity entity = (Entity)entityList.get(i);
                double minSq = PerformanceManager.computeMinSquaredDistanceToPlayersOptimized(entity, spatialGrid, context.distanceCutoff());
                if (!(minSq <= context.cutoffSq())) continue;
                PerformanceManager.processEntityWithinCutoff(entity, minSq, context.excluded(), context.entities(), context.items(), context.mobs());
            }
        } else {
            PerformanceManager.performReducedDistanceCalculation(level, searchBounds, context, spatialGrid);
        }
    }

    private static double computeMinSquaredDistanceToPlayersOptimized(Entity entity, SpatialGrid spatialGrid, double maxSearchRadius) {
        return spatialGrid.findMinSquaredDistance(entity.getX(), entity.getY(), entity.getZ(), maxSearchRadius);
    }

    private static AABB createSearchBounds(List<PlayerData> players, double distanceCutoff) {
        if (players.isEmpty()) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (PlayerData player : players) {
            minX = Math.min(minX, player.getX());
            minY = Math.min(minY, player.getY());
            minZ = Math.min(minZ, player.getZ());
            maxX = Math.max(maxX, player.getX());
            maxY = Math.max(maxY, player.getY());
            maxZ = Math.max(maxZ, player.getZ());
        }
        return new AABB(minX -= distanceCutoff, minY -= distanceCutoff, minZ -= distanceCutoff, maxX += distanceCutoff, maxY += distanceCutoff, maxZ += distanceCutoff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SpatialGrid getOrCreateSpatialGrid(ServerLevel level, List<PlayerData> players) {
        Object object = SPATIAL_GRID_LOCK;
        synchronized (object) {
            SpatialGrid grid = LEVEL_SPATIAL_GRIDS.computeIfAbsent(level, k -> {
                double cellSize = Math.max(CONFIG.getEntityDistanceCutoff() / 4.0, 16.0);
                return new SpatialGrid(cellSize);
            });
            grid.clear();
            for (PlayerData player : players) {
                grid.updatePlayer(player);
            }
            return grid;
        }
    }

    private static void processEntityWithinCutoff(Entity entity, double minSq, String[] excluded, List<EntityData> entities, List<ItemEntityData> items, List<MobData> mobs) {
        String typeStr = entity.getType().toString();
        if (PerformanceManager.isExcludedType(typeStr, excluded)) {
            return;
        }
        double distance = Math.sqrt(minSq);
        boolean isBlockEntity = false;
        entities.add(new EntityData(entity.getId(), entity.getX(), entity.getY(), entity.getZ(), distance, isBlockEntity, typeStr));
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            PerformanceManager.collectItemEntity(entity, itemEntity, items);
        } else if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            PerformanceManager.collectMobEntity(entity, mob, mobs, distance, typeStr);
        }
    }

    private static boolean isExcludedType(String typeStr, String[] excluded) {
        if (excluded == null || excluded.length == 0) {
            return false;
        }
        for (String ex : excluded) {
            if (ex == null || ex.isEmpty() || !typeStr.contains(ex)) continue;
            return true;
        }
        return false;
    }

    private static void collectItemEntity(Entity entity, ItemEntity itemEntity, List<ItemEntityData> items) {
        ChunkPos chunkPos = entity.chunkPosition();
        ItemStack itemStack = itemEntity.getItem();
        String itemType = itemStack.getItem().getDescriptionId();
        int count = itemStack.getCount();
        int ageSeconds = itemEntity.getAge() / 20;
        items.add(new ItemEntityData(entity.getId(), chunkPos.x, chunkPos.z, itemType, count, ageSeconds));
    }

    private static void performReducedDistanceCalculation(ServerLevel level, AABB searchBounds, EntityCollectionContext context, SpatialGrid spatialGrid) {
        double approximateCutoff = context.distanceCutoff() * 1.2;
        double approximateCutoffSq = approximateCutoff * approximateCutoff;
        ArrayList<Entity> candidateEntities = new ArrayList<Entity>();
        for (Entity entity : level.getEntities(null, searchBounds)) {
            if (context.entities().size() >= context.maxEntities()) break;
            double approxMinSq = spatialGrid.findMinSquaredDistance(entity.getX(), entity.getY(), entity.getZ(), approximateCutoff);
            if (!(approxMinSq <= approximateCutoffSq)) continue;
            candidateEntities.add(entity);
        }
        for (Entity entity : candidateEntities) {
            double minSq;
            if (context.entities().size() >= context.maxEntities()) break;
            String typeStr = entity.getType().toString();
            if (PerformanceManager.isExcludedType(typeStr, context.excluded()) || !((minSq = PerformanceManager.computeMinSquaredDistanceToPlayersOptimized(entity, spatialGrid, context.distanceCutoff())) <= context.cutoffSq())) continue;
            PerformanceManager.processEntityWithinCutoff(entity, minSq, context.excluded(), context.entities(), context.items(), context.mobs());
        }
    }

    private static void collectMobEntity(Entity entity, Mob mob, List<MobData> mobs, double distance, String typeStr) {
        boolean isPassive = !(mob instanceof Monster);
        mobs.add(new MobData(entity.getId(), distance, isPassive, typeStr));
    }

    private static long packItemKey(int chunkX, int chunkZ, String itemType) {
        long packedChunkX = (long)chunkX & 0x1FFFFFL;
        long packedChunkZ = (long)chunkZ & 0x1FFFFFL;
        long itemHash = itemType == null ? 0L : (long)itemType.hashCode() & 0x3FFFFFL;
        return packedChunkX << 43 | packedChunkZ << 22 | itemHash;
    }

    private static List<ItemEntityData> consolidateItemEntities(List<ItemEntityData> items) {
        if (items == null || items.isEmpty()) {
            return items;
        }
        int estimatedSize = Math.min(items.size(), items.size() / 2 + 1);
        HashMap<Long, ItemEntityData> agg = HashMap.newHashMap(estimatedSize);
        for (ItemEntityData it : items) {
            long key = PerformanceManager.packItemKey(it.getChunkX(), it.getChunkZ(), it.getItemType());
            ItemEntityData cur = (ItemEntityData)agg.get(key);
            if (cur == null) {
                agg.put(key, it);
                continue;
            }
            int newCount = cur.getCount() + it.getCount();
            int newAge = Math.min(cur.getAgeSeconds(), it.getAgeSeconds());
            long preservedId = cur.getId();
            agg.put(key, new ItemEntityData(preservedId, it.getChunkX(), it.getChunkZ(), it.getItemType(), newCount, newAge));
        }
        return new ArrayList<ItemEntityData>(agg.values());
    }

    private static OptimizationResults processOptimizations(EntityDataCollection data) {
        List<Long> toTick = RustPerformance.getEntitiesToTick(data.entities(), data.players());
        List<Long> blockResult = RustPerformance.getBlockEntitiesToTick(data.blockEntities());
        ItemProcessResult itemResult = RustPerformance.processItemEntities(data.items());
        MobProcessResult mobResult = RustPerformance.processMobAI(data.mobs());
        return new OptimizationResults(toTick, blockResult, itemResult, mobResult);
    }

    private static void applyOptimizations(MinecraftServer server, OptimizationResults results) {
        PerformanceManager.applyItemUpdates(server, results.itemResult());
        PerformanceManager.applyMobOptimizations(server, results.mobResult());
    }

    private static void applyItemUpdates(MinecraftServer server, ItemProcessResult itemResult) {
        if (itemResult == null || itemResult.getItemUpdates() == null) {
            return;
        }
        HashMap<Integer, PerformanceProcessor.ItemUpdate> updateMap = new HashMap<Integer, PerformanceProcessor.ItemUpdate>();
        for (PerformanceProcessor.ItemUpdate update : itemResult.getItemUpdates()) {
            updateMap.put((int)update.getId(), update);
        }
        for (ServerLevel level : server.getAllLevels()) {
            for (Map.Entry entry : updateMap.entrySet()) {
                Entity entity = level.getEntity(((Integer)entry.getKey()).intValue());
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                PerformanceProcessor.ItemUpdate update = (PerformanceProcessor.ItemUpdate)entry.getValue();
                itemEntity.getItem().setCount(update.getNewCount());
            }
        }
    }

    private static void applyMobOptimizations(MinecraftServer server, MobProcessResult mobResult) {
        if (mobResult == null) {
            return;
        }
        HashSet<Integer> disableAiIds = new HashSet<Integer>();
        for (Long id : mobResult.getDisableList()) {
            disableAiIds.add(id.intValue());
        }
        HashSet<Integer> simplifyAiIds = new HashSet<Integer>();
        for (Long id : mobResult.getSimplifyList()) {
            simplifyAiIds.add(id.intValue());
        }
        for (ServerLevel level : server.getAllLevels()) {
            Entity entity;
            for (Integer id : disableAiIds) {
                entity = level.getEntity(id.intValue());
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                mob.setNoAi(true);
            }
            for (Integer id : simplifyAiIds) {
                entity = level.getEntity(id.intValue());
                if (!(entity instanceof Mob)) continue;
            }
        }
    }

    private static void logOptimizations(MinecraftServer server, OptimizationResults results) {
        if (TICK_COUNTER % 100 == 0 && PerformanceManager.hasMeaningfulOptimizations(results)) {
            PerformanceManager.logReadableOptimizations(server, results);
        }
        if (TICK_COUNTER % 1000 == 0) {
            PerformanceManager.logSpatialGridStats(server);
        }
        if (TICK_COUNTER % CONFIG.getLogIntervalTicks() == 0 && PerformanceManager.hasMeaningfulOptimizations(results)) {
            String summary = PerformanceManager.buildOptimizationSummary(results);
            PerformanceMetricsLogger.logOptimizations(summary);
            PerformanceManager.broadcastPerformanceLine(server, "OPTIMIZATIONS " + summary);
        }
    }

    private static void logReadableOptimizations(MinecraftServer server, OptimizationResults results) {
        if (results == null) {
            return;
        }
        if (results.itemResult() != null) {
            long merged = results.itemResult().getMergedCount();
            long despawned = results.itemResult().getDespawnedCount();
            if (merged > 0L || despawned > 0L) {
                PerformanceManager.broadcastPerformanceLine(server, String.format("Item optimization: %d merged, %d despawned", merged, despawned));
            }
            if (!results.itemResult().getItemsToRemove().isEmpty()) {
                PerformanceManager.broadcastPerformanceLine(server, String.format("Items removed: %d", results.itemResult().getItemsToRemove().size()));
            }
        }
        if (results.mobResult() != null) {
            int disabled = results.mobResult().getDisableList().size();
            int simplified = results.mobResult().getSimplifyList().size();
            if (disabled > 0 || simplified > 0) {
                PerformanceManager.broadcastPerformanceLine(server, String.format("Mob AI optimization: %d disabled, %d simplified", disabled, simplified));
            }
        }
        if (results.blockResult() != null && !results.blockResult().isEmpty()) {
            PerformanceManager.broadcastPerformanceLine(server, String.format("Block entities to tick (reduced): %d", results.blockResult().size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logSpatialGridStats(MinecraftServer server) {
        Object object = SPATIAL_GRID_LOCK;
        synchronized (object) {
            int totalLevels = LEVEL_SPATIAL_GRIDS.size();
            int totalPlayers = 0;
            int totalCells = 0;
            for (SpatialGrid grid : LEVEL_SPATIAL_GRIDS.values()) {
                SpatialGrid.GridStats Stats = grid.getStats();
                totalPlayers += Stats.totalPlayers();
                totalCells += Stats.totalCells();
            }
            String summary = String.format("SpatialGrid Stats: %d levels, %d players, %d cells, avg %s players/cell", totalLevels, totalPlayers, totalCells, totalCells > 0 ? String.format("%.2f", (double)totalPlayers / (double)totalCells) : "0.00");
            PerformanceMetricsLogger.logLine(summary);
            if (CONFIG.isBroadcastToClient()) {
                PerformanceManager.broadcastPerformanceLine(server, summary);
            }
        }
    }

    private static void logSlowTick(MinecraftServer server, ProfileData profile) {
        if (profile == null) {
            return;
        }
        String jsonProfile = profile.toJson();
        String message = String.format("SLOW_TICK: tick=%d avgTps=%.2f threshold=%.2f %s", TICK_COUNTER, PerformanceManager.getRollingAvgTPS(), currentTpsThreshold, jsonProfile);
        PerformanceMetricsLogger.logLine("SLOW_TICK " + message);
        if (CONFIG.isBroadcastToClient()) {
            try {
                for (ServerLevel level : server.getAllLevels()) {
                    for (ServerPlayer player : level.players()) {
                        player.displayClientMessage((Component)Component.literal((String)message), false);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to broadcast performance message to players", (Throwable)e);
            }
        }
    }

    public static void broadcastPerformanceLine(MinecraftServer server, String line) {
        PerformanceMetricsLogger.logLine(line);
        if (!CONFIG.isBroadcastToClient()) {
            return;
        }
        try {
            for (ServerLevel level : server.getAllLevels()) {
                for (ServerPlayer player : level.players()) {
                    player.displayClientMessage((Component)Component.literal((String)line), false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to broadcast performance line to players", (Throwable)e);
        }
    }

    private static String buildOptimizationSummary(OptimizationResults results) {
        double avg = PerformanceManager.getRollingAvgTPS();
        long itemsMerged = results.itemResult() == null ? 0L : results.itemResult().getMergedCount();
        long itemsDespawned = results.itemResult() == null ? 0L : results.itemResult().getDespawnedCount();
        int mobsDisabled = results.mobResult() == null ? 0 : results.mobResult().getDisableList().size();
        int mobsSimplified = results.mobResult() == null ? 0 : results.mobResult().getSimplifyList().size();
        int itemsRemoved = results.itemResult() == null ? 0 : results.itemResult().getItemsToRemove().size();
        int blockEntities = results.blockResult() == null ? 0 : results.blockResult().size();
        int queueSize = PerformanceManager.getExecutorQueueSize();
        return String.format("avgTps=%.2f currentThreshold=%.2f queueSize=%d itemsMerged=%d itemsDespawned=%d mobsDisabled=%d mobsSimplified=%d itemsRemoved=%d blockEntities=%d", avg, currentTpsThreshold, queueSize, itemsMerged, itemsDespawned, mobsDisabled, mobsSimplified, itemsRemoved, blockEntities);
    }

    private static boolean hasMeaningfulOptimizations(OptimizationResults results) {
        if (results == null) {
            return false;
        }
        if (results.itemResult() != null) {
            if (results.itemResult().getMergedCount() > 0L) {
                return true;
            }
            if (results.itemResult().getDespawnedCount() > 0L) {
                return true;
            }
            if (!results.itemResult().getItemsToRemove().isEmpty()) {
                return true;
            }
        }
        if (results.mobResult() != null) {
            if (!results.mobResult().getDisableList().isEmpty()) {
                return true;
            }
            if (!results.mobResult().getSimplifyList().isEmpty()) {
                return true;
            }
        }
        return results.blockResult() != null && !results.blockResult().isEmpty();
    }

    private static void removeItems(MinecraftServer server, ItemProcessResult itemResult) {
        if (itemResult == null || itemResult.getItemsToRemove() == null || itemResult.getItemsToRemove().isEmpty()) {
            return;
        }
        for (ServerLevel level : server.getAllLevels()) {
            for (Long id : itemResult.getItemsToRemove()) {
                try {
                    Entity entity = level.getEntity(id.intValue());
                    if (entity == null) continue;
                    entity.remove(Entity.RemovalReason.DISCARDED);
                }
                catch (Exception e) {
                    LOGGER.debug("Error removing item entity { } on level { }", new Object[]{id, level.dimension(), e});
                }
            }
        }
    }

    static {
        PROFILE_DATA = ThreadLocal.withInitial(ProfileData::new);
        enabled = CONFIG.isEnabled();
        LEVEL_SPATIAL_GRIDS = new HashMap<ServerLevel, SpatialGrid>();
        SPATIAL_GRID_LOCK = new Object();
        currentTpsThreshold = CONFIG.getTpsThresholdForAsync();
        try {
            NativeBridge.initRustAllocator();
            LOGGER.info("Rust allocator initialized successfully");
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.debug("Rust allocator initialization skipped - native library not available");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to initialize Rust allocator, using system default", (Throwable)e);
        }
    }

    public static final class ExecutorMetrics {
        long totalTasksSubmitted = 0L;
        long totalTasksCompleted = 0L;
        long totalTasksRejected = 0L;
        long currentQueueSize = 0L;
        double currentUtilization = 0.0;
        int currentThreadCount = 0;
        int peakThreadCount = 0;
        long lastScaleUpTime = 0L;
        long lastScaleDownTime = 0L;
        int scaleUpCount = 0;
        int scaleDownCount = 0;

        String toJson() {
            return String.format("{\"totalTasksSubmitted\":%d,\"totalTasksCompleted\":%d,\"totalTasksRejected\":%d,\"currentQueueSize\":%d,\"currentUtilization\":%.2f,\"currentThreadCount\":%d,\"peakThreadCount\":%d,\"scaleUpCount\":%d,\"scaleDownCount\":%d}", this.totalTasksSubmitted, this.totalTasksCompleted, this.totalTasksRejected, this.currentQueueSize, this.currentUtilization, this.currentThreadCount, this.peakThreadCount, this.scaleUpCount, this.scaleDownCount);
        }
    }

    private static final class ProfileData {
        long entityCollectionTime = 0L;
        long itemConsolidationTime = 0L;
        long optimizationProcessingTime = 0L;
        long optimizationApplicationTime = 0L;
        long spatialGridTime = 0L;
        long TOTAL_TICK_TIME = 0L;
        int entitiesProcessed = 0;
        int itemsProcessed = 0;
        int executorQueueSize = 0;

        private ProfileData() {
        }

        boolean isSlowTick() {
            return this.TOTAL_TICK_TIME > SLOW_TICK_THRESHOLD_MS * 1000000L;
        }

        String toJson() {
            return String.format("{\"entityCollectionMs\":%.2f,\"itemConsolidationMs\":%.2f,\"optimizationProcessingMs\":%.2f,\"optimizationApplicationMs\":%.2f,\"spatialGridMs\":%.2f,\"totalTickMs\":%.2f,\"entitiesProcessed\":%d,\"itemsProcessed\":%d,\"executorQueueSize\":%d}", (double)this.entityCollectionTime / 1000000.0, (double)this.itemConsolidationTime / 1000000.0, (double)this.optimizationProcessingTime / 1000000.0, (double)this.optimizationApplicationTime / 1000000.0, (double)this.spatialGridTime / 1000000.0, (double)this.TOTAL_TICK_TIME / 1000000.0, this.entitiesProcessed, this.itemsProcessed, this.executorQueueSize);
        }
    }

    private record EntityDataCollection(List<EntityData> entities, List<ItemEntityData> items, List<MobData> mobs, List<BlockEntityData> blockEntities, List<PlayerData> players) {
    }

    private record OptimizationResults(List<Long> toTick, List<Long> blockResult, ItemProcessResult itemResult, MobProcessResult mobResult) {
    }

    private record EntityCollectionContext(List<EntityData> entities, List<ItemEntityData> items, List<MobData> mobs, int maxEntities, double distanceCutoff, List<PlayerData> players, String[] excluded, double cutoffSq) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EntityCollectionContext that = (EntityCollectionContext)obj;
            return this.maxEntities == that.maxEntities && Double.compare(that.distanceCutoff, this.distanceCutoff) == 0 && Double.compare(that.cutoffSq, this.cutoffSq) == 0 && Objects.equals(this.entities, that.entities) && Objects.equals(this.items, that.items) && Objects.equals(this.mobs, that.mobs) && Objects.equals(this.players, that.players) && Arrays.equals(this.excluded, that.excluded);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.entities, this.items, this.mobs, this.maxEntities, this.distanceCutoff, this.players, this.cutoffSq);
            result = 31 * result + Arrays.hashCode(this.excluded);
            return result;
        }

        @Override
        public String toString() {
            return "EntityCollectionContext{entities=" + String.valueOf(this.entities) + ", items=" + String.valueOf(this.items) + ", mobs=" + String.valueOf(this.mobs) + ", maxEntities=" + this.maxEntities + ", distanceCutoff=" + this.distanceCutoff + ", players=" + String.valueOf(this.players) + ", excluded=" + Arrays.toString(this.excluded) + ", cutoffSq=" + this.cutoffSq + "}";
        }
    }
}

