/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.spatial;

import com.kneaf.core.data.entity.PlayerData;
import com.kneaf.core.performance.core.PerformanceConstants;
import com.kneaf.core.performance.monitoring.PerformanceManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpatialGrid {
    private final double cellSize;
    private final Map<Long, Set<PlayerData>> gridCells;
    private final Map<Long, PlayerData> playerPositionCache;

    public SpatialGrid() {
        this(PerformanceConstants.getAdaptiveCellSize(PerformanceManager.getAverageTPS()));
    }

    public SpatialGrid(double cellSize) {
        this.cellSize = cellSize;
        this.gridCells = new HashMap<Long, Set<PlayerData>>();
        this.playerPositionCache = new HashMap<Long, PlayerData>();
    }

    public void updatePlayer(PlayerData player) {
        PlayerData oldPlayer = this.playerPositionCache.get(player.getId());
        if (oldPlayer != null) {
            this.removePlayerFromGrid(oldPlayer);
        }
        this.playerPositionCache.put(player.getId(), player);
        this.addPlayerToGrid(player);
    }

    public void removePlayer(long playerId) {
        PlayerData player = this.playerPositionCache.remove(playerId);
        if (player != null) {
            this.removePlayerFromGrid(player);
        }
    }

    public List<PlayerDistance> findNearbyPlayers(double x, double y, double z, double radius) {
        int estimatedSize = Math.min(32, (int)(radius * radius / (this.cellSize * this.cellSize)));
        HashSet<PlayerDistance> nearbyPlayers = new HashSet<PlayerDistance>(estimatedSize);
        double radiusSquared = radius * radius;
        int minCellX = (int)Math.floor((x - radius) / this.cellSize);
        int maxCellX = (int)Math.floor((x + radius) / this.cellSize);
        int minCellZ = (int)Math.floor((z - radius) / this.cellSize);
        int maxCellZ = (int)Math.floor((z + radius) / this.cellSize);
        for (int cellX = minCellX; cellX <= maxCellX; ++cellX) {
            for (int cellZ = minCellZ; cellZ <= maxCellZ; ++cellZ) {
                long cellKey = this.getCellKey(cellX, cellZ);
                this.addNearbyPlayersFromCell(nearbyPlayers, cellKey, x, y, z, radiusSquared);
            }
        }
        ArrayList<PlayerDistance> result = new ArrayList<PlayerDistance>(nearbyPlayers);
        result.sort(Comparator.comparingDouble(PlayerDistance::distance));
        return result;
    }

    private void addNearbyPlayersFromCell(Set<PlayerDistance> nearbyPlayers, long cellKey, double x, double y, double z, double radiusSquared) {
        Set<PlayerData> cellPlayers = this.gridCells.get(cellKey);
        if (cellPlayers != null) {
            for (PlayerData player : cellPlayers) {
                double dz;
                double dy;
                double dx = player.getX() - x;
                double distanceSquared = dx * dx + (dy = player.getY() - y) * dy + (dz = player.getZ() - z) * dz;
                if (!(distanceSquared <= radiusSquared)) continue;
                nearbyPlayers.add(new PlayerDistance(player, Math.sqrt(distanceSquared)));
            }
        }
    }

    private double getMinSquaredDistanceFromCell(long cellKey, double x, double y, double z) {
        Set<PlayerData> cellPlayers = this.gridCells.get(cellKey);
        if (cellPlayers == null) {
            return Double.MAX_VALUE;
        }
        double min = Double.MAX_VALUE;
        for (PlayerData player : cellPlayers) {
            double dz;
            double dy;
            double dx = player.getX() - x;
            double distanceSquared = dx * dx + (dy = player.getY() - y) * dy + (dz = player.getZ() - z) * dz;
            if (!(distanceSquared < min)) continue;
            min = distanceSquared;
        }
        return min;
    }

    public double findMinSquaredDistance(double x, double y, double z, double maxSearchRadius) {
        double minDistanceSquared = Double.MAX_VALUE;
        int minCellX = (int)Math.floor((x - maxSearchRadius) / this.cellSize);
        int maxCellX = (int)Math.floor((x + maxSearchRadius) / this.cellSize);
        int minCellZ = (int)Math.floor((z - maxSearchRadius) / this.cellSize);
        int maxCellZ = (int)Math.floor((z + maxSearchRadius) / this.cellSize);
        for (int cellX = minCellX; cellX <= maxCellX; ++cellX) {
            for (int cellZ = minCellZ; cellZ <= maxCellZ; ++cellZ) {
                long cellKey = this.getCellKey(cellX, cellZ);
                double cellMin = this.getMinSquaredDistanceFromCell(cellKey, x, y, z);
                if (!(cellMin < minDistanceSquared) || !((minDistanceSquared = cellMin) < 1.0)) continue;
                return minDistanceSquared;
            }
        }
        return minDistanceSquared == Double.MAX_VALUE ? Double.MAX_VALUE : minDistanceSquared;
    }

    public void clear() {
        this.gridCells.clear();
        this.playerPositionCache.clear();
    }

    public int getPlayerCount() {
        return this.playerPositionCache.size();
    }

    public boolean shouldUpdatePlayer(PlayerData player) {
        double dz;
        double dy;
        PlayerData cachedPlayer = this.playerPositionCache.get(player.getId());
        if (cachedPlayer == null) {
            return true;
        }
        double dx = player.getX() - cachedPlayer.getX();
        double distanceSquared = dx * dx + (dy = player.getY() - cachedPlayer.getY()) * dy + (dz = player.getZ() - cachedPlayer.getZ()) * dz;
        return distanceSquared > 1.0;
    }

    public GridStats getStats() {
        int totalCells = this.gridCells.size();
        int totalPlayers = this.playerPositionCache.size();
        int maxPlayersPerCell = this.gridCells.values().stream().mapToInt(Set::size).max().orElse(0);
        double avgPlayersPerCell = totalCells > 0 ? (double)totalPlayers / (double)totalCells : 0.0;
        return new GridStats(totalCells, totalPlayers, maxPlayersPerCell, avgPlayersPerCell);
    }

    private void addPlayerToGrid(PlayerData player) {
        long cellKey = this.getCellKeyForPosition(player.getX(), player.getZ());
        this.gridCells.computeIfAbsent(cellKey, k -> new HashSet()).add(player);
    }

    private void removePlayerFromGrid(PlayerData player) {
        long cellKey = this.getCellKeyForPosition(player.getX(), player.getZ());
        Set<PlayerData> cellPlayers = this.gridCells.get(cellKey);
        if (cellPlayers != null) {
            cellPlayers.remove(player);
            if (cellPlayers.isEmpty()) {
                this.gridCells.remove(cellKey);
            }
        }
    }

    private long getCellKeyForPosition(double x, double z) {
        int cellX = (int)Math.floor(x / this.cellSize);
        int cellZ = (int)Math.floor(z / this.cellSize);
        return this.getCellKey(cellX, cellZ);
    }

    private long getCellKey(int cellX, int cellZ) {
        return (long)cellX << 32 | (long)cellZ & 0xFFFFFFFFL;
    }

    public static class PlayerDistance {
        private final PlayerData player;
        private final double distance;

        public PlayerDistance(PlayerData player, double distance) {
            this.player = player;
            this.distance = distance;
        }

        public PlayerData player() {
            return this.player;
        }

        public double distance() {
            return this.distance;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PlayerDistance that = (PlayerDistance)obj;
            return this.player.getId() == that.player.getId();
        }

        public int hashCode() {
            return Long.hashCode(this.player.getId());
        }
    }

    public static class GridStats {
        private final int totalCells;
        private final int totalPlayers;
        private final int maxPlayersPerCell;
        private final double avgPlayersPerCell;

        public GridStats(int totalCells, int totalPlayers, int maxPlayersPerCell, double avgPlayersPerCell) {
            this.totalCells = totalCells;
            this.totalPlayers = totalPlayers;
            this.maxPlayersPerCell = maxPlayersPerCell;
            this.avgPlayersPerCell = avgPlayersPerCell;
        }

        public int totalCells() {
            return this.totalCells;
        }

        public int totalPlayers() {
            return this.totalPlayers;
        }

        public int maxPlayersPerCell() {
            return this.maxPlayersPerCell;
        }

        public double avgPlayersPerCell() {
            return this.avgPlayersPerCell;
        }

        public String toString() {
            return String.format("GridStats{cells=%d, players=%d, maxPerCell=%d, avgPerCell=%.2f}", this.totalCells, this.totalPlayers, this.maxPlayersPerCell, this.avgPlayersPerCell);
        }
    }
}

