/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary.core;

import com.kneaf.core.binary.core.BinarySerializer;
import com.kneaf.core.binary.core.SerializationUtils;
import com.kneaf.core.binary.utils.BufferPool;
import com.kneaf.core.binary.utils.SchemaValidator;
import com.kneaf.core.binary.utils.SerializationException;
import java.nio.ByteBuffer;

public abstract class BaseBinarySerializer<T, R>
implements BinarySerializer<T, R> {
    protected final BufferPool bufferPool;
    protected final SchemaValidator<T> validator;
    protected final String serializerType;
    protected final String schemaVersion;

    protected BaseBinarySerializer(String serializerType, String schemaVersion) {
        this(serializerType, schemaVersion, new BufferPool(), null);
    }

    protected BaseBinarySerializer(String serializerType, String schemaVersion, BufferPool bufferPool) {
        this(serializerType, schemaVersion, bufferPool, null);
    }

    protected BaseBinarySerializer(String serializerType, String schemaVersion, BufferPool bufferPool, SchemaValidator<T> validator) {
        if (serializerType == null || serializerType.trim().isEmpty()) {
            throw new IllegalArgumentException("Serializer type cannot be null or empty");
        }
        if (schemaVersion == null || schemaVersion.trim().isEmpty()) {
            throw new IllegalArgumentException("Schema version cannot be null or empty");
        }
        this.serializerType = serializerType;
        this.schemaVersion = schemaVersion;
        this.bufferPool = bufferPool != null ? bufferPool : new BufferPool();
        this.validator = validator;
    }

    @Override
    public byte[] serialize(T input) throws SerializationException {
        if (input == null) {
            throw new SerializationException("Input cannot be null", this.serializerType, "serialize");
        }
        if (this.validator != null && !this.validator.validate(input).isValid()) {
            throw new SerializationException("Input validation failed", this.serializerType, "serialize");
        }
        ByteBuffer buffer = null;
        try {
            buffer = this.bufferPool.borrowBuffer();
            this.serializeToBufferInternal(input, buffer);
            byte[] result = new byte[buffer.position()];
            buffer.flip();
            buffer.get(result);
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e) {
            throw new SerializationException("Serialization failed", e, this.serializerType, "serialize", buffer != null ? buffer.array() : null);
        }
        finally {
            if (buffer != null) {
                this.bufferPool.returnBuffer(buffer);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R deserialize(byte[] data) throws SerializationException {
        if (data == null) {
            throw new SerializationException("Data cannot be null", this.serializerType, "deserialize");
        }
        if (data.length == 0) {
            throw new SerializationException("Data cannot be empty", this.serializerType, "deserialize");
        }
        ByteBuffer buffer = null;
        try {
            buffer = SerializationUtils.wrapBuffer(data);
            R r = this.deserializeFromBuffer(buffer);
            return r;
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Deserialization failed", e, this.serializerType, "deserialize", data);
        }
    }

    @Override
    public ByteBuffer serializeToBuffer(T input) throws SerializationException {
        if (input == null) {
            throw new SerializationException("Input cannot be null", this.serializerType, "serializeToBuffer");
        }
        if (this.validator != null && !this.validator.validate(input).isValid()) {
            throw new SerializationException("Input validation failed", this.serializerType, "serializeToBuffer");
        }
        ByteBuffer buffer = null;
        try {
            buffer = this.bufferPool.borrowBuffer();
            this.serializeToBufferInternal(input, buffer);
            return buffer;
        }
        catch (Exception e) {
            if (buffer != null) {
                this.bufferPool.returnBuffer(buffer);
            }
            throw new SerializationException("Serialization to buffer failed", e, this.serializerType, "serializeToBuffer", buffer != null ? buffer.array() : null);
        }
    }

    @Override
    public R deserializeFromBuffer(ByteBuffer buffer) throws SerializationException {
        if (buffer == null) {
            throw new SerializationException("Buffer cannot be null", this.serializerType, "deserializeFromBuffer");
        }
        try {
            return this.deserializeFromBufferInternal(buffer);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Deserialization from buffer failed", e, this.serializerType, "deserializeFromBuffer", null);
        }
    }

    @Override
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public boolean validateInput(T input) {
        if (this.validator == null) {
            return true;
        }
        return this.validator.validate(input).isValid();
    }

    @Override
    public String getSerializerType() {
        return this.serializerType;
    }

    protected abstract void serializeToBufferInternal(T var1, ByteBuffer var2) throws SerializationException;

    protected abstract R deserializeFromBufferInternal(ByteBuffer var1) throws SerializationException;

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public SchemaValidator<T> getValidator() {
        return this.validator;
    }

    public void shutdown() {
        if (this.bufferPool != null) {
            this.bufferPool.clear();
        }
    }
}

