/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage.serialization;

import com.kneaf.core.chunkstorage.serialization.ChunkSerializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastNbtSerializer
implements ChunkSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FastNbtSerializer.class);
    private static final String FORMAT_NAME = "FAST_NBT";
    private static final int FORMAT_VERSION = 1;
    private static final boolean FAST_NBT_AVAILABLE;
    private static final boolean FAST_IMPL_PRESENT;
    private static final Class<?> FAST_IMPL_CLASS;
    private static final Method FAST_IMPL_SERIALIZE;
    private static final Method FAST_IMPL_DESERIALIZE;

    public static boolean isFastNbtAvailable() {
        return FAST_NBT_AVAILABLE;
    }

    @Override
    public byte[] serialize(Object chunk) throws IOException {
        if (!FAST_NBT_AVAILABLE) {
            throw new UnsupportedOperationException("FastNBT is not available");
        }
        if (chunk == null) {
            throw new IllegalArgumentException("Chunk cannot be null");
        }
        return this.serializeChunk(chunk);
    }

    @Override
    public Object deserialize(byte[] data) throws IOException {
        if (!FAST_NBT_AVAILABLE) {
            throw new UnsupportedOperationException("FastNBT is not available");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Data cannot be null or empty");
        }
        return this.deserializeChunk(data);
    }

    @Override
    public String getFormat() {
        return FORMAT_NAME;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean supports(String format, int version) {
        return FORMAT_NAME.equals(format) && version == 1;
    }

    private byte[] serializeChunk(Object chunk) throws IOException {
        if (chunk == null) {
            throw new IllegalArgumentException("Chunk cannot be null");
        }
        if (FAST_IMPL_PRESENT && FAST_IMPL_CLASS != null) {
            try {
                Object res = FAST_IMPL_SERIALIZE.invoke(null, chunk);
                if (res instanceof byte[]) {
                    return (byte[])res;
                }
                throw new IOException("FastNbtImplementation.serialize did not return byte[]");
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("FastNbtImplementation invocation failed, falling back: {}", (Object)e.getMessage());
            }
        }
        try {
            Class<?> extractorClass = Class.forName("com.kneaf.core.chunkstorage.serialization.RawNbtExtractor");
            Object extractor = extractorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method m = extractorClass.getMethod("serialize", Object.class);
            Object res = m.invoke(extractor, chunk);
            if (res instanceof byte[]) {
                return (byte[])res;
            }
            LOGGER.debug("RawNbtExtractor.serialize returned unexpected type: {}", res == null ? "null" : res.getClass());
        }
        catch (Throwable t) {
            LOGGER.debug("RawNbtExtractor unavailable or failed: {}", (Object)t.getMessage());
        }
        try {
            String repr = chunk.toString();
            HashMap<String, Object> wrapper = new HashMap<String, Object>();
            wrapper.put("fallback", true);
            wrapper.put("class", chunk.getClass().getName());
            wrapper.put("data", repr);
            StringBuilder sb = new StringBuilder();
            sb.append("{\"fallback\":true,\"class\":\"").append(chunk.getClass().getName()).append("\",\"data\":\"").append(FastNbtSerializer.escapeString(repr)).append("\"}");
            return sb.toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            throw new IOException("Failed to serialize chunk using fallback: " + t.getMessage(), t);
        }
    }

    private Object deserializeChunk(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Data cannot be null or empty");
        }
        if (FAST_IMPL_PRESENT && FAST_IMPL_CLASS != null) {
            try {
                Object res = FAST_IMPL_DESERIALIZE.invoke(null, new Object[]{data});
                return res;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("FastNbtImplementation.deserialize invocation failed, falling back: {}", (Object)e.getMessage());
            }
        }
        try {
            Class<?> extractorClass = Class.forName("com.kneaf.core.chunkstorage.serialization.RawNbtExtractor");
            Object extractor = extractorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method m = extractorClass.getMethod("deserialize", byte[].class);
            return m.invoke(extractor, new Object[]{data});
        }
        catch (Throwable t) {
            LOGGER.debug("RawNbtExtractor unavailable or failed: {}", (Object)t.getMessage());
            try {
                int idx;
                String s = new String(data, StandardCharsets.UTF_8);
                if (s.startsWith("{\"fallback\"") && (idx = s.indexOf("\",\"data\":\"")) >= 0) {
                    int start = idx + "\",\"data\":\"".length();
                    int end = s.lastIndexOf(34);
                    if (end > start) {
                        String payload = FastNbtSerializer.unescapeString(s.substring(start, end));
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("payload", payload);
                        return map;
                    }
                }
                return data;
            }
            catch (Throwable t2) {
                throw new IOException("Failed to deserialize data using fallback: " + t2.getMessage(), t2);
            }
        }
    }

    private static String escapeString(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
    }

    private static String unescapeString(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\n", "\n").replace("\\\"", "\"").replace("\\\\", "\\");
    }

    static {
        boolean available = false;
        boolean fastImpl = false;
        Class<?> implClass = null;
        Method implSerialize = null;
        Method implDeserialize = null;
        try {
            implClass = Class.forName("com.kneaf.core.chunkstorage.serialization.fast.FastNbtImplementation");
            implSerialize = implClass.getMethod("serialize", Object.class);
            implDeserialize = implClass.getMethod("deserialize", byte[].class);
            fastImpl = true;
            available = true;
            LOGGER.info("FastNBT implementation found: {}", (Object)implClass.getName());
        }
        catch (Throwable t) {
            LOGGER.debug("No project FastNBT implementation available: {}", (Object)t.getMessage());
        }
        if (!available) {
            try {
                Class.forName("net.minecraft.nbt.NbtIo");
                Class.forName("net.minecraft.nbt.CompoundTag");
                available = true;
                LOGGER.info("Minecraft NBT classes available - FastNbtSerializer will use RawNbtExtractor fallback");
            }
            catch (Throwable t) {
                LOGGER.debug("Minecraft NBT classes not available: {}", (Object)t.getMessage());
            }
        }
        FAST_NBT_AVAILABLE = available;
        FAST_IMPL_PRESENT = fastImpl;
        FAST_IMPL_CLASS = implClass;
        FAST_IMPL_SERIALIZE = implSerialize;
        FAST_IMPL_DESERIALIZE = implDeserialize;
    }
}

