/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.data.core;

import com.kneaf.core.data.block.BlockEntityData;
import com.kneaf.core.data.entity.EntityData;
import com.kneaf.core.data.entity.MobData;
import com.kneaf.core.data.entity.PlayerData;
import com.kneaf.core.data.entity.VillagerData;
import com.kneaf.core.data.item.ItemEntityData;
import java.util.List;

public class EntityInput {
    private final List<EntityData> entities;
    private final List<PlayerData> players;
    private final List<MobData> mobs;
    private final List<VillagerData> villagers;
    private final List<ItemEntityData> items;
    private final List<BlockEntityData> blockEntities;

    public EntityInput(List<EntityData> entities, List<PlayerData> players, List<MobData> mobs, List<VillagerData> villagers, List<ItemEntityData> items, List<BlockEntityData> blockEntities) {
        this.entities = entities != null ? List.copyOf(entities) : List.of();
        this.players = players != null ? List.copyOf(players) : List.of();
        this.mobs = mobs != null ? List.copyOf(mobs) : List.of();
        this.villagers = villagers != null ? List.copyOf(villagers) : List.of();
        this.items = items != null ? List.copyOf(items) : List.of();
        this.blockEntities = blockEntities != null ? List.copyOf(blockEntities) : List.of();
    }

    public List<EntityData> entities() {
        return this.entities;
    }

    public List<PlayerData> players() {
        return this.players;
    }

    public List<MobData> mobs() {
        return this.mobs;
    }

    public List<VillagerData> villagers() {
        return this.villagers;
    }

    public List<ItemEntityData> items() {
        return this.items;
    }

    public List<BlockEntityData> blockEntities() {
        return this.blockEntities;
    }

    public boolean validate() {
        for (EntityData entity : this.entities) {
            entity.validate();
        }
        for (PlayerData player : this.players) {
            player.validate();
        }
        for (MobData mob : this.mobs) {
            mob.validate();
        }
        for (VillagerData villager : this.villagers) {
            villager.validate();
        }
        for (ItemEntityData item : this.items) {
            item.validate();
        }
        for (BlockEntityData blockEntity : this.blockEntities) {
            blockEntity.validate();
        }
        return true;
    }

    public int getTotalEntityCount() {
        return this.entities.size() + this.players.size() + this.mobs.size() + this.villagers.size() + this.items.size() + this.blockEntities.size();
    }

    public boolean hasEntities() {
        return !this.entities.isEmpty() || !this.players.isEmpty() || !this.mobs.isEmpty() || !this.villagers.isEmpty() || !this.items.isEmpty() || !this.blockEntities.isEmpty();
    }
}

