/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions;

import com.kneaf.core.exceptions.storage.DatabaseException;

@Deprecated
public class DatabaseException
extends RuntimeException {
    private final com.kneaf.core.exceptions.storage.DatabaseException delegate;
    private final DatabaseErrorType errorType;
    private final String databaseType;
    private final String key;

    public DatabaseException(DatabaseErrorType errorType, String message) {
        super(message);
        this.delegate = ((DatabaseException.Builder)com.kneaf.core.exceptions.storage.DatabaseException.builder().errorType(DatabaseException.convertErrorType(errorType)).message(message)).build();
        this.errorType = errorType;
        this.databaseType = null;
        this.key = null;
    }

    public DatabaseException(DatabaseErrorType errorType, String message, Throwable cause) {
        super(message, cause);
        this.delegate = ((DatabaseException.Builder)((DatabaseException.Builder)com.kneaf.core.exceptions.storage.DatabaseException.builder().errorType(DatabaseException.convertErrorType(errorType)).message(message)).cause(cause)).build();
        this.errorType = errorType;
        this.databaseType = null;
        this.key = null;
    }

    public DatabaseException(DatabaseErrorType errorType, String operation, String databaseType, String key, String message, Throwable cause) {
        super(message, cause);
        this.delegate = ((DatabaseException.Builder)((DatabaseException.Builder)com.kneaf.core.exceptions.storage.DatabaseException.builder().errorType(DatabaseException.convertErrorType(errorType)).message(message)).cause(cause)).build();
        this.errorType = errorType;
        this.databaseType = databaseType;
        this.key = key;
    }

    public DatabaseException(DatabaseErrorType errorType, String databaseType, String message, Throwable cause) {
        super(message, cause);
        this.delegate = ((DatabaseException.Builder)((DatabaseException.Builder)com.kneaf.core.exceptions.storage.DatabaseException.builder().errorType(DatabaseException.convertErrorType(errorType)).databaseType(databaseType).message(message)).cause(cause)).build();
        this.errorType = errorType;
        this.databaseType = databaseType;
        this.key = null;
    }

    public DatabaseErrorType getErrorType() {
        return this.errorType != null ? this.errorType : DatabaseException.convertErrorTypeBack(this.delegate.getErrorType());
    }

    public String getDatabaseType() {
        return this.databaseType != null ? this.databaseType : this.delegate.getDatabaseType();
    }

    public String getKey() {
        return this.key != null ? this.key : this.delegate.getKey();
    }

    public com.kneaf.core.exceptions.storage.DatabaseException getDelegate() {
        return this.delegate;
    }

    public static DatabaseException asyncOperationFailed(String operation, String databaseType, String key, Throwable cause) {
        return new DatabaseException(DatabaseErrorType.ASYNC_OPERATION_FAILED, operation, databaseType, key, String.format("Async %s operation failed", operation), cause);
    }

    public static DatabaseException nativeLibraryError(String databaseType, String message, Throwable cause) {
        return new DatabaseException(DatabaseErrorType.NATIVE_LIBRARY_ERROR, databaseType, message, cause);
    }

    private static DatabaseException.DatabaseErrorType convertErrorType(DatabaseErrorType errorType) {
        if (errorType == null) {
            return null;
        }
        switch (errorType.ordinal()) {
            case 0: {
                return DatabaseException.DatabaseErrorType.CONNECTION_FAILED;
            }
            case 1: {
                return DatabaseException.DatabaseErrorType.OPERATION_FAILED;
            }
            case 2: {
                return DatabaseException.DatabaseErrorType.TRANSACTION_FAILED;
            }
            case 3: {
                return DatabaseException.DatabaseErrorType.VALIDATION_FAILED;
            }
            case 4: {
                return DatabaseException.DatabaseErrorType.BACKUP_FAILED;
            }
            case 5: {
                return DatabaseException.DatabaseErrorType.MAINTENANCE_FAILED;
            }
            case 6: {
                return DatabaseException.DatabaseErrorType.NATIVE_LIBRARY_ERROR;
            }
            case 7: {
                return DatabaseException.DatabaseErrorType.ASYNC_OPERATION_FAILED;
            }
        }
        return DatabaseException.DatabaseErrorType.OPERATION_FAILED;
    }

    private static DatabaseErrorType convertErrorTypeBack(DatabaseException.DatabaseErrorType errorType) {
        if (errorType == null) {
            return null;
        }
        switch (errorType) {
            case CONNECTION_FAILED: {
                return DatabaseErrorType.CONNECTION_FAILED;
            }
            case OPERATION_FAILED: {
                return DatabaseErrorType.OPERATION_FAILED;
            }
            case TRANSACTION_FAILED: {
                return DatabaseErrorType.TRANSACTION_FAILED;
            }
            case VALIDATION_FAILED: {
                return DatabaseErrorType.VALIDATION_FAILED;
            }
            case BACKUP_FAILED: {
                return DatabaseErrorType.BACKUP_FAILED;
            }
            case MAINTENANCE_FAILED: {
                return DatabaseErrorType.MAINTENANCE_FAILED;
            }
            case NATIVE_LIBRARY_ERROR: {
                return DatabaseErrorType.NATIVE_LIBRARY_ERROR;
            }
            case ASYNC_OPERATION_FAILED: {
                return DatabaseErrorType.ASYNC_OPERATION_FAILED;
            }
        }
        return DatabaseErrorType.OPERATION_FAILED;
    }

    public static enum DatabaseErrorType {
        CONNECTION_FAILED("Database connection failed"),
        OPERATION_FAILED("Database operation failed"),
        TRANSACTION_FAILED("Database transaction failed"),
        VALIDATION_FAILED("Database validation failed"),
        BACKUP_FAILED("Database backup failed"),
        MAINTENANCE_FAILED("Database maintenance failed"),
        NATIVE_LIBRARY_ERROR("Native database library error"),
        ASYNC_OPERATION_FAILED("Async database operation failed");

        private final String description;

        private DatabaseErrorType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

