/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.core;

import com.google.gson.Gson;
import com.kneaf.core.KneafCore;
import com.kneaf.core.binary.ManualSerializers;
import com.kneaf.core.data.block.BlockEntityData;
import com.kneaf.core.data.entity.MobData;
import com.kneaf.core.data.item.ItemEntityData;
import com.kneaf.core.exceptions.OptimizedProcessingException;
import com.kneaf.core.performance.bridge.NativeBridgeUtils;
import com.kneaf.core.performance.core.EntityProcessor;
import com.kneaf.core.performance.core.ItemProcessResult;
import com.kneaf.core.performance.core.MobProcessResult;
import com.kneaf.core.performance.core.NativeBridgeProvider;
import com.kneaf.core.performance.core.PerformanceConstants;
import com.kneaf.core.performance.core.PerformanceMonitor;
import com.kneaf.core.performance.core.PerformanceProcessor;
import com.kneaf.core.performance.core.PerformanceUtils;
import com.kneaf.core.performance.monitoring.PerformanceManager;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class BatchProcessor {
    private final ConcurrentLinkedQueue<BatchRequest<?>> pendingRequests = new ConcurrentLinkedQueue();
    private final EntityProcessor entityProcessor;
    private final PerformanceMonitor monitor;
    private final NativeBridgeProvider bridgeProvider;
    private volatile boolean BATCH_PROCESSOR_RUNNING = false;
    private final Object batchLock = new Object();
    private final AtomicLong tickCount = new AtomicLong(0L);

    public BatchProcessor(EntityProcessor entityProcessor, PerformanceMonitor monitor, NativeBridgeProvider bridgeProvider) {
        this.entityProcessor = entityProcessor;
        this.monitor = monitor;
        this.bridgeProvider = bridgeProvider;
    }

    public <T> CompletableFuture<T> submitBatchRequest(String type, Object data) {
        CompletableFuture future = new CompletableFuture();
        BatchRequest request = new BatchRequest(type, data, future);
        this.pendingRequests.offer(request);
        if (!this.BATCH_PROCESSOR_RUNNING) {
            this.startBatchProcessor();
        }
        return future;
    }

    public CompletableFuture<List<Long>> submitLongListRequest(String type, Object data) {
        return this.submitBatchRequest(type, data);
    }

    public CompletableFuture<ItemProcessResult> submitItemRequest(String type, Object data) {
        return this.submitBatchRequest(type, data);
    }

    public CompletableFuture<MobProcessResult> submitMobRequest(String type, Object data) {
        return this.submitBatchRequest(type, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBatchProcessor() {
        Object object = this.batchLock;
        synchronized (object) {
            if (this.BATCH_PROCESSOR_RUNNING) {
                return;
            }
            this.BATCH_PROCESSOR_RUNNING = true;
            CompletableFuture.runAsync(() -> {
                while (this.BATCH_PROCESSOR_RUNNING) {
                    try {
                        this.processBatchOptimized();
                        Thread.sleep(this.getBatchProcessorSleepMs());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }).exceptionally(ex -> {
                KneafCore.LOGGER.error("Error in batch processor main loop", ex);
                return null;
            });
        }
    }

    private void processBatchOptimized() {
        List<BatchRequest<?>> batch = this.collectBatch();
        if (batch.isEmpty()) {
            return;
        }
        if (this.bridgeProvider.isNativeAvailable() && batch.size() >= NativeBridgeUtils.calculateOptimalBatchSize(1, 25, 200)) {
            try {
                this.processBatchWithNativeBridge(batch);
            }
            catch (OptimizedProcessingException e) {
                KneafCore.LOGGER.warn("NativeBridge batch processing failed, falling back to regular processing: {}", (Object)e.getMessage());
                HashMap batchedByType = new HashMap();
                for (BatchRequest<?> req : batch) {
                    batchedByType.computeIfAbsent(req.type, k -> new ArrayList()).add(req);
                }
                this.processBatchedRequests(batchedByType);
            }
            catch (Exception e) {
                KneafCore.LOGGER.error("Unexpected error in native batch processing", (Throwable)e);
                this.completeBatchRequestsWithException(batch, e);
            }
            return;
        }
        try {
            HashMap batchedByType = new HashMap();
            for (BatchRequest<?> req : batch) {
                batchedByType.computeIfAbsent(req.type, k -> new ArrayList()).add(req);
            }
            this.processBatchedRequests(batchedByType);
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Unexpected error in regular batch processing", (Throwable)e);
            this.completeBatchRequestsWithException(batch, e);
        }
    }

    private void completeBatchRequestsWithException(List<BatchRequest<?>> batch, Throwable exception) {
        CompletableFuture.runAsync(() -> {
            for (BatchRequest req : batch) {
                if (req.future.isDone()) continue;
                req.future.completeExceptionally(exception);
            }
        });
    }

    private void processBatchWithNativeBridge(List<BatchRequest<?>> batch) throws OptimizedProcessingException {
        HashMap<String, List> batchedByType = new HashMap<String, List>();
        for (BatchRequest<?> batchRequest : batch) {
            batchedByType.computeIfAbsent(batchRequest.type, k -> new ArrayList()).add(batchRequest);
        }
        block15: for (Map.Entry entry : batchedByType.entrySet()) {
            String type = (String)entry.getKey();
            List typeBatch = (List)entry.getValue();
            try {
                switch (type) {
                    case "entities": {
                        this.entityProcessor.processEntityBatchOptimized(this.convertBatchRequests(typeBatch));
                        break;
                    }
                    case "items": {
                        this.processItemBatchOptimized(typeBatch);
                        break;
                    }
                    case "mobs": {
                        this.processMobBatchOptimized(typeBatch);
                        break;
                    }
                    case "blocks": {
                        this.processBlockBatchOptimized(typeBatch);
                        break;
                    }
                    default: {
                        for (BatchRequest req : typeBatch) {
                            this.completeFutureAsync(req.future, this.processIndividualRequest(req.type, req.data));
                        }
                        continue block15;
                    }
                }
            }
            catch (Exception e) {
                KneafCore.LOGGER.error("Error processing {} batch of size {}", new Object[]{type, typeBatch.size(), e});
                this.completeBatchFuturesWithExceptionAsync(typeBatch, e);
            }
        }
    }

    private void processItemBatchOptimized(List<BatchRequest<?>> batch) throws OptimizedProcessingException {
        if (batch.isEmpty()) {
            return;
        }
        try {
            ArrayList<ItemEntityData> allItems = new ArrayList<ItemEntityData>();
            for (BatchRequest<?> req : batch) {
                List items = (List)req.data;
                allItems.addAll(items);
            }
            ItemProcessResult result = this.processItemEntitiesDirect(allItems);
            for (BatchRequest<?> req : batch) {
                this.completeFutureAsync(req.future, result);
            }
        }
        catch (Exception e) {
            throw OptimizedProcessingException.batchProcessingError("processItemBatchOptimized", "Failed to process item batch of size " + batch.size(), e);
        }
    }

    private void processMobBatchOptimized(List<BatchRequest<?>> batch) throws OptimizedProcessingException {
        if (batch.isEmpty()) {
            return;
        }
        try {
            ArrayList<MobData> allMobs = new ArrayList<MobData>();
            for (BatchRequest<?> req : batch) {
                List mobs = (List)req.data;
                allMobs.addAll(mobs);
            }
            MobProcessResult result = this.processMobAIDirect(allMobs);
            for (BatchRequest<?> req : batch) {
                this.completeFutureAsync(req.future, result);
            }
        }
        catch (Exception e) {
            throw OptimizedProcessingException.batchProcessingError("processMobBatchOptimized", "Failed to process mob batch of size " + batch.size(), e);
        }
    }

    private void processBlockBatchOptimized(List<BatchRequest<?>> batch) throws OptimizedProcessingException {
        if (batch.isEmpty()) {
            return;
        }
        try {
            ArrayList<BlockEntityData> allBlocks = new ArrayList<BlockEntityData>();
            for (BatchRequest<?> req : batch) {
                List blocks = (List)req.data;
                allBlocks.addAll(blocks);
            }
            List<Long> results = this.getBlockEntitiesToTickDirect(allBlocks);
            for (BatchRequest<?> req : batch) {
                this.completeFutureAsync(req.future, results);
            }
        }
        catch (Exception e) {
            throw OptimizedProcessingException.batchProcessingError("processBlockBatchOptimized", "Failed to process block batch of size " + batch.size(), e);
        }
    }

    private List<BatchRequest<?>> collectBatch() {
        BatchRequest<?> request;
        ArrayList batch = new ArrayList();
        int targetSize = this.getBatchSize();
        while (batch.size() < targetSize && (request = this.pendingRequests.poll()) != null) {
            batch.add(request);
        }
        if (!batch.isEmpty()) {
            return batch;
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        while (batch.size() < targetSize && (request = this.pendingRequests.poll()) != null) {
            batch.add(request);
        }
        return batch;
    }

    private int getBatchSize() {
        double tps = PerformanceManager.getAverageTPS();
        long tickDelay = PerformanceManager.getLastTickDurationMs();
        int base = PerformanceConstants.getAdaptiveBatchSize(tps, tickDelay);
        double tpsFactor = Math.max(0.5, Math.min(1.5, tps / 20.0));
        double delayFactor = 1.0;
        if (tickDelay > 50L) {
            delayFactor = Math.max(0.5, 50.0 / (double)tickDelay);
        }
        return Math.max(1, (int)((double)NativeBridgeUtils.calculateOptimalBatchSize(base, 25, 200) * tpsFactor * delayFactor));
    }

    private int getBatchProcessorSleepMs() {
        double tps = PerformanceManager.getAverageTPS();
        if (tps < 15.0) {
            return Math.max(1, PerformanceConstants.getAdaptiveBatchProcessorSleepMs(tps) / 2);
        }
        if (tps < 18.0) {
            return PerformanceConstants.getAdaptiveBatchProcessorSleepMs(tps);
        }
        return Math.max(1, PerformanceConstants.getAdaptiveBatchProcessorSleepMs(tps) * 2);
    }

    private void processBatchedRequests(Map<String, List<BatchRequest<?>>> batchedByType) {
        ArrayList processingTasks = new ArrayList();
        for (Map.Entry<String, List<BatchRequest<?>>> entry : batchedByType.entrySet()) {
            String type = entry.getKey();
            List<BatchRequest<?>> typeBatch = entry.getValue();
            CompletableFuture.runAsync(() -> {
                try {
                    switch (type) {
                        case "entities": {
                            this.entityProcessor.processEntityBatchOptimized(this.convertBatchRequests(typeBatch));
                            break;
                        }
                        case "items": {
                            this.processItemBatchAsync(typeBatch);
                            break;
                        }
                        case "mobs": {
                            this.processMobBatchAsync(typeBatch);
                            break;
                        }
                        case "blocks": {
                            this.processBlockBatchAsync(typeBatch);
                            break;
                        }
                        default: {
                            for (BatchRequest req : typeBatch) {
                                this.completeFutureAsync(req.future, this.processIndividualRequest(req.type, req.data));
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    KneafCore.LOGGER.error("Error processing {} batch of size {}", new Object[]{type, typeBatch.size(), e});
                    this.completeBatchFuturesWithExceptionAsync(typeBatch, e);
                }
            });
        }
        if (!processingTasks.isEmpty()) {
            CompletableFuture.allOf(processingTasks.toArray(new CompletableFuture[0])).join();
        }
    }

    private void processItemBatchAsync(List<BatchRequest<?>> batch) {
        if (batch.isEmpty()) {
            return;
        }
        ArrayList<ItemEntityData> allItems = new ArrayList<ItemEntityData>();
        for (BatchRequest<?> req : batch) {
            List items = (List)req.data;
            allItems.addAll(items);
        }
        ItemProcessResult result = this.processItemEntitiesDirect(allItems);
        for (BatchRequest<?> req : batch) {
            this.completeFutureAsync(req.future, result);
        }
    }

    private void processMobBatchAsync(List<BatchRequest<?>> batch) {
        if (batch.isEmpty()) {
            return;
        }
        ArrayList<MobData> allMobs = new ArrayList<MobData>();
        for (BatchRequest<?> req : batch) {
            List mobs = (List)req.data;
            allMobs.addAll(mobs);
        }
        MobProcessResult result = this.processMobAIDirect(allMobs);
        for (BatchRequest<?> req : batch) {
            this.completeFutureAsync(req.future, result);
        }
    }

    private void processBlockBatchAsync(List<BatchRequest<?>> batch) {
        if (batch.isEmpty()) {
            return;
        }
        ArrayList<BlockEntityData> allBlocks = new ArrayList<BlockEntityData>();
        for (BatchRequest<?> req : batch) {
            List blocks = (List)req.data;
            allBlocks.addAll(blocks);
        }
        List<Long> results = this.getBlockEntitiesToTickDirect(allBlocks);
        for (BatchRequest<?> req : batch) {
            this.completeFutureAsync(req.future, results);
        }
    }

    private void completeFutureAsync(CompletableFuture<?> future, Object result) {
        CompletableFuture<?> f = future;
        CompletableFuture.runAsync(() -> {
            if (!f.isDone()) {
                f.complete(result);
            } else {
                KneafCore.LOGGER.warn("Attempted to complete already done future, skipping");
            }
        });
    }

    private void completeBatchFuturesWithExceptionAsync(List<BatchRequest<?>> batch, Throwable exception) {
        CompletableFuture.runAsync(() -> {
            for (BatchRequest req : batch) {
                if (req.future.isDone()) continue;
                req.future.completeExceptionally(exception);
            }
        });
    }

    private ItemProcessResult processItemEntitiesDirect(List<ItemEntityData> items) {
        long startTime = System.currentTimeMillis();
        try {
            ByteBuffer inputBuffer;
            byte[] resultBytes;
            if (this.bridgeProvider.isNativeAvailable() && NativeBridgeUtils.isValidNativeResult(resultBytes = this.bridgeProvider.processItemEntitiesBinary(inputBuffer = ManualSerializers.serializeItemInput(this.tickCount.get(), items)))) {
                ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes);
                List<ItemEntityData> updatedItems = ManualSerializers.deserializeItemProcessResult(resultBuffer);
                ArrayList<Long> removeList = new ArrayList<Long>();
                ArrayList<PerformanceProcessor.ItemUpdate> updates = new ArrayList<PerformanceProcessor.ItemUpdate>();
                for (ItemEntityData item : updatedItems) {
                    if (item.getCount() == 0) {
                        removeList.add(item.getId());
                        continue;
                    }
                    updates.add(new PerformanceProcessor.ItemUpdate(item.getId(), item.getCount()));
                }
                ItemProcessResult result = new ItemProcessResult(removeList, updates.size(), removeList.size(), updates);
                this.monitor.recordItemProcessing(items.size(), updates.size(), removeList.size(), System.currentTimeMillis() - startTime);
                return result;
            }
            String jsonInput = new Gson().toJson(Map.of("items", items));
            String jsonResult = this.bridgeProvider.processItemEntitiesJson(jsonInput);
            if (NativeBridgeUtils.isValidJsonResult(jsonResult)) {
                PerformanceUtils.ItemParseResult parseResult = PerformanceUtils.parseItemResultFromJson(jsonResult);
                ArrayList<PerformanceProcessor.ItemUpdate> updates = new ArrayList<PerformanceProcessor.ItemUpdate>();
                for (PerformanceUtils.ItemUpdateParseResult update : parseResult.getItemUpdates()) {
                    updates.add(new PerformanceProcessor.ItemUpdate(update.getId(), update.getNewCount()));
                }
                ItemProcessResult result = new ItemProcessResult(parseResult.getItemsToRemove(), parseResult.getMergedCount(), parseResult.getDespawnedCount(), updates);
                this.monitor.recordItemProcessing(items.size(), (int)parseResult.getMergedCount(), (int)parseResult.getDespawnedCount(), System.currentTimeMillis() - startTime);
                return result;
            }
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing item entities", (Throwable)e);
        }
        this.monitor.recordItemProcessing(items.size(), 0L, 0L, System.currentTimeMillis() - startTime);
        return new ItemProcessResult(new ArrayList<Long>(), 0L, 0L, new ArrayList<PerformanceProcessor.ItemUpdate>());
    }

    private MobProcessResult processMobAIDirect(List<MobData> mobs) {
        long startTime = System.currentTimeMillis();
        try {
            ByteBuffer inputBuffer;
            byte[] resultBytes;
            if (this.bridgeProvider.isNativeAvailable() && NativeBridgeUtils.isValidNativeResult(resultBytes = this.bridgeProvider.processMobAiBinary(inputBuffer = ManualSerializers.serializeMobInput(this.tickCount.get(), mobs)))) {
                ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes).order(ByteOrder.LITTLE_ENDIAN);
                List<MobData> updatedMobs = ManualSerializers.deserializeMobProcessResult(resultBuffer);
                ArrayList<Long> simplifyList = new ArrayList<Long>();
                for (MobData mob : updatedMobs) {
                    simplifyList.add(mob.getId());
                }
                MobProcessResult result = new MobProcessResult(new ArrayList<Long>(), simplifyList);
                this.monitor.recordMobProcessing(mobs.size(), 0, simplifyList.size(), System.currentTimeMillis() - startTime);
                return result;
            }
            String jsonInput = new Gson().toJson(Map.of("mobs", mobs));
            String jsonResult = this.bridgeProvider.processMobAiJson(jsonInput);
            if (NativeBridgeUtils.isValidJsonResult(jsonResult)) {
                PerformanceUtils.MobParseResult parseResult = PerformanceUtils.parseMobResultFromJson(jsonResult);
                MobProcessResult result = new MobProcessResult(parseResult.getDisableList(), parseResult.getSimplifyList());
                this.monitor.recordMobProcessing(mobs.size(), parseResult.getDisableList().size(), parseResult.getSimplifyList().size(), System.currentTimeMillis() - startTime);
                return result;
            }
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing mob AI", (Throwable)e);
        }
        this.monitor.recordMobProcessing(mobs.size(), 0, 0, System.currentTimeMillis() - startTime);
        return new MobProcessResult(new ArrayList<Long>(), new ArrayList<Long>());
    }

    private List<Long> getBlockEntitiesToTickDirect(List<BlockEntityData> blockEntities) {
        long startTime = System.currentTimeMillis();
        try {
            long currentTick;
            if (this.bridgeProvider.isNativeAvailable()) {
                currentTick = this.tickCount.incrementAndGet();
                KneafCore.LOGGER.debug("Incrementing tickCount to {} for block processing", (Object)currentTick);
                ByteBuffer inputBuffer = ManualSerializers.serializeBlockInput(currentTick, blockEntities);
                byte[] resultBytes = this.bridgeProvider.processBlockEntitiesBinary(inputBuffer);
                if (NativeBridgeUtils.isValidNativeResult(resultBytes)) {
                    ArrayList<Long> resultList = new ArrayList<Long>();
                    for (BlockEntityData block : blockEntities) {
                        resultList.add(block.getId());
                    }
                    this.monitor.recordBlockProcessing(resultList.size(), System.currentTimeMillis() - startTime);
                    return resultList;
                }
            }
            currentTick = this.tickCount.incrementAndGet();
            KneafCore.LOGGER.debug("Incrementing tickCount to {} for block JSON processing", (Object)(currentTick + 1L));
            String jsonInput = new Gson().toJson(Map.of("tickCount", currentTick, "block_entities", blockEntities));
            String jsonResult = this.bridgeProvider.processBlockEntitiesJson(jsonInput);
            if (NativeBridgeUtils.isValidJsonResult(jsonResult)) {
                List<Long> resultList = PerformanceUtils.parseBlockResultFromJson(jsonResult);
                this.monitor.recordBlockProcessing(resultList.size(), System.currentTimeMillis() - startTime);
                return resultList;
            }
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing block entities", (Throwable)e);
        }
        ArrayList<Long> all = new ArrayList<Long>();
        for (BlockEntityData e : blockEntities) {
            all.add(e.getId());
        }
        this.monitor.recordBlockProcessing(all.size(), System.currentTimeMillis() - startTime);
        return all;
    }

    private List<EntityProcessor.BatchRequest> convertBatchRequests(List<BatchRequest<?>> batchRequests) {
        ArrayList<EntityProcessor.BatchRequest> converted = new ArrayList<EntityProcessor.BatchRequest>();
        for (BatchRequest<?> req : batchRequests) {
            CompletableFuture<Object> f = req.future;
            converted.add(new EntityProcessor.BatchRequest(req.type, req.data, f));
        }
        return converted;
    }

    private Object processIndividualRequest(String type, Object data) {
        return null;
    }

    public static class BatchRequest<T> {
        public final String type;
        public final Object data;
        public final CompletableFuture<T> future;

        public BatchRequest(String type, Object data, CompletableFuture<T> future) {
            this.type = type;
            this.data = data;
            this.future = future;
        }
    }
}

