/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.core;

import com.kneaf.core.protocol.core.ProtocolValidator;
import java.time.Instant;
import java.util.Map;

public interface ProtocolLogger {
    public void logOperationStart(String var1, String var2, String var3, Map<String, Object> var4);

    public void logOperationComplete(String var1, String var2, String var3, long var4, boolean var6, Map<String, Object> var7);

    public void logValidation(String var1, ProtocolValidator.ValidationResult var2, String var3, Map<String, Object> var4);

    public void logError(String var1, Exception var2, String var3, Map<String, Object> var4);

    public void logWarning(String var1, String var2, String var3, Map<String, Object> var4);

    public void logMetrics(String var1, Map<String, Number> var2, String var3);

    public String generateTraceId();

    public static class ProtocolLogEntry {
        private final String traceId;
        private final Instant timestamp;
        private final String operation;
        private final String protocolFormat;
        private final String level;
        private final String message;
        private final Map<String, Object> metadata;

        public ProtocolLogEntry(String traceId, Instant timestamp, String operation, String protocolFormat, String level, String message, Map<String, Object> metadata) {
            this.traceId = traceId;
            this.timestamp = timestamp;
            this.operation = operation;
            this.protocolFormat = protocolFormat;
            this.level = level;
            this.message = message;
            this.metadata = metadata;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public String getOperation() {
            return this.operation;
        }

        public String getProtocolFormat() {
            return this.protocolFormat;
        }

        public String getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }
    }
}

