/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.core;

import com.google.gson.Gson;
import java.nio.ByteBuffer;
import java.util.Map;

@Deprecated
public class ProtocolProcessor {
    public <T, R> ProtocolResult<R> processWithFallback(T input, String operationName, BinarySerializer<T> binarySerializer, BinaryNativeCaller<byte[]> binaryCaller, BinaryDeserializer<R> binaryDeserializer, JsonInputPreparer<T> jsonInputPreparer, JsonNativeCaller<String> jsonCaller, JsonResultParser<R> jsonResultParser, R fallbackResult) {
        try {
            ByteBuffer binaryInput = binarySerializer.serialize(input);
            byte[] binaryResult = binaryCaller.callNative(binaryInput);
            if (binaryResult != null && binaryResult.length > 0) {
                R result = binaryDeserializer.deserialize(binaryResult);
                return new ProtocolResult<R>(result, null, true);
            }
        }
        catch (Exception binaryInput) {
            // empty catch block
        }
        try {
            Map<String, Object> jsonInput = jsonInputPreparer.prepareInput(input);
            String jsonInputStr = new Gson().toJson(jsonInput);
            String jsonResult = jsonCaller.callNative(jsonInputStr);
            if (jsonResult != null && !jsonResult.isEmpty()) {
                R result = jsonResultParser.parseResult(jsonResult);
                return new ProtocolResult<R>(result, null, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ProtocolResult<R>(fallbackResult, null, true);
    }

    public static interface BinarySerializer<T> {
        public ByteBuffer serialize(T var1) throws Exception;
    }

    public static interface BinaryNativeCaller<R> {
        public R callNative(ByteBuffer var1) throws Exception;
    }

    public static interface BinaryDeserializer<T> {
        public T deserialize(byte[] var1) throws Exception;
    }

    public static class ProtocolResult<T> {
        private final T data;
        private final Exception error;
        private final boolean success;

        public ProtocolResult(T data, Exception error, boolean success) {
            this.data = data;
            this.error = error;
            this.success = success;
        }

        public T getDataOrThrow() throws Exception {
            if (!this.success && this.error != null) {
                throw this.error;
            }
            return this.data;
        }

        public T getData() {
            return this.data;
        }

        public Exception getError() {
            return this.error;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }

    public static interface JsonInputPreparer<T> {
        public Map<String, Object> prepareInput(T var1);
    }

    public static interface JsonNativeCaller<R> {
        public R callNative(String var1) throws Exception;
    }

    public static interface JsonResultParser<T> {
        public T parseResult(String var1) throws Exception;

        public static ProtocolProcessor createAuto(boolean nativeAvailable) {
            return new ProtocolProcessor();
        }
    }
}

