/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage.common;

import com.kneaf.core.chunkstorage.common.ChunkStorageConstants;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkStorageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkStorageUtils.class);

    private ChunkStorageUtils() {
    }

    public static void shutdownExecutor(ExecutorService executor, long timeoutSeconds, String executorName) {
        if (executor == null) {
            return;
        }
        executor.shutdown();
        try {
            if (!executor.awaitTermination(timeoutSeconds, TimeUnit.SECONDS)) {
                LOGGER.warn("{ } executor did not terminate within { } seconds, forcing shutdown", (Object)executorName, (Object)timeoutSeconds);
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("{ } executor shutdown interrupted, forcing shutdown", (Object)executorName);
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static String createChunkKey(String dimensionName, int chunkX, int chunkZ) {
        if (dimensionName == null || dimensionName.isEmpty()) {
            dimensionName = "unknown";
        }
        return String.format("%s:%d:%d", dimensionName, chunkX, chunkZ);
    }

    public static String createChunkKeyFromChunk(Object chunk, String worldName) {
        if (chunk == null || worldName == null || worldName.isEmpty()) {
            return String.format("%s:unknown", worldName != null ? worldName : "unknown");
        }
        try {
            Object chunkPos = chunk.getClass().getMethod("getPos", new Class[0]).invoke(chunk, new Object[0]);
            int x = (Integer)chunkPos.getClass().getMethod("x", new Class[0]).invoke(chunkPos, new Object[0]);
            int z = (Integer)chunkPos.getClass().getMethod("z", new Class[0]).invoke(chunkPos, new Object[0]);
            return String.format("%s:%d:%d", worldName, x, z);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create chunk key from chunk object", (Throwable)e);
            return String.format("%s:unknown", worldName);
        }
    }

    public static boolean isMinecraftLevelChunk(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            return Class.forName("net.minecraft.world.level.chunk.LevelChunk").isInstance(obj);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isMinecraftCompoundTag(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            return Class.forName("net.minecraft.nbt.CompoundTag").isInstance(obj);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isMinecraftAvailable() {
        try {
            Class.forName("net.minecraft.world.level.chunk.LevelChunk");
            Class.forName("net.minecraft.nbt.CompoundTag");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isValidChunkKey(String chunkKey) {
        if (chunkKey == null || chunkKey.trim().isEmpty()) {
            return false;
        }
        String trimmed = chunkKey.trim();
        String[] parts = trimmed.split(":");
        if (parts.length != 3) {
            return false;
        }
        try {
            Integer.parseInt(parts[1]);
            Integer.parseInt(parts[2]);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String[] extractCoordinatesFromKey(String chunkKey) {
        if (!ChunkStorageUtils.isValidChunkKey(chunkKey)) {
            return null;
        }
        return chunkKey.trim().split(":");
    }

    public static <T> CompletableFuture<T> failedFuture(Exception exception) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(exception);
        return future;
    }

    public static long estimateChunkSize(String chunkKey) {
        return 16384L;
    }

    public static byte[] serializeChunk(Object chunk) {
        if (chunk == null) {
            return ChunkStorageConstants.EMPTY_BYTE_ARRAY;
        }
        try {
            try {
                Class<?> levelChunkClass = Class.forName("net.minecraft.world.level.chunk.LevelChunk");
                if (levelChunkClass.isInstance(chunk)) {
                    return new byte[1024];
                }
            }
            catch (ClassNotFoundException levelChunkClass) {
                // empty catch block
            }
            String chunkString = chunk.toString();
            return chunkString.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Failed to serialize chunk", (Throwable)e);
            return ChunkStorageConstants.EMPTY_BYTE_ARRAY;
        }
    }

    public static void validateKey(String key) {
        if (key == null || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Chunk key cannot be null or empty");
        }
    }

    public static void validateData(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Chunk data cannot be null");
        }
    }

    public static void validateBackupPath(String backupPath) {
        if (backupPath == null || backupPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Backup path cannot be null or empty");
        }
    }
}

