/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage.core;

import com.kneaf.core.chunkstorage.cache.ChunkCache;
import com.kneaf.core.chunkstorage.common.ChunkStorageExceptionHandler;
import com.kneaf.core.chunkstorage.common.ChunkStorageUtils;
import com.kneaf.core.chunkstorage.database.DatabaseAdapter;
import com.kneaf.core.chunkstorage.serialization.ChunkSerializer;
import com.kneaf.core.chunkstorage.swap.SwapManager;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkStorageCore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkStorageCore.class);
    private final ChunkSerializer serializer;
    private final DatabaseAdapter database;
    private final ChunkCache cache;
    private SwapManager swapManager;
    private final String worldName;
    private final boolean enabled;

    public ChunkStorageCore(String worldName, ChunkSerializer serializer, DatabaseAdapter database, ChunkCache cache, boolean enabled) {
        this.worldName = worldName;
        this.serializer = serializer;
        this.database = database;
        this.cache = cache;
        this.swapManager = null;
        this.enabled = enabled;
    }

    public void setSwapManager(SwapManager swapManager) {
        this.swapManager = swapManager;
    }

    public CompletableFuture<Void> saveChunk(Object chunk) {
        if (!this.enabled || this.serializer == null) {
            return CompletableFuture.completedFuture(null);
        }
        String chunkKey = ChunkStorageUtils.createChunkKeyFromChunk(chunk, this.worldName);
        try {
            byte[] serializedData = this.serializer.serialize(chunk);
            ChunkCache.CachedChunk evicted = null;
            try {
                if (ChunkStorageUtils.isMinecraftLevelChunk(chunk)) {
                    evicted = this.cache.putChunk(chunkKey, chunk);
                } else {
                    LOGGER.debug("Chunk object is not a LevelChunk, skipping cache for { }", (Object)chunkKey);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to cache chunk { }: { }", (Object)chunkKey, (Object)e.getMessage());
            }
            CompletableFuture<Object> evictedSave = CompletableFuture.completedFuture(null);
            if (evicted != null && evicted.isDirty()) {
                Object evictedChunk = evicted.getChunk();
                String evictedKey = ChunkStorageUtils.createChunkKeyFromChunk(evictedChunk, this.worldName);
                evictedSave = this.saveChunkToDatabase(evictedKey, evictedChunk);
            }
            CompletableFuture<Void> currentSave = this.saveChunkToDatabase(chunkKey, serializedData);
            return CompletableFuture.allOf(evictedSave, currentSave);
        }
        catch (Exception e) {
            return ChunkStorageExceptionHandler.handleSaveException(chunkKey, e, "save");
        }
    }

    /*
     * Exception decompiling
     */
    public Optional<Object> loadChunk(Object level, int chunkX, int chunkZ) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 19[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean deleteChunk(Object level, int chunkX, int chunkZ) {
        if (!this.enabled) {
            return false;
        }
        String chunkKey = this.createChunkKey(level, chunkX, chunkZ);
        try {
            boolean deleted;
            ChunkCache.CachedChunk removedFromCache = this.cache.removeChunk(chunkKey);
            boolean removedFromDb = this.database.deleteChunk(chunkKey);
            boolean bl = deleted = removedFromCache != null || removedFromDb;
            if (deleted && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleted chunk { } from storage", (Object)chunkKey);
            }
            return deleted;
        }
        catch (Exception e) {
            return ChunkStorageExceptionHandler.handleDatabaseException("delete", chunkKey, e);
        }
    }

    private CompletableFuture<Void> saveChunkToDatabase(String chunkKey, byte[] data) {
        return this.database.putChunkAsync(chunkKey, data).exceptionally(throwable -> {
            LOGGER.error("Failed to save chunk { } to database", (Object)chunkKey, throwable);
            return null;
        });
    }

    private CompletableFuture<Void> saveChunkToDatabase(String chunkKey, Object chunk) {
        if (this.serializer == null) {
            LOGGER.warn("Cannot serialize chunk { } - serializer is null", (Object)chunkKey);
            return CompletableFuture.completedFuture(null);
        }
        try {
            byte[] data = this.serializer.serialize(chunk);
            return this.saveChunkToDatabase(chunkKey, data);
        }
        catch (Exception e) {
            LOGGER.error("Failed to serialize chunk { } for database storage", (Object)chunkKey, (Object)e);
            return ChunkStorageUtils.failedFuture(e);
        }
    }

    private String createChunkKey(Object level, int chunkX, int chunkZ) {
        try {
            Object dimension = level.getClass().getMethod("dimension", new Class[0]).invoke(level, new Object[0]);
            Object location = dimension.getClass().getMethod("location", new Class[0]).invoke(dimension, new Object[0]);
            String dimensionName = location.toString();
            return String.format("%s:%d:%d", dimensionName, chunkX, chunkZ);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create chunk key from level object", (Throwable)e);
            return String.format("unknown:%d:%d", chunkX, chunkZ);
        }
    }

    public boolean isHealthy() {
        if (!this.enabled) {
            return false;
        }
        try {
            return this.database.isHealthy();
        }
        catch (Exception e) {
            ChunkStorageExceptionHandler.handleHealthCheckException("ChunkStorageCore", e);
            return false;
        }
    }

    public void createBackup(String backupPath) {
        if (!this.enabled) {
            return;
        }
        try {
            LOGGER.info("Creating backup at '{ }'", (Object)backupPath);
            this.database.createBackup(backupPath);
            LOGGER.info("Backup completed");
        }
        catch (Exception e) {
            ChunkStorageExceptionHandler.handleBackupException("ChunkStorageCore", backupPath, e);
        }
    }

    public void performMaintenance() {
        if (!this.enabled) {
            return;
        }
        try {
            LOGGER.info("Performing storage maintenance");
            this.database.performMaintenance();
            this.cache.resetStats();
            LOGGER.info("Storage maintenance completed");
        }
        catch (Exception e) {
            ChunkStorageExceptionHandler.handleMaintenanceException("ChunkStorageCore", e);
        }
    }

    public void clearCache() {
        if (!this.enabled) {
            return;
        }
        this.cache.clear();
    }

    public void close() {
        if (!this.enabled) {
            return;
        }
        try {
            LOGGER.info("Closing ChunkStorageCore");
            this.database.close();
            this.cache.clear();
            LOGGER.info("ChunkStorageCore closed");
        }
        catch (Exception e) {
            ChunkStorageExceptionHandler.handleShutdownException("ChunkStorageCore", e);
        }
    }

    public Object getCacheStats() {
        return this.cache != null ? this.cache.getStats() : null;
    }

    public Object getDatabaseStats() {
        try {
            return this.database != null ? this.database.getStats() : null;
        }
        catch (Exception e) {
            ChunkStorageExceptionHandler.handleStatsException("ChunkStorageCore", e, null);
            return null;
        }
    }

    public SwapManager getSwapManager() {
        return this.swapManager;
    }

    public Object getSwapStats() {
        if (this.swapManager == null) {
            return null;
        }
        return this.swapManager.getStats();
    }

    public ChunkSerializer getSerializer() {
        return this.serializer;
    }

    public DatabaseAdapter getDatabase() {
        return this.database;
    }

    public ChunkCache getCache() {
        return this.cache;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

