/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.data.entity;

import com.kneaf.core.data.core.DataValidationException;
import com.kneaf.core.data.entity.BaseEntityData;
import java.util.List;

public abstract class BaseInventoryEntityData
extends BaseEntityData {
    protected final List<String> inventoryItems;
    protected final int inventorySize;
    protected final boolean hasInventorySpace;

    protected BaseInventoryEntityData(long id, double x, double y, double z, String entityType, List<String> inventoryItems, int inventorySize, boolean hasInventorySpace) {
        super(id, x, y, z, entityType);
        this.inventoryItems = inventoryItems != null ? List.copyOf(inventoryItems) : List.of();
        this.inventorySize = inventorySize;
        this.hasInventorySpace = hasInventorySpace;
    }

    public List<String> getInventoryItems() {
        return this.inventoryItems;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public boolean hasInventorySpace() {
        return this.hasInventorySpace;
    }

    public int getItemCount() {
        return this.inventoryItems.size();
    }

    public boolean isInventoryEmpty() {
        return this.inventoryItems.isEmpty();
    }

    public boolean isInventoryFull() {
        return !this.hasInventorySpace;
    }

    public double getInventoryUtilization() {
        return this.inventorySize > 0 ? (double)this.inventoryItems.size() / (double)this.inventorySize : 0.0;
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.inventorySize < 0) {
            throw new DataValidationException("inventorySize", this.inventorySize, "Inventory size must not be negative");
        }
        if (this.inventoryItems.size() > this.inventorySize) {
            throw new DataValidationException("inventoryItems", this.inventoryItems.size(), String.format("Item count (%d) cannot exceed inventory size (%d)", this.inventoryItems.size(), this.inventorySize));
        }
        return true;
    }
}

