/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions;

import com.kneaf.core.exceptions.core.KneafCoreException;
import com.kneaf.core.exceptions.utils.ExceptionContext;

@Deprecated
public class KneafCoreException
extends RuntimeException {
    private final com.kneaf.core.exceptions.core.KneafCoreException delegate;

    public KneafCoreException(ErrorCategory category, String message) {
        super(message);
        this.delegate = ((KneafCoreException.Builder)com.kneaf.core.exceptions.core.KneafCoreException.builder().category(KneafCoreException.convertCategory(category)).message(message)).build();
    }

    public KneafCoreException(ErrorCategory category, String message, Throwable cause) {
        super(message, cause);
        this.delegate = ((KneafCoreException.Builder)((KneafCoreException.Builder)com.kneaf.core.exceptions.core.KneafCoreException.builder().category(KneafCoreException.convertCategory(category)).message(message)).cause(cause)).build();
    }

    public KneafCoreException(ErrorCategory category, String operation, String message, Throwable cause) {
        super(KneafCoreException.formatMessage(category, operation, message), cause);
        this.delegate = ((KneafCoreException.Builder)((KneafCoreException.Builder)com.kneaf.core.exceptions.core.KneafCoreException.builder().category(KneafCoreException.convertCategory(category)).operation(operation).message(message)).cause(cause)).build();
    }

    public KneafCoreException(ErrorCategory category, String operation, String message, Object context, Throwable cause) {
        super(KneafCoreException.formatMessage(category, operation, message), cause);
        this.delegate = ((KneafCoreException.Builder)((KneafCoreException.Builder)((KneafCoreException.Builder)com.kneaf.core.exceptions.core.KneafCoreException.builder().category(KneafCoreException.convertCategory(category)).operation(operation).message(message)).context(context != null ? ExceptionContext.basic(operation, category.name()) : null)).cause(cause)).build();
    }

    public ErrorCategory getCategory() {
        return KneafCoreException.convertCategoryBack(this.delegate.getCategory());
    }

    public String getOperation() {
        return this.delegate.getOperation();
    }

    public Object getContext() {
        ExceptionContext context = this.delegate.getContext();
        return context != null ? context.getContextData() : null;
    }

    public com.kneaf.core.exceptions.core.KneafCoreException getDelegate() {
        return this.delegate;
    }

    private static KneafCoreException.ErrorCategory convertCategory(ErrorCategory category) {
        if (category == null) {
            return null;
        }
        switch (category.ordinal()) {
            case 0: {
                return KneafCoreException.ErrorCategory.DATABASE_OPERATION;
            }
            case 1: {
                return KneafCoreException.ErrorCategory.NATIVE_LIBRARY;
            }
            case 2: {
                return KneafCoreException.ErrorCategory.ASYNC_PROCESSING;
            }
            case 3: {
                return KneafCoreException.ErrorCategory.CONFIGURATION;
            }
            case 4: {
                return KneafCoreException.ErrorCategory.RESOURCE_MANAGEMENT;
            }
            case 5: {
                return KneafCoreException.ErrorCategory.PROTOCOL_ERROR;
            }
            case 6: {
                return KneafCoreException.ErrorCategory.VALIDATION_ERROR;
            }
            case 7: {
                return KneafCoreException.ErrorCategory.SYSTEM_ERROR;
            }
        }
        return KneafCoreException.ErrorCategory.SYSTEM_ERROR;
    }

    private static ErrorCategory convertCategoryBack(KneafCoreException.ErrorCategory category) {
        if (category == null) {
            return null;
        }
        switch (category) {
            case DATABASE_OPERATION: {
                return ErrorCategory.DATABASE_OPERATION;
            }
            case NATIVE_LIBRARY: {
                return ErrorCategory.NATIVE_LIBRARY;
            }
            case ASYNC_PROCESSING: {
                return ErrorCategory.ASYNC_PROCESSING;
            }
            case CONFIGURATION: {
                return ErrorCategory.CONFIGURATION;
            }
            case RESOURCE_MANAGEMENT: {
                return ErrorCategory.RESOURCE_MANAGEMENT;
            }
            case PROTOCOL_ERROR: {
                return ErrorCategory.PROTOCOL_ERROR;
            }
            case VALIDATION_ERROR: {
                return ErrorCategory.VALIDATION_ERROR;
            }
            case SYSTEM_ERROR: {
                return ErrorCategory.SYSTEM_ERROR;
            }
        }
        return ErrorCategory.SYSTEM_ERROR;
    }

    private static String formatMessage(ErrorCategory category, String operation, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(category.name()).append("] ");
        if (operation != null) {
            sb.append("Operation '").append(operation).append("': ");
        }
        sb.append(message);
        return sb.toString();
    }

    public static enum ErrorCategory {
        DATABASE_OPERATION("Database operation failed"),
        NATIVE_LIBRARY("Native library error"),
        ASYNC_PROCESSING("Async processing error"),
        CONFIGURATION("Configuration error"),
        RESOURCE_MANAGEMENT("Resource management error"),
        PROTOCOL_ERROR("Protocol error"),
        VALIDATION_ERROR("Validation error"),
        SYSTEM_ERROR("System error");

        private final String description;

        private ErrorCategory(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

