/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions.utils;

public enum ExceptionSeverity {
    CRITICAL(1, "CRITICAL", "System critical error - immediate attention required"),
    ERROR(2, "ERROR", "Operation failed - requires attention"),
    WARNING(3, "WARNING", "Potential issue detected - monitor required"),
    INFO(4, "INFO", "Informational message - for debugging purposes"),
    DEBUG(5, "DEBUG", "Debug information - detailed troubleshooting");

    private final int level;
    private final String name;
    private final String description;

    private ExceptionSeverity(int level, String name, String description) {
        this.level = level;
        this.name = name;
        this.description = description;
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isMoreSevereThan(ExceptionSeverity other) {
        return this.level < other.level;
    }

    public boolean isAtLeast(ExceptionSeverity other) {
        return this.level <= other.level;
    }

    public static ExceptionSeverity getMostSevere(ExceptionSeverity ... severities) {
        if (severities == null || severities.length == 0) {
            return INFO;
        }
        ExceptionSeverity mostSevere = severities[0];
        for (int i = 1; i < severities.length; ++i) {
            if (!severities[i].isMoreSevereThan(mostSevere)) continue;
            mostSevere = severities[i];
        }
        return mostSevere;
    }
}

