/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.slf4j.Logger;

public final class NetworkHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation PERFORMANCE_CHANNEL = ResourceLocation.parse((String)"kneafcore:perf_overlay");

    private NetworkHandler() {
    }

    public static void register() {
    }

    public static void sendPerformanceLineToPlayer(ServerPlayer player, String line) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeUtf(line);
        try {
            Class<?> pktClass = Class.forName("net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket");
            try {
                Constructor<?> ctor = pktClass.getConstructor(ResourceLocation.class, FriendlyByteBuf.class);
                Object pkt = ctor.newInstance(PERFORMANCE_CHANNEL, buf);
                ServerGamePacketListenerImpl connection = player.connection;
                if (connection != null) {
                    Method m = connection.getClass().getMethod("send", Object.class);
                    m.invoke((Object)connection, pkt);
                    return;
                }
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Constructor<?> ctor2 = pktClass.getConstructor(String.class, FriendlyByteBuf.class);
                    Object pkt = ctor2.newInstance(PERFORMANCE_CHANNEL.toString(), buf);
                    ServerGamePacketListenerImpl connection = player.connection;
                    if (connection != null) {
                        Method m = connection.getClass().getMethod("send", Object.class);
                        m.invoke((Object)connection, pkt);
                        return;
                    }
                }
                catch (Exception ex2) {
                    LOGGER.debug("Packet constructor mismatch for ClientboundCustomPayloadPacket: { }", (Object)ex2.getMessage());
                }
            }
        }
        catch (ClassNotFoundException pktClass) {
        }
        catch (Exception e) {
            LOGGER.debug("Reflection send error when sending performance payload to { }: { }", (Object)player.getGameProfile().getName(), (Object)e.getMessage());
        }
        try {
            player.displayClientMessage((Component)Component.literal((String)line), false);
        }
        catch (Exception ex) {
            LOGGER.debug("Failed to fallback-send performance line to { }: { }", (Object)player.getGameProfile().getName(), (Object)ex.getMessage());
        }
    }

    public static void broadcastPerformanceLine(MinecraftServer server, String line) {
        if (server == null) {
            return;
        }
        try {
            for (ServerLevel level : server.getAllLevels()) {
                for (ServerPlayer player : level.players()) {
                    NetworkHandler.sendPerformanceLineToPlayer(player, line);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to broadcast performance payload to players: { }", (Object)e.getMessage());
        }
    }
}

