/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import com.kneaf.core.performance.RustPerformance;
import com.kneaf.core.performance.core.PerformanceConstants;
import com.kneaf.core.performance.monitoring.PerformanceManager;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class NativeFloatBuffer
implements AutoCloseable {
    private static final Cleaner CLEANER = Cleaner.create();
    private static final int BUCKET_SIZE_POWER = 12;
    private static final ConcurrentHashMap<Integer, ConcurrentLinkedQueue<PooledBuffer>> BUFFER_POOLS;
    private static final ConcurrentHashMap<Integer, AtomicInteger> POOL_SIZES;
    private static final AtomicLong LAST_CLEANUP_TIME;
    private static final AtomicLong TOTAL_ALLOCATIONS;
    private static final AtomicLong TOTAL_REUSES;
    private static final AtomicLong TOTAL_FREES;
    private final ByteBuffer buf;
    private final FloatBuffer view;
    private final long rows;
    private final long cols;
    private final long elementCount;
    private final int byteCapacity;
    private final Cleaner.Cleanable cleanable;
    private volatile boolean closed = false;
    private final boolean isPooled;
    private final int bucketIndex;

    private static double getSafeTPS() {
        try {
            Class.forName("net.minecraft.network.chat.Component");
            return PerformanceManager.getAverageTPS();
        }
        catch (ClassNotFoundException e) {
            return 20.0;
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    private NativeFloatBuffer(ByteBuffer buf, long rows, long cols, boolean isPooled, int bucketIndex) {
        if (buf == null) {
            throw new IllegalArgumentException("buf must not be null");
        }
        if (rows < 0L || cols < 0L) {
            throw new IllegalArgumentException("rows/cols must be non-negative");
        }
        this.buf = buf.order(ByteOrder.LITTLE_ENDIAN);
        this.rows = rows;
        this.cols = cols;
        this.elementCount = rows * cols;
        this.byteCapacity = this.buf.capacity();
        this.view = this.buf.asFloatBuffer();
        this.cleanable = CLEANER.register(this, new State(this.buf, isPooled, bucketIndex));
        this.isPooled = isPooled;
        this.bucketIndex = bucketIndex;
    }

    private static int getBucketIndex(int byteCapacity) {
        int bucket = 0;
        double tps = NativeFloatBuffer.getSafeTPS();
        int maxBucket = PerformanceConstants.getAdaptiveMaxBucketSize(tps);
        for (int size = 4096; size < byteCapacity && bucket < maxBucket; size <<= 1, ++bucket) {
        }
        return bucket;
    }

    private static PooledBuffer getFromPool(int byteCapacity) {
        int bucketIndex = NativeFloatBuffer.getBucketIndex(byteCapacity);
        ConcurrentLinkedQueue<PooledBuffer> pool = BUFFER_POOLS.get(bucketIndex);
        if (pool != null) {
            PooledBuffer pooled = pool.poll();
            while (pooled != null) {
                if (pooled.buffer != null && pooled.buffer.capacity() >= byteCapacity) {
                    POOL_SIZES.get(bucketIndex).decrementAndGet();
                    TOTAL_REUSES.incrementAndGet();
                    return pooled;
                }
                pooled = pool.poll();
                if (pooled == null) continue;
                POOL_SIZES.get(bucketIndex).decrementAndGet();
            }
        }
        int maxBucket = PerformanceConstants.getAdaptiveMaxBucketSize(NativeFloatBuffer.getSafeTPS());
        for (int i = bucketIndex + 1; i <= maxBucket; ++i) {
            pool = BUFFER_POOLS.get(i);
            if (pool == null) continue;
            PooledBuffer pooled = pool.poll();
            while (pooled != null) {
                if (pooled.buffer != null && pooled.buffer.capacity() >= byteCapacity) {
                    POOL_SIZES.get(i).decrementAndGet();
                    TOTAL_REUSES.incrementAndGet();
                    return pooled;
                }
                pooled = pool.poll();
                if (pooled == null) continue;
                POOL_SIZES.get(i).decrementAndGet();
            }
        }
        return null;
    }

    private static void performCleanup() {
        ArrayList<Integer> emptyBuckets = new ArrayList<Integer>();
        for (Map.Entry<Integer, ConcurrentLinkedQueue<PooledBuffer>> entry : BUFFER_POOLS.entrySet()) {
            int remaining;
            int bucketIndex = entry.getKey();
            ConcurrentLinkedQueue<PooledBuffer> pool = entry.getValue();
            AtomicInteger size = POOL_SIZES.get(bucketIndex);
            if (pool == null || size == null || (remaining = NativeFloatBuffer.cleanupBucket(pool, size)) != 0) continue;
            emptyBuckets.add(bucketIndex);
        }
        for (Integer bucketIndex : emptyBuckets) {
            BUFFER_POOLS.remove(bucketIndex);
            POOL_SIZES.remove(bucketIndex);
        }
    }

    private static int cleanupBucket(ConcurrentLinkedQueue<PooledBuffer> pool, AtomicInteger size) {
        PooledBuffer pooled;
        int maxPerBucket = PerformanceConstants.getAdaptiveMaxPoolPerBucket(NativeFloatBuffer.getSafeTPS());
        int targetSize = maxPerBucket / 2;
        int currentSize = size.get();
        while (currentSize > targetSize && (pooled = pool.poll()) != null) {
            try {
                RustPerformance.freeFloatBufferNative(pooled.buffer);
                TOTAL_FREES.incrementAndGet();
                size.decrementAndGet();
                --currentSize;
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Native library not available during cleanup: " + e.getMessage());
                size.decrementAndGet();
                --currentSize;
            }
            catch (Exception e) {
                System.err.println("Error freeing native buffer during cleanup: " + e.getMessage());
            }
        }
        return currentSize;
    }

    public static void preallocateBuffers() {
        int[] commonSizes = new int[]{4096, 16384, 65536, 262144, 0x100000};
        int prefetch = PerformanceConstants.getAdaptivePrefetchCount(NativeFloatBuffer.getSafeTPS());
        int maxPerBucket = PerformanceConstants.getAdaptiveMaxPoolPerBucket(NativeFloatBuffer.getSafeTPS());
        for (int size : commonSizes) {
            int bucketIndex = NativeFloatBuffer.getBucketIndex(size);
            int preallocateCount = Math.min(prefetch, maxPerBucket / 2);
            for (int i = 0; i < preallocateCount; ++i) {
                try {
                    ByteBuffer buffer = RustPerformance.generateFloatBufferNative(size / 4, 1);
                    if (buffer == null) continue;
                    PooledBuffer pooled = new PooledBuffer(buffer, bucketIndex);
                    BUFFER_POOLS.computeIfAbsent(bucketIndex, k -> new ConcurrentLinkedQueue()).offer(pooled);
                    POOL_SIZES.computeIfAbsent(bucketIndex, k -> new AtomicInteger(0)).incrementAndGet();
                    TOTAL_ALLOCATIONS.incrementAndGet();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static NativeFloatBuffer allocateFromNative(long rows, long cols) {
        return NativeFloatBuffer.allocateFromNative(rows, cols, true);
    }

    /*
     * Exception decompiling
     */
    public static NativeFloatBuffer allocateFromNative(long rows, long cols, boolean usePool) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 6[CATCHBLOCK], 5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ByteBuffer buffer() {
        if (this.closed) {
            throw new IllegalStateException("NativeFloatBuffer is closed");
        }
        return this.buf;
    }

    public float getFloatAtIndex(int idx) {
        return this.view.get(idx);
    }

    public void setFloatAtIndex(int idx, float val) {
        this.view.put(idx, val);
    }

    public FloatBuffer asFloatBuffer() {
        this.checkOpen();
        return this.view.duplicate();
    }

    public FloatBuffer rowBuffer(int row) {
        this.checkOpen();
        if (row < 0 || (long)row >= this.rows) {
            throw new IndexOutOfBoundsException("row out of range");
        }
        int start = (int)((long)row * this.cols);
        FloatBuffer dup = this.view.duplicate();
        dup.position(start);
        dup.limit(start + (int)this.cols);
        return dup.slice();
    }

    public FloatBuffer colBuffer(int col) {
        this.checkOpen();
        if (col < 0 || (long)col >= this.cols) {
            throw new IndexOutOfBoundsException("col out of range");
        }
        int rCount = (int)this.rows;
        float[] tmp = new float[rCount];
        int base = col;
        int c = (int)this.cols;
        for (int r = 0; r < rCount; ++r) {
            tmp[r] = this.view.get(base + r * c);
        }
        return FloatBuffer.wrap(tmp);
    }

    public void fill(float value) {
        this.checkOpen();
        int cap = this.view.capacity();
        if (cap > 1000) {
            int chunkSize = Math.min(cap, 10000);
            float[] chunk = new float[chunkSize];
            Arrays.fill(chunk, value);
            for (int i = 0; i < cap; i += chunkSize) {
                int remaining = Math.min(chunkSize, cap - i);
                this.view.position(i);
                this.view.put(chunk, 0, remaining);
            }
            this.view.position(0);
        } else {
            for (int i = 0; i < cap; ++i) {
                this.view.put(i, value);
            }
        }
    }

    public void copyTo(NativeFloatBuffer dest) {
        this.checkOpen();
        if (dest == null) {
            throw new IllegalArgumentException("dest is null");
        }
        if (dest.getElementCount() != this.getElementCount()) {
            throw new IllegalArgumentException("shape mismatch");
        }
        FloatBuffer s = this.asFloatBuffer();
        FloatBuffer d = dest.asFloatBuffer();
        d.position(0);
        s.position(0);
        d.put(s);
    }

    public float getFloatAt(long row, long col) {
        this.checkOpen();
        this.checkBounds(row, col);
        int idx = (int)(row * this.cols + col);
        return this.view.get(idx);
    }

    public void setFloatAt(long row, long col, float val) {
        this.checkOpen();
        this.checkBounds(row, col);
        int idx = (int)(row * this.cols + col);
        this.view.put(idx, val);
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("NativeFloatBuffer is closed");
        }
    }

    private void checkBounds(long row, long col) {
        if (row < 0L || col < 0L || row >= this.rows || col >= this.cols) {
            throw new IndexOutOfBoundsException("row/col out of range");
        }
    }

    public long getRows() {
        return this.rows;
    }

    public long getCols() {
        return this.cols;
    }

    public long getElementCount() {
        return this.elementCount;
    }

    public int getByteCapacity() {
        return this.byteCapacity;
    }

    public static String getPoolStats() {
        StringBuilder Stats = new StringBuilder();
        Stats.append("Buffer Pool Statistics:\n");
        Stats.append("Total Allocations: ").append(TOTAL_ALLOCATIONS.get()).append("\n");
        Stats.append("Total Reuses: ").append(TOTAL_REUSES.get()).append("\n");
        Stats.append("Total Frees: ").append(TOTAL_FREES.get()).append("\n");
        Stats.append("Reuse Rate: ").append(String.format("%.2f%%", TOTAL_ALLOCATIONS.get() > 0L ? 100.0 * (double)TOTAL_REUSES.get() / (double)TOTAL_ALLOCATIONS.get() : 0.0)).append("\n");
        Stats.append("Pool Buckets:\n");
        for (Integer bucketIndex : BUFFER_POOLS.keySet()) {
            AtomicInteger size = POOL_SIZES.get(bucketIndex);
            int bucketSize = size != null ? size.get() : 0;
            int bucketByteSize = 1 << 12 + bucketIndex;
            Stats.append("  Bucket ").append(bucketIndex).append(" (").append(bucketByteSize).append(" bytes): ").append(bucketSize).append(" buffers\n");
        }
        return Stats.toString();
    }

    public static void forceCleanup() {
        NativeFloatBuffer.performCleanup();
    }

    public static void clearPools() {
        for (Map.Entry<Integer, ConcurrentLinkedQueue<PooledBuffer>> entry : BUFFER_POOLS.entrySet()) {
            PooledBuffer pooled;
            ConcurrentLinkedQueue<PooledBuffer> pool = entry.getValue();
            if (pool == null) continue;
            while ((pooled = pool.poll()) != null) {
                try {
                    RustPerformance.freeFloatBufferNative(pooled.buffer);
                    TOTAL_FREES.incrementAndGet();
                }
                catch (UnsatisfiedLinkError e) {
                    System.err.println("Native library not available during pool clear: " + e.getMessage());
                }
                catch (Exception e) {
                    System.err.println("Error freeing native buffer during pool clear: " + e.getMessage());
                }
            }
        }
        BUFFER_POOLS.clear();
        POOL_SIZES.clear();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.cleanable.clean();
        }
    }

    static {
        try {
            Class.forName("com.kneaf.core.performance.RustPerformance");
        }
        catch (ClassNotFoundException e) {
            System.err.println("RustPerformance class not found, native float buffer operations may fail");
        }
        catch (ExceptionInInitializerError e) {
            System.err.println("RustPerformance initialization failed, native float buffer operations disabled: " + e.getMessage());
        }
        catch (Throwable t) {
            System.err.println("Unexpected error during NativeFloatBuffer static initialization: " + t.getMessage());
        }
        BUFFER_POOLS = new ConcurrentHashMap();
        POOL_SIZES = new ConcurrentHashMap();
        LAST_CLEANUP_TIME = new AtomicLong(System.currentTimeMillis());
        TOTAL_ALLOCATIONS = new AtomicLong(0L);
        TOTAL_REUSES = new AtomicLong(0L);
        TOTAL_FREES = new AtomicLong(0L);
    }

    private static final class State
    implements Runnable {
        private final ByteBuffer buf;
        private final boolean isPooled;
        private final int bucketIndex;

        State(ByteBuffer buf, boolean isPooled, int bucketIndex) {
            this.buf = buf;
            this.isPooled = isPooled;
            this.bucketIndex = bucketIndex;
        }

        private void returnToPool() {
            BUFFER_POOLS.computeIfAbsent(this.bucketIndex, k -> new ConcurrentLinkedQueue());
            POOL_SIZES.computeIfAbsent(this.bucketIndex, k -> new AtomicInteger(0));
            int currentSize = POOL_SIZES.get(this.bucketIndex).get();
            int maxPerBucket = PerformanceConstants.getAdaptiveMaxPoolPerBucket(NativeFloatBuffer.getSafeTPS());
            if (currentSize < maxPerBucket) {
                PooledBuffer pooled = new PooledBuffer(this.buf, this.bucketIndex);
                BUFFER_POOLS.get(this.bucketIndex).offer(pooled);
                POOL_SIZES.get(this.bucketIndex).incrementAndGet();
            } else {
                this.freeBuffer();
            }
            long now = System.currentTimeMillis();
            long lastCleanup = LAST_CLEANUP_TIME.get();
            long interval = PerformanceConstants.getAdaptiveBufferCleanupIntervalMs(NativeFloatBuffer.getSafeTPS());
            if (now - lastCleanup > interval && LAST_CLEANUP_TIME.compareAndSet(lastCleanup, now)) {
                NativeFloatBuffer.performCleanup();
            }
        }

        private void freeBuffer() {
            try {
                RustPerformance.freeFloatBufferNative(this.buf);
                TOTAL_FREES.incrementAndGet();
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Native library not available for buffer free: " + e.getMessage());
            }
            catch (Exception e) {
                System.err.println("Error freeing native buffer: " + e.getMessage());
            }
        }

        @Override
        public void run() {
            try {
                if (this.buf != null) {
                    if (this.isPooled && this.bucketIndex >= 0) {
                        this.returnToPool();
                    } else {
                        this.freeBuffer();
                    }
                }
            }
            catch (Exception t) {
                System.err.println("Error during buffer cleanup: " + t.getMessage());
            }
        }
    }

    private static final class PooledBuffer {
        final ByteBuffer buffer;
        final int bucketIndex;

        PooledBuffer(ByteBuffer buffer, int bucketIndex) {
            this.buffer = buffer;
            this.bucketIndex = bucketIndex;
        }
    }
}

