/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public final class NativeFloatBufferAllocation {
    private static final int INITIAL_POOL_SIZE = 16;
    private static final int MAX_POOL_SIZE = 128;
    private static final double MEMORY_PRESSURE_THRESHOLD = 0.8;
    private static final double ADAPTIVE_GROWTH_FACTOR = 1.5;
    private static final double ADAPTIVE_SHRINK_FACTOR = 0.75;
    private static final LinkedHashMap<BufferKey, PooledBuffer> bufferPool = new LinkedHashMap<BufferKey, PooledBuffer>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<BufferKey, PooledBuffer> eldest) {
            return (long)this.size() > currentMaxPoolSize.get();
        }
    };
    private static final AtomicLong currentMaxPoolSize = new AtomicLong(16L);
    private static final AtomicLong totalAllocations = new AtomicLong(0L);
    private static final AtomicLong poolHits = new AtomicLong(0L);
    private static final AtomicLong poolMisses = new AtomicLong(0L);
    private static final Runtime runtime = Runtime.getRuntime();
    private static final ReentrantLock poolLock = new ReentrantLock();
    private final ByteBuffer buffer;
    private final long rows;
    private final long cols;
    private final boolean fromPool;
    private final BufferKey key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeFloatBufferAllocation allocate(long rows, long cols) {
        BufferKey key = new BufferKey(rows, cols);
        long bufferSize = rows * cols * 4L;
        poolLock.lock();
        try {
            PooledBuffer pooled;
            if (NativeFloatBufferAllocation.isMemoryPressureHigh()) {
                NativeFloatBufferAllocation.performEviction();
            }
            if ((pooled = bufferPool.get(key)) != null && pooled.isValid()) {
                poolHits.incrementAndGet();
                pooled.markUsed();
                NativeFloatBufferAllocation nativeFloatBufferAllocation = new NativeFloatBufferAllocation(pooled.getBuffer(), rows, cols, true, key);
                return nativeFloatBufferAllocation;
            }
            poolMisses.incrementAndGet();
            totalAllocations.incrementAndGet();
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)bufferSize);
            NativeFloatBufferAllocation.adaptPoolSize();
            NativeFloatBufferAllocation nativeFloatBufferAllocation = new NativeFloatBufferAllocation(buffer, rows, cols, false, key);
            return nativeFloatBufferAllocation;
        }
        finally {
            poolLock.unlock();
        }
    }

    public NativeFloatBufferAllocation(ByteBuffer buffer, long rows, long cols) {
        this(buffer, rows, cols, false, null);
    }

    private NativeFloatBufferAllocation(ByteBuffer buffer, long rows, long cols, boolean fromPool, BufferKey key) {
        this.buffer = buffer;
        this.rows = rows;
        this.cols = cols;
        this.fromPool = fromPool;
        this.key = key;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public long getRows() {
        return this.rows;
    }

    public long getCols() {
        return this.cols;
    }

    public void release() {
        if (this.fromPool && this.key != null) {
            poolLock.lock();
            try {
                this.buffer.clear();
                if (!bufferPool.containsKey(this.key)) {
                    bufferPool.put(this.key, new PooledBuffer(this.buffer, System.nanoTime()));
                }
            }
            finally {
                poolLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PoolStats getPoolStats() {
        poolLock.lock();
        try {
            long totalRequests = poolHits.get() + poolMisses.get();
            double hitRate = totalRequests > 0L ? (double)poolHits.get() / (double)totalRequests : 0.0;
            PoolStats poolStats = new PoolStats(bufferPool.size(), currentMaxPoolSize.get(), totalAllocations.get(), hitRate, NativeFloatBufferAllocation.getMemoryPressureLevel());
            return poolStats;
        }
        finally {
            poolLock.unlock();
        }
    }

    private static boolean isMemoryPressureHigh() {
        long maxMemory;
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        return (double)usedMemory / (double)(maxMemory = runtime.maxMemory()) > 0.8;
    }

    private static void performEviction() {
        int evicted = 0;
        while (NativeFloatBufferAllocation.isMemoryPressureHigh() && !bufferPool.isEmpty()) {
            BufferKey eldestKey = bufferPool.keySet().iterator().next();
            bufferPool.remove(eldestKey);
            ++evicted;
        }
        if (evicted > 0) {
            long newSize = Math.max(16L, (long)((double)currentMaxPoolSize.get() * 0.75));
            currentMaxPoolSize.set(newSize);
        }
    }

    private static void adaptPoolSize() {
        long totalRequests = poolHits.get() + poolMisses.get();
        if (totalRequests >= 100L) {
            double hitRate = (double)poolHits.get() / (double)totalRequests;
            if (hitRate > 0.7 && currentMaxPoolSize.get() < 128L) {
                long newSize = Math.min(128L, (long)((double)currentMaxPoolSize.get() * 1.5));
                currentMaxPoolSize.set(newSize);
            } else if (hitRate < 0.3 && currentMaxPoolSize.get() > 16L) {
                long newSize = Math.max(16L, (long)((double)currentMaxPoolSize.get() * 0.75));
                currentMaxPoolSize.set(newSize);
            }
        }
    }

    private static MemoryPressureLevel getMemoryPressureLevel() {
        long maxMemory;
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        double ratio = (double)usedMemory / (double)(maxMemory = runtime.maxMemory());
        if (ratio < 0.6) {
            return MemoryPressureLevel.LOW;
        }
        if (ratio < 0.8) {
            return MemoryPressureLevel.MODERATE;
        }
        if (ratio < 0.9) {
            return MemoryPressureLevel.HIGH;
        }
        return MemoryPressureLevel.CRITICAL;
    }

    private static class BufferKey {
        final long rows;
        final long cols;

        BufferKey(long rows, long cols) {
            this.rows = rows;
            this.cols = cols;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BufferKey)) {
                return false;
            }
            BufferKey that = (BufferKey)o;
            return this.rows == that.rows && this.cols == that.cols;
        }

        public int hashCode() {
            return Long.hashCode(this.rows) * 31 + Long.hashCode(this.cols);
        }
    }

    private static class PooledBuffer {
        private final ByteBuffer buffer;
        private final long creationTime;
        private volatile long lastUsedTime;

        PooledBuffer(ByteBuffer buffer, long creationTime) {
            this.buffer = buffer;
            this.creationTime = creationTime;
            this.lastUsedTime = creationTime;
        }

        ByteBuffer getBuffer() {
            this.markUsed();
            return this.buffer;
        }

        void markUsed() {
            this.lastUsedTime = System.nanoTime();
        }

        boolean isValid() {
            return this.buffer != null && this.buffer.isDirect();
        }
    }

    public static class PoolStats {
        public final int currentSize;
        public final long maxSize;
        public final long totalAllocations;
        public final double hitRate;
        public final MemoryPressureLevel memoryPressure;

        PoolStats(int currentSize, long maxSize, long totalAllocations, double hitRate, MemoryPressureLevel memoryPressure) {
            this.currentSize = currentSize;
            this.maxSize = maxSize;
            this.totalAllocations = totalAllocations;
            this.hitRate = hitRate;
            this.memoryPressure = memoryPressure;
        }
    }

    public static enum MemoryPressureLevel {
        LOW,
        MODERATE,
        HIGH,
        CRITICAL;

    }
}

