/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.commands;

import com.kneaf.core.protocol.core.CommandExecutor;
import com.kneaf.core.protocol.core.ProtocolException;
import com.kneaf.core.protocol.core.ProtocolLogger;
import com.kneaf.core.protocol.utils.ProtocolLoggerImpl;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;

public abstract class BaseCommand
implements CommandExecutor {
    protected final ProtocolLogger logger;
    private final String commandName;
    private final String description;
    private final int requiredPermissionLevel;
    private final String usage;

    protected BaseCommand(String commandName, String description, int requiredPermissionLevel, String usage) {
        this.commandName = commandName;
        this.description = description;
        this.requiredPermissionLevel = requiredPermissionLevel;
        this.usage = usage;
        this.logger = new ProtocolLoggerImpl("Command:" + commandName);
    }

    protected BaseCommand(String commandName, String description, int requiredPermissionLevel, String usage, ProtocolLogger logger) {
        this.commandName = commandName;
        this.description = description;
        this.requiredPermissionLevel = requiredPermissionLevel;
        this.usage = usage;
        this.logger = logger;
    }

    @Override
    public final int execute(CommandContext<CommandSourceStack> context) {
        String traceId = this.logger.generateTraceId();
        String sourceName = ((CommandSourceStack)context.getSource()).getTextName();
        long startTime = System.currentTimeMillis();
        try {
            this.logger.logOperationStart("command_execute", "command", traceId, Map.of("command", this.commandName, "source", sourceName));
            if (!this.validateArguments(context)) {
                String errorMsg = "Invalid arguments for command: " + this.commandName;
                this.logger.logWarning("command_execute", errorMsg, traceId, Map.of("command", this.commandName, "source", sourceName));
                return this.handleError(context, new IllegalArgumentException(errorMsg));
            }
            int result = this.executeCommand(context);
            long duration = System.currentTimeMillis() - startTime;
            this.logger.logOperationComplete("command_execute", "command", traceId, duration, result > 0, Map.of("command", this.commandName, "result", result, "source", sourceName));
            return result;
        }
        catch (Exception e) {
            long duration = System.currentTimeMillis() - startTime;
            this.logger.logError("command_execute", e, traceId, Map.of("command", this.commandName, "duration", duration, "source", sourceName));
            return this.handleError(context, e);
        }
    }

    protected abstract int executeCommand(CommandContext<CommandSourceStack> var1) throws Exception;

    @Override
    public boolean validateArguments(CommandContext<CommandSourceStack> context) {
        return true;
    }

    @Override
    public int handleError(CommandContext<CommandSourceStack> context, Exception error) {
        String errorMessage;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (error instanceof ProtocolException) {
            ProtocolException protocolError = (ProtocolException)error;
            errorMessage = String.format("\u00a7cCommand '%s' failed: %s (Error Code: %d)", this.commandName, protocolError.getMessage(), protocolError.getErrorCode());
        } else {
            errorMessage = error instanceof IllegalArgumentException ? String.format("\u00a7cInvalid arguments for command '%s': %s", this.commandName, error.getMessage()) : String.format("\u00a7cCommand '%s' failed: %s", this.commandName, error.getMessage());
        }
        source.sendFailure((Component)Component.literal((String)errorMessage));
        return 0;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getRequiredPermissionLevel() {
        return this.requiredPermissionLevel;
    }

    @Override
    public String getUsage() {
        return this.usage;
    }

    protected void sendSuccess(CommandContext<CommandSourceStack> context, String message) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)message), false);
    }

    protected void sendFailure(CommandContext<CommandSourceStack> context, String message) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)message));
    }

    protected void sendSuccessFormatted(CommandContext<CommandSourceStack> context, String format, Object ... args) {
        String message = String.format(format, args);
        this.sendSuccess(context, message);
    }

    protected void sendFailureFormatted(CommandContext<CommandSourceStack> context, String format, Object ... args) {
        String message = String.format(format, args);
        this.sendFailure(context, message);
    }

    protected ProtocolLogger getLogger() {
        return this.logger;
    }

    protected String createHelpMessage() {
        return String.format("\u00a76=== %s Command Help ===\n\u00a7bUsage: \u00a7f%s\n\u00a7bDescription: \u00a7f%s\n\u00a7bPermission Level: \u00a7f%d", this.commandName, this.usage, this.description, this.requiredPermissionLevel);
    }
}

