/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary.core;

import com.kneaf.core.binary.core.SerializationConstants;
import com.kneaf.core.binary.utils.SerializationException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static ByteBuffer createBuffer(int initialCapacity) {
        ByteBuffer buffer = ByteBuffer.allocate(initialCapacity);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    public static ByteBuffer wrapBuffer(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    public static ByteBuffer ensureCapacity(ByteBuffer buffer, int requiredBytes) {
        int currentPosition;
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        if (buffer.remaining() >= requiredBytes) {
            return buffer;
        }
        int currentCapacity = buffer.capacity();
        int newCapacity = Math.max(currentCapacity * 2, (currentPosition = buffer.position()) + requiredBytes);
        if (newCapacity > 0x1000000) {
            throw new SerializationException("Buffer size exceeds maximum allowed size: " + newCapacity);
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        newBuffer.order(buffer.order());
        buffer.flip();
        newBuffer.put(buffer);
        return newBuffer;
    }

    public static void writeString(ByteBuffer buffer, String str, Charset charset) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        if (str == null) {
            buffer.putInt(0);
            return;
        }
        byte[] bytes = str.getBytes(charset);
        if (bytes.length > 65536) {
            throw new SerializationException("String length exceeds maximum allowed: " + bytes.length);
        }
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }

    public static void writeString(ByteBuffer buffer, String str) {
        SerializationUtils.writeString(buffer, str, StandardCharsets.UTF_8);
    }

    public static String readString(ByteBuffer buffer, Charset charset) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        int length = buffer.getInt();
        if (length == 0) {
            return "";
        }
        if (length < 0 || length > 65536) {
            throw new SerializationException("Invalid string length: " + length);
        }
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes, charset);
    }

    public static String readString(ByteBuffer buffer) {
        return SerializationUtils.readString(buffer, StandardCharsets.UTF_8);
    }

    public static void writeBoolean(ByteBuffer buffer, boolean value) {
        buffer.put(value ? (byte)1 : 0);
    }

    public static boolean readBoolean(ByteBuffer buffer) {
        return buffer.get() != 0;
    }

    public static int calculateStringSize(String str, Charset charset) {
        if (str == null || str.isEmpty()) {
            return 4;
        }
        return 4 + str.getBytes(charset).length;
    }

    public static boolean validateBuffer(byte[] data) {
        if (data == null || data.length < 8) {
            return false;
        }
        for (int i = 0; i < SerializationConstants.MAGIC_HEADER.length; ++i) {
            if (data[i] == SerializationConstants.MAGIC_HEADER[i]) continue;
            return false;
        }
        return true;
    }

    public static void addHeader(ByteBuffer buffer) {
        if (buffer.position() < 8) {
            throw new SerializationException("Buffer too small for header");
        }
        int originalPosition = buffer.position();
        buffer.position(0);
        buffer.put(SerializationConstants.MAGIC_HEADER);
        buffer.putShort((short)1);
        buffer.putShort((short)0);
        buffer.position(originalPosition);
    }

    public static int getRemainingBytes(ByteBuffer buffer) {
        return buffer.remaining();
    }

    public static ByteBuffer flipForReading(ByteBuffer buffer) {
        return buffer.flip();
    }

    public static ByteBuffer compactForWriting(ByteBuffer buffer) {
        return buffer.compact();
    }
}

