/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary.mob;

import com.kneaf.core.binary.core.BaseBinarySerializer;
import com.kneaf.core.binary.core.SerializationUtils;
import com.kneaf.core.binary.mob.MobInput;
import com.kneaf.core.binary.utils.BufferPool;
import com.kneaf.core.binary.utils.SchemaValidator;
import com.kneaf.core.binary.utils.SerializationException;
import com.kneaf.core.data.entity.MobData;
import com.kneaf.core.performance.core.MobProcessResult;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MobSerializer
extends BaseBinarySerializer<MobInput, MobProcessResult> {
    public MobSerializer() {
        super("mob", "1.0.0");
    }

    public MobSerializer(BufferPool bufferPool) {
        super("mob", "1.0.0", bufferPool);
    }

    public MobSerializer(BufferPool bufferPool, SchemaValidator<MobInput> validator) {
        super("mob", "1.0.0", bufferPool, validator);
    }

    @Override
    protected void serializeToBufferInternal(MobInput input, ByteBuffer buffer) throws SerializationException {
        if (input == null) {
            throw new SerializationException("Mob input cannot be null", this.getSerializerType(), "serializeToBufferInternal");
        }
        try {
            buffer.putLong(input.tickCount);
            List<MobData> mobs = input.mobs;
            buffer.putInt(mobs.size());
            for (MobData mob : mobs) {
                this.writeMobData(buffer, mob);
            }
        }
        catch (Exception e) {
            throw new SerializationException("Failed to serialize mob input", e, this.getSerializerType(), "serializeToBufferInternal", buffer.array());
        }
    }

    @Override
    protected MobProcessResult deserializeFromBufferInternal(ByteBuffer buffer) throws SerializationException {
        try {
            long _tickCount = buffer.getLong();
            if (_tickCount == Long.MIN_VALUE) {
                throw new SerializationException("Invalid tick count", this.getSerializerType(), "deserializeFromBufferInternal");
            }
            int disableCount = buffer.getInt();
            if (disableCount < 0) {
                throw new SerializationException("Invalid disable count: " + disableCount, this.getSerializerType(), "deserializeFromBufferInternal");
            }
            ArrayList<Long> disableList = new ArrayList<Long>(disableCount);
            for (int i = 0; i < disableCount; ++i) {
                disableList.add(buffer.getLong());
            }
            int simplifyCount = buffer.getInt();
            if (simplifyCount < 0) {
                throw new SerializationException("Invalid simplify count: " + simplifyCount, this.getSerializerType(), "deserializeFromBufferInternal");
            }
            ArrayList<Long> simplifyList = new ArrayList<Long>(simplifyCount);
            for (int i = 0; i < simplifyCount; ++i) {
                simplifyList.add(buffer.getLong());
            }
            return new MobProcessResult(disableList, simplifyList);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to deserialize mob result", e, this.getSerializerType(), "deserializeFromBufferInternal", null);
        }
    }

    private void writeMobData(ByteBuffer buffer, MobData mob) {
        buffer.putLong(mob.getId());
        buffer.putFloat((float)mob.getDistance());
        SerializationUtils.writeBoolean(buffer, mob.isPassive());
        SerializationUtils.writeString(buffer, mob.getType());
    }
}

