/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class BufferPool {
    private final ConcurrentLinkedQueue<ByteBuffer> availableBuffers;
    private final AtomicInteger activeCount;
    private final AtomicInteger totalCreated;
    private final int maxpoolSize;
    private final int bufferSize;
    private final ReentrantLock creationLock;

    public BufferPool() {
        this(16, 1024);
    }

    public BufferPool(int maxpoolSize, int bufferSize) {
        if (maxpoolSize <= 0) {
            throw new IllegalArgumentException("Max pool size must be positive");
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be positive");
        }
        this.maxpoolSize = Math.min(maxpoolSize, 64);
        this.bufferSize = bufferSize;
        this.availableBuffers = new ConcurrentLinkedQueue();
        this.activeCount = new AtomicInteger(0);
        this.totalCreated = new AtomicInteger(0);
        this.creationLock = new ReentrantLock();
    }

    public ByteBuffer borrowBuffer() {
        ByteBuffer buffer = this.availableBuffers.poll();
        if (buffer == null) {
            this.creationLock.lock();
            try {
                buffer = this.availableBuffers.poll();
                if (buffer == null) {
                    buffer = this.createNewBuffer();
                    this.totalCreated.incrementAndGet();
                }
            }
            finally {
                this.creationLock.unlock();
            }
        }
        if (buffer != null) {
            this.activeCount.incrementAndGet();
            buffer.clear();
        }
        return buffer;
    }

    public void returnBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.capacity() != this.bufferSize) {
            throw new IllegalArgumentException("Buffer capacity mismatch");
        }
        buffer.clear();
        if (this.availableBuffers.size() < this.maxpoolSize) {
            this.availableBuffers.offer(buffer);
        }
        this.activeCount.decrementAndGet();
    }

    private ByteBuffer createNewBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    public int getAvailableCount() {
        return this.availableBuffers.size();
    }

    public int getActiveCount() {
        return this.activeCount.get();
    }

    public int getTotalCreated() {
        return this.totalCreated.get();
    }

    public int getMaxpoolSize() {
        return this.maxpoolSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public BufferPoolStatistics getStatistics() {
        return new BufferPoolStatistics(this.getAvailableCount(), this.getActiveCount(), this.getTotalCreated(), this.getMaxpoolSize(), this.getBufferSize());
    }

    public void clear() {
        this.availableBuffers.clear();
        this.activeCount.set(0);
        this.totalCreated.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preallocate(int count) {
        if (count <= 0) {
            return;
        }
        this.creationLock.lock();
        try {
            int toCreate = Math.min(count, this.maxpoolSize - this.availableBuffers.size());
            for (int i = 0; i < toCreate; ++i) {
                this.availableBuffers.offer(this.createNewBuffer());
                this.totalCreated.incrementAndGet();
            }
        }
        finally {
            this.creationLock.unlock();
        }
    }

    public static class BufferPoolStatistics {
        private final int availableCount;
        private final int activeCount;
        private final int totalCreated;
        private final int maxpoolSize;
        private final int bufferSize;

        public BufferPoolStatistics(int availableCount, int activeCount, int totalCreated, int maxpoolSize, int bufferSize) {
            this.availableCount = availableCount;
            this.activeCount = activeCount;
            this.totalCreated = totalCreated;
            this.maxpoolSize = maxpoolSize;
            this.bufferSize = bufferSize;
        }

        public int getAvailableCount() {
            return this.availableCount;
        }

        public int getActiveCount() {
            return this.activeCount;
        }

        public int getTotalCreated() {
            return this.totalCreated;
        }

        public int getMaxpoolSize() {
            return this.maxpoolSize;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public int getUtilizationPercent() {
            return this.maxpoolSize > 0 ? this.activeCount * 100 / this.maxpoolSize : 0;
        }

        public String toString() {
            return String.format("BufferPoolStatistics{available=%d, active=%d, totalCreated=%d, maxSize=%d, bufferSize=%d, utilization=%d%%}", this.availableCount, this.activeCount, this.totalCreated, this.maxpoolSize, this.bufferSize, this.getUtilizationPercent());
        }
    }
}

