/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary.utils;

import com.kneaf.core.exceptions.core.KneafCoreException;

public class SerializationException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final KneafCoreException delegate;
    private final String serializerType;
    private final String operation;
    private final byte[] data;

    public SerializationException(String message) {
        super(message);
        this.delegate = ((KneafCoreException.Builder)KneafCoreException.builder().category(KneafCoreException.ErrorCategory.SYSTEM_ERROR).message(message)).build();
        this.serializerType = "unknown";
        this.operation = "unknown";
        this.data = null;
    }

    public SerializationException(String message, String serializerType, String operation) {
        super(message);
        this.delegate = ((KneafCoreException.Builder)KneafCoreException.builder().category(KneafCoreException.ErrorCategory.SYSTEM_ERROR).operation(operation).message(message)).build();
        this.serializerType = serializerType;
        this.operation = operation;
        this.data = null;
    }

    public SerializationException(String message, String serializerType, String operation, byte[] data) {
        super(message);
        this.delegate = ((KneafCoreException.Builder)KneafCoreException.builder().category(KneafCoreException.ErrorCategory.SYSTEM_ERROR).operation(operation).message(message)).build();
        this.serializerType = serializerType;
        this.operation = operation;
        this.data = data != null ? (byte[])data.clone() : null;
    }

    public SerializationException(String message, Throwable cause) {
        super(message, cause);
        this.delegate = ((KneafCoreException.Builder)((KneafCoreException.Builder)KneafCoreException.builder().category(KneafCoreException.ErrorCategory.SYSTEM_ERROR).message(message)).cause(cause)).build();
        this.serializerType = "unknown";
        this.operation = "unknown";
        this.data = null;
    }

    public SerializationException(String message, Throwable cause, String serializerType, String operation, byte[] data) {
        super(message, cause);
        this.delegate = ((KneafCoreException.Builder)((KneafCoreException.Builder)KneafCoreException.builder().category(KneafCoreException.ErrorCategory.SYSTEM_ERROR).operation(operation).message(message)).cause(cause)).build();
        this.serializerType = serializerType;
        this.operation = operation;
        this.data = data != null ? (byte[])data.clone() : null;
    }

    public String getSerializerType() {
        return this.serializerType;
    }

    public String getOperation() {
        return this.operation;
    }

    public byte[] getData() {
        return this.data != null ? (byte[])this.data.clone() : null;
    }

    public KneafCoreException getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SerializationException{");
        sb.append("message='").append(this.getMessage()).append('\'');
        sb.append(", serializerType='").append(this.serializerType).append('\'');
        sb.append(", operation='").append(this.operation).append('\'');
        if (this.data != null) {
            sb.append(", dataLength=").append(this.data.length);
        }
        if (this.getCause() != null) {
            sb.append(", cause=").append(this.getCause().getClass().getSimpleName());
        }
        sb.append('}');
        return sb.toString();
    }
}

