/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage;

import com.kneaf.core.chunkstorage.DatabaseAdapter;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractDatabaseAdapter
implements DatabaseAdapter {
    protected void validateKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
    }

    protected void validateData(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null");
        }
    }

    protected void validateDataNotEmpty(byte[] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Data cannot be null or empty");
        }
    }

    protected void validateBackupPath(String backupPath) {
        if (backupPath == null || backupPath.isEmpty()) {
            throw new IllegalArgumentException("Backup path cannot be null or empty");
        }
    }

    @Override
    public abstract void putChunk(String var1, byte[] var2) throws IOException;

    @Override
    public abstract CompletableFuture<Void> putChunkAsync(String var1, byte[] var2);

    @Override
    public abstract Optional<byte[]> getChunk(String var1) throws IOException;

    @Override
    public abstract CompletableFuture<Optional<byte[]>> getChunkAsync(String var1);

    @Override
    public abstract boolean deleteChunk(String var1) throws IOException;

    @Override
    public abstract CompletableFuture<Boolean> deleteChunkAsync(String var1);

    @Override
    public abstract boolean hasChunk(String var1) throws IOException;

    @Override
    public abstract long getChunkCount() throws IOException;

    @Override
    public abstract DatabaseAdapter.DatabaseStats getStats() throws IOException;

    @Override
    public abstract void performMaintenance() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract String getDatabaseType();

    @Override
    public abstract boolean isHealthy();

    @Override
    public abstract void createBackup(String var1) throws IOException;
}

