/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage.common;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkStorageExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkStorageExceptionHandler.class);

    private ChunkStorageExceptionHandler() {
    }

    public static CompletableFuture<Void> handleSaveException(String chunkKey, Exception exception, String operation) {
        LOGGER.error("Failed to { } chunk { }", new Object[]{operation, chunkKey, exception});
        return CompletableFuture.failedFuture(exception);
    }

    public static <T> Optional<T> handleLoadException(String chunkKey, Exception exception) {
        LOGGER.error("Failed to load chunk { }", (Object)chunkKey, (Object)exception);
        return Optional.empty();
    }

    public static boolean handleDatabaseException(String operation, String chunkKey, Exception exception) {
        LOGGER.error("Database { } failed for chunk { }", new Object[]{operation, chunkKey, exception});
        return false;
    }

    public static boolean handleSwapException(String operation, String chunkKey, Exception exception) {
        LOGGER.error("Swap { } failed for chunk { }", new Object[]{operation, chunkKey, exception});
        return false;
    }

    public static void handleInitializationException(String component, Exception exception, String fallbackMessage) {
        String message = exception.getMessage() != null ? exception.getMessage() : fallbackMessage;
        LOGGER.error("Failed to initialize { }: { }", new Object[]{component, message, exception});
    }

    public static void handleShutdownException(String component, Exception exception) {
        LOGGER.error("Error during shutdown of { }", (Object)component, (Object)exception);
    }

    public static void handleMaintenanceException(String component, Exception exception) {
        LOGGER.error("Failed to perform maintenance for { }", (Object)component, (Object)exception);
    }

    public static void handleBackupException(String component, String backupPath, Exception exception) {
        LOGGER.error("Failed to create backup for { } at '{ }'", new Object[]{component, backupPath, exception});
    }

    public static boolean handleHealthCheckException(String component, Exception exception) {
        LOGGER.error("Health check failed for { }", (Object)component, (Object)exception);
        return false;
    }

    public static <T> T handleStatsException(String component, Exception exception, T defaultStats) {
        LOGGER.error("Failed to get statistics for { }", (Object)component, (Object)exception);
        return defaultStats;
    }

    public static <T> T handleReflectionException(String operation, String className, Exception exception) {
        LOGGER.debug("Reflection { } failed for class { }: { }", new Object[]{operation, className, exception.getMessage()});
        return null;
    }

    public static void logWarning(String component, String message, Object ... params) {
        LOGGER.warn("[{ }] { }", (Object)component, (Object)String.format(message, params));
    }

    public static void logDebug(String component, String message, Object ... params) {
        LOGGER.debug("[{ }] { }", (Object)component, (Object)String.format(message, params));
    }

    public static void logInfo(String component, String message, Object ... params) {
        LOGGER.info("[{ }] { }", (Object)component, (Object)String.format(message, params));
    }
}

