/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage.database;

import com.kneaf.core.chunkstorage.common.StorageStatisticsProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface DatabaseAdapter
extends StorageStatisticsProvider {
    public void putChunk(String var1, byte[] var2) throws IOException;

    public CompletableFuture<Void> putChunkAsync(String var1, byte[] var2);

    public Optional<byte[]> getChunk(String var1) throws IOException;

    public CompletableFuture<Optional<byte[]>> getChunkAsync(String var1);

    public boolean deleteChunk(String var1) throws IOException;

    public CompletableFuture<Boolean> deleteChunkAsync(String var1);

    public boolean hasChunk(String var1) throws IOException;

    public long getChunkCount() throws IOException;

    public void performMaintenance() throws IOException;

    public void close() throws IOException;

    public String getDatabaseType();

    public boolean isHealthy();

    public void createBackup(String var1) throws IOException;

    default public int bulkSwapOut(List<String> chunkKeys) {
        if (chunkKeys == null || chunkKeys.isEmpty()) {
            return 0;
        }
        int successCount = 0;
        for (String chunkKey : chunkKeys) {
            try {
                if (!this.swapOutChunk(chunkKey)) continue;
                ++successCount;
            }
            catch (Exception exception) {}
        }
        return successCount;
    }

    default public List<byte[]> bulkSwapIn(List<String> chunkKeys) {
        if (chunkKeys == null || chunkKeys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        for (String chunkKey : chunkKeys) {
            try {
                Optional<byte[]> data = this.swapInChunk(chunkKey);
                if (!data.isPresent()) continue;
                results.add(data.get());
            }
            catch (Exception exception) {}
        }
        return results;
    }

    public boolean swapOutChunk(String var1) throws IOException;

    public Optional<byte[]> swapInChunk(String var1) throws IOException;
}

