/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.command;

import com.kneaf.core.chunkstorage.ChunkStorageManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;

public class ChunkCacheCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, ChunkStorageManager> STORAGE_MANAGERS = new ConcurrentHashMap<String, ChunkStorageManager>();
    private static final String ARG_POLICY = "policy";

    private ChunkCacheCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chunkcache").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"Stats").executes(ChunkCacheCommand::showStats))).then(Commands.literal((String)"clear").executes(ChunkCacheCommand::clearCache))).then(Commands.literal((String)"maintenance").executes(ChunkCacheCommand::performMaintenance))).then(Commands.literal((String)"backup").executes(ChunkCacheCommand::createBackup))).then(((LiteralArgumentBuilder)Commands.literal((String)"config").then(Commands.literal((String)"capacity").then(Commands.argument((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10000)).executes(context -> ChunkCacheCommand.setCacheCapacity((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"size")))))).then(Commands.literal((String)ARG_POLICY).then(Commands.argument((String)ARG_POLICY, (ArgumentType)StringArgumentType.string()).executes(context -> ChunkCacheCommand.setEvictionPolicy((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)ARG_POLICY))))))).then(Commands.literal((String)"help").executes(ChunkCacheCommand::showHelp));
        dispatcher.register(command);
    }

    public static void registerStorageManager(String worldName, ChunkStorageManager manager) {
        if (worldName != null && manager != null) {
            STORAGE_MANAGERS.put(worldName, manager);
            LOGGER.info("Registered ChunkStorageManager for world '{ }' in command system", (Object)worldName);
        }
    }

    public static void unregisterStorageManager(String worldName) {
        ChunkStorageManager removed;
        if (worldName != null && (removed = STORAGE_MANAGERS.remove(worldName)) != null) {
            LOGGER.info("Unregistered ChunkStorageManager for world '{ }' from command system", (Object)worldName);
        }
    }

    private static int showStats(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (STORAGE_MANAGERS.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7cNo chunk storage managers registered"), false);
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== Chunk Storage Statistics ==="), false);
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            String worldName = entry.getKey();
            ChunkStorageManager manager = entry.getValue();
            ChunkStorageManager.StorageStats Stats = manager.getStats();
            if (Stats.isEnabled()) {
                String pattern = "\u00a7bWorld: \u00a7f%s\n\u00a7bStatus: \u00a7a%s\n\u00a7bDatabase Chunks: \u00a7f%d\n\u00a7bCached Chunks: \u00a7f%d\n\u00a7bRead Latency: \u00a7f%d ms\n\u00a7bWrite Latency: \u00a7f%d ms\n\u00a7bCache Hit Rate: \u00a7f%.2f%%\n\u00a7bOverall Hit Rate: \u00a7f%.2f%%\n";
                source.sendSuccess(() -> Component.literal((String)String.format("\u00a7bWorld: \u00a7f%s\n\u00a7bStatus: \u00a7a%s\n\u00a7bDatabase Chunks: \u00a7f%d\n\u00a7bCached Chunks: \u00a7f%d\n\u00a7bRead Latency: \u00a7f%d ms\n\u00a7bWrite Latency: \u00a7f%d ms\n\u00a7bCache Hit Rate: \u00a7f%.2f%%\n\u00a7bOverall Hit Rate: \u00a7f%.2f%%\n", worldName, Stats.getStatus(), Stats.getTotalChunksInDb(), Stats.getCachedChunks(), Stats.getAvgReadLatencyMs(), Stats.getAvgWriteLatencyMs(), Stats.getCacheHitRate() * 100.0, Stats.getOverallHitRate() * 100.0)), false);
                continue;
            }
            source.sendSuccess(() -> Component.literal((String)String.format("\u00a7bWorld: \u00a7f%s \u00a77[DISABLED]", worldName)), false);
        }
        return 1;
    }

    private static int clearCache(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int clearedCount = 0;
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            try {
                entry.getValue().clearCache();
                ++clearedCount;
            }
            catch (Exception e) {
                LOGGER.warn("Failed to clear cache for world { }: { }", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
        int finalCleared = clearedCount;
        source.sendSuccess(() -> Component.literal((String)String.format("\u00a7aCleared caches for \u00a7f%d \u00a7aworlds", finalCleared)), false);
        return 1;
    }

    private static int performMaintenance(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.literal((String)"\u00a76Performing storage maintenance..."), false);
        int maintainedCount = 0;
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            String worldName = entry.getKey();
            ChunkStorageManager manager = entry.getValue();
            try {
                manager.performMaintenance();
                ++maintainedCount;
                source.sendSuccess(() -> Component.literal((String)String.format("\u00a7aMaintenance completed for world '%s'", worldName)), false);
            }
            catch (Exception e) {
                source.sendSuccess(() -> Component.literal((String)String.format("\u00a7cMaintenance failed for world '%s': %s", worldName, e.getMessage())), false);
                LOGGER.error("Maintenance failed for world '{ }'", (Object)worldName, (Object)e);
            }
        }
        int finalMaintainedCount = maintainedCount;
        source.sendSuccess(() -> Component.literal((String)String.format("\u00a7aMaintenance completed for \u00a7f%d \u00a7aworlds", finalMaintainedCount)), false);
        return 1;
    }

    private static int createBackup(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.literal((String)"\u00a76Creating backups..."), false);
        int backupCount = 0;
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            String worldName = entry.getKey();
            ChunkStorageManager manager = entry.getValue();
            try {
                String backupPath = String.format("backups/chunkstorage/%s_%d", worldName, System.currentTimeMillis());
                manager.createBackup(backupPath);
                ++backupCount;
                source.sendSuccess(() -> Component.literal((String)String.format("\u00a7aBackup created for world '%s' at '%s'", worldName, backupPath)), false);
            }
            catch (Exception e) {
                source.sendSuccess(() -> Component.literal((String)String.format("\u00a7cBackup failed for world '%s': %s", worldName, e.getMessage())), false);
                LOGGER.error("Backup failed for world '{ }'", (Object)worldName, (Object)e);
            }
        }
        int finalBackupCount = backupCount;
        source.sendSuccess(() -> Component.literal((String)String.format("\u00a7aBackups created for \u00a7f%d \u00a7aworlds", finalBackupCount)), false);
        return 1;
    }

    private static int setCacheCapacity(CommandContext<CommandSourceStack> context, int capacity) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int applied = 0;
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            try {
                entry.getValue().setCacheCapacity(capacity);
                ++applied;
            }
            catch (Exception e) {
                LOGGER.warn("Failed to set cache capacity for world { }: { }", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
        int finalApplied = applied;
        source.sendSuccess(() -> Component.literal((String)String.format("\u00a7aCache capacity set to \u00a7f%d \u00a7afor %d worlds", capacity, finalApplied)), false);
        return 1;
    }

    private static int setEvictionPolicy(CommandContext<CommandSourceStack> context, String policy) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!(policy.equalsIgnoreCase("LRU") || policy.equalsIgnoreCase("Distance") || policy.equalsIgnoreCase("Hybrid"))) {
            source.sendSuccess(() -> Component.literal((String)String.format("\u00a7cInvalid eviction policy '%s'. Valid policies: LRU, Distance, Hybrid", policy)), false);
            return 0;
        }
        int applied = 0;
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            try {
                entry.getValue().setEvictionPolicy(policy);
                ++applied;
            }
            catch (Exception e) {
                LOGGER.warn("Failed to set eviction policy for world { }: { }", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
        int finalApplied2 = applied;
        source.sendSuccess(() -> Component.literal((String)String.format("\u00a7aEviction policy set to \u00a7f%s \u00a7afor %d worlds", policy, finalApplied2)), false);
        return 1;
    }

    private static int showHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== Chunk Cache Command Help ==="), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7b/chunkcache Stats \u00a77- Show storage statistics"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7b/chunkcache clear \u00a77- Clear all caches"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7b/chunkcache maintenance \u00a77- Perform storage maintenance"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7b/chunkcache backup \u00a77- Create backups"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7b/chunkcache config capacity <size> \u00a77- Set cache capacity"), false);
        source.sendSuccess(() -> Component.literal((String)String.format("\u00a7b/chunkcache config %s <LRU|Distance|Hybrid> \u00a77- Set eviction policy", ARG_POLICY)), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7b/chunkcache help \u00a77- Show this help"), false);
        return 1;
    }
}

