/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.command;

import com.kneaf.core.command.ChunkCacheCommand;
import com.kneaf.core.performance.RustPerformance;
import com.kneaf.core.performance.monitoring.PerformanceManager;
import com.kneaf.core.performance.monitoring.PerformanceMetricsLogger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class PerformanceCommand {
    private PerformanceCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"kneaf").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"perf").then(Commands.literal((String)"toggle").executes(PerformanceCommand::toggle))).then(Commands.literal((String)"status").executes(PerformanceCommand::status))).then(Commands.literal((String)"metrics").executes(PerformanceCommand::metrics))).then(Commands.literal((String)"rotatelog").executes(PerformanceCommand::rotateLog))));
        ChunkCacheCommand.register(dispatcher);
    }

    private static int toggle(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        boolean newVal = !PerformanceManager.isEnabled();
        PerformanceManager.setEnabled(newVal);
        source.sendSuccess(() -> Component.literal((String)("Kneaf performance manager enabled=" + newVal)), true);
        return 1;
    }

    private static int status(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        double tps = RustPerformance.getCurrentTPS();
        String cpu = RustPerformance.getCpuStats();
        String mem = RustPerformance.getMemoryStats();
        String msg = String.format("Kneaf Performance - enabled=%s TPS=%.2f CPU=%s MEM=%s log=run/logs/kneaf-performance.log", PerformanceManager.isEnabled(), tps, cpu, mem);
        source.sendSuccess(() -> Component.literal((String)msg), false);
        return 1;
    }

    private static int metrics(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String msg = String.format("EntitiesProcessed=%d MobsProcessed=%d BlocksProcessed=%d ItemsMerged=%d ItemsDespawned=%d", RustPerformance.getTotalEntitiesProcessed(), RustPerformance.getTotalMobsProcessed(), RustPerformance.getTotalBlocksProcessed(), RustPerformance.getTotalMerged(), RustPerformance.getTotalDespawned());
        source.sendSuccess(() -> Component.literal((String)msg), false);
        return 1;
    }

    private static int rotateLog(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PerformanceMetricsLogger.rotateNow();
        source.sendSuccess(() -> Component.literal((String)"Kneaf performance log rotated."), false);
        return 1;
    }
}

