/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.config;

import com.kneaf.core.config.ChunkStorageConfiguration;
import com.kneaf.core.config.PerformanceConfiguration;
import com.kneaf.core.config.ResourceConfiguration;
import com.kneaf.core.config.SwapConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationManager.class);
    private static final String DEFAULT_CONFIG_PATH = "config/kneaf-core.properties";
    private static volatile ConfigurationManager instance;
    private final ConcurrentMap<Class<?>, Object> configurations = new ConcurrentHashMap();
    private final Properties properties = this.loadProperties();

    private ConfigurationManager() {
        this.initializeDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigurationManager getInstance() {
        if (instance != null) return instance;
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            if (instance != null) return instance;
            instance = new ConfigurationManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public <T> T getConfiguration(Class<T> configType) {
        return (T)this.configurations.computeIfAbsent(configType, this::createConfiguration);
    }

    public <T> void registerConfiguration(Class<T> configType, Function<Properties, T> factory) {
        this.configurations.put(configType, factory.apply(this.properties));
        LOGGER.info("Registered custom configuration type: { }", (Object)configType.getSimpleName());
    }

    public void reload() {
        Properties newProperties = this.loadProperties();
        this.configurations.clear();
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)newProperties);
        this.initializeDefaults();
        LOGGER.info("Configuration reloaded from: { }", (Object)DEFAULT_CONFIG_PATH);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.properties.getProperty(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public int getIntProperty(String key, int defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid integer value for key '{ }': { }", (Object)key, (Object)value);
            return defaultValue;
        }
    }

    public long getLongProperty(String key, long defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid long value for key '{ }': { }", (Object)key, (Object)value);
            return defaultValue;
        }
    }

    public double getDoubleProperty(String key, double defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value.trim());
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid double value for key '{ }': { }", (Object)key, (Object)value);
            return defaultValue;
        }
    }

    public String[] getStringArrayProperty(String key, String[] defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue != null ? (String[])defaultValue.clone() : new String[]{};
        }
        return value.split("\\s*,\\s*");
    }

    private Properties loadProperties() {
        Properties props = new Properties();
        Path path = Paths.get(DEFAULT_CONFIG_PATH, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                props.load(in);
                LOGGER.info("Loaded configuration from: { }", (Object)DEFAULT_CONFIG_PATH);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read configuration from { }, using defaults: { }", (Object)DEFAULT_CONFIG_PATH, (Object)e.getMessage());
            }
        } else {
            LOGGER.info("Configuration file not found at { }, using defaults", (Object)DEFAULT_CONFIG_PATH);
        }
        return props;
    }

    private void initializeDefaults() {
        this.registerConfiguration(PerformanceConfiguration.class, this::createPerformanceConfig);
        this.registerConfiguration(ChunkStorageConfiguration.class, this::createChunkStorageConfig);
        this.registerConfiguration(SwapConfiguration.class, this::createSwapConfig);
        this.registerConfiguration(ResourceConfiguration.class, this::createResourceConfig);
    }

    private PerformanceConfiguration createPerformanceConfig(Properties props) {
        return PerformanceConfiguration.builder().enabled(this.getBooleanProperty("performance.enabled", true)).threadpoolSize(this.getIntProperty("performance.threadpoolSize", 4)).logIntervalTicks(this.getIntProperty("performance.logIntervalTicks", 100)).scanIntervalTicks(this.getIntProperty("performance.scanIntervalTicks", 1)).tpsThresholdForAsync(this.getDoubleProperty("performance.tpsThresholdForAsync", 19.0)).maxEntitiesToCollect(this.getIntProperty("performance.maxEntitiesToCollect", 20000)).entityDistanceCutoff(this.getDoubleProperty("performance.entityDistanceCutoff", 256.0)).maxLogBytes(this.getLongProperty("performance.maxLogBytes", 0xA00000L)).adaptiveThreadPool(this.getBooleanProperty("performance.adaptiveThreadPool", false)).maxThreadpoolSize(this.getIntProperty("performance.maxThreadpoolSize", Math.max(1, Runtime.getRuntime().availableProcessors() - 1))).excludedEntityTypes(this.getStringArrayProperty("performance.excludedEntityTypes", new String[0])).networkExecutorpoolSize(this.getIntProperty("performance.networkExecutorpoolSize", Math.max(1, Runtime.getRuntime().availableProcessors() / 2))).profilingEnabled(this.getBooleanProperty("performance.profilingEnabled", true)).slowTickThresholdMs(this.getLongProperty("performance.slowTickThresholdMs", 50L)).profilingSampleRate(this.getIntProperty("performance.profilingSampleRate", 100)).minThreadpoolSize(this.getIntProperty("performance.minThreadpoolSize", 2)).dynamicThreadScaling(this.getBooleanProperty("performance.dynamicThreadScaling", true)).threadScaleUpThreshold(this.getDoubleProperty("performance.threadScaleUpThreshold", 0.8)).threadScaleDownThreshold(this.getDoubleProperty("performance.threadScaleDownThreshold", 0.3)).threadScaleUpDelayTicks(this.getIntProperty("performance.threadScaleUpDelayTicks", 100)).threadScaleDownDelayTicks(this.getIntProperty("performance.threadScaleDownDelayTicks", 200)).workStealingEnabled(this.getBooleanProperty("performance.workStealingEnabled", true)).workStealingQueueSize(this.getIntProperty("performance.workStealingQueueSize", 100)).cpuAwareThreadSizing(this.getBooleanProperty("performance.cpuAwareThreadSizing", false)).cpuLoadThreshold(this.getDoubleProperty("performance.cpuLoadThreshold", 0.7)).threadPoolKeepAliveSeconds(this.getIntProperty("performance.threadPoolKeepAliveSeconds", 60)).distanceCalculationInterval(this.getIntProperty("performance.distanceCalculationInterval", 1)).distanceApproximationEnabled(this.getBooleanProperty("performance.distanceApproximationEnabled", true)).distanceCacheSize(this.getIntProperty("performance.distanceCacheSize", 100)).itemProcessingIntervalMultiplier(this.getIntProperty("performance.itemProcessingIntervalMultiplier", 1)).spatialGridUpdateInterval(this.getIntProperty("performance.spatialGridUpdateInterval", 1)).incrementalSpatialUpdates(this.getBooleanProperty("performance.incrementalSpatialUpdates", true)).build();
    }

    private ChunkStorageConfiguration createChunkStorageConfig(Properties props) {
        return ChunkStorageConfiguration.builder().enabled(this.getBooleanProperty("chunkstorage.enabled", true)).cacheCapacity(this.getIntProperty("chunkstorage.cacheCapacity", 1000)).evictionPolicy(this.getProperty("chunkstorage.evictionPolicy", "LRU")).asyncThreadpoolSize(this.getIntProperty("chunkstorage.asyncThreadpoolSize", 4)).enableAsyncOperations(this.getBooleanProperty("chunkstorage.enableAsyncOperations", true)).maintenanceIntervalMinutes(this.getLongProperty("chunkstorage.maintenanceIntervalMinutes", 60L)).enableBackups(this.getBooleanProperty("chunkstorage.enableBackups", true)).backupPath(this.getProperty("chunkstorage.backupPath", "backups/chunkstorage")).enableChecksums(this.getBooleanProperty("chunkstorage.enableChecksums", true)).enableCompression(this.getBooleanProperty("chunkstorage.enableCompression", false)).maxBackupFiles(this.getIntProperty("chunkstorage.maxBackupFiles", 10)).backupRetentionDays(this.getLongProperty("chunkstorage.backupRetentionDays", 7L)).databaseType(this.getProperty("chunkstorage.databaseType", "rust")).useRustDatabase(this.getBooleanProperty("chunkstorage.useRustDatabase", true)).build();
    }

    private SwapConfiguration createSwapConfig(Properties props) {
        return SwapConfiguration.builder().enabled(this.getBooleanProperty("swap.enabled", true)).memoryCheckIntervalMs(this.getLongProperty("swap.memoryCheckIntervalMs", 5000L)).maxConcurrentSwaps(this.getIntProperty("swap.maxConcurrentSwaps", 10)).swapBatchSize(this.getIntProperty("swap.swapBatchSize", 50)).swapTimeoutMs(this.getLongProperty("swap.swapTimeoutMs", 30000L)).enableAutomaticSwapping(this.getBooleanProperty("swap.enableAutomaticSwapping", true)).criticalMemoryThreshold(this.getDoubleProperty("swap.criticalMemoryThreshold", 0.95)).highMemoryThreshold(this.getDoubleProperty("swap.highMemoryThreshold", 0.85)).elevatedMemoryThreshold(this.getDoubleProperty("swap.elevatedMemoryThreshold", 0.75)).minSwapChunkAgeMs(this.getIntProperty("swap.minSwapChunkAgeMs", 60000)).enableSwapStatistics(this.getBooleanProperty("swap.enableSwapStatistics", true)).enablePerformanceMonitoring(this.getBooleanProperty("swap.enablePerformanceMonitoring", true)).build();
    }

    private ResourceConfiguration createResourceConfig(Properties props) {
        return ResourceConfiguration.builder().resourceCleanupIntervalSeconds(this.getIntProperty("resource.cleanupIntervalSeconds", 300)).resourceHealthCheckIntervalSeconds(this.getIntProperty("resource.healthCheckIntervalSeconds", 60)).maxResourceAgeMinutes(this.getIntProperty("resource.maxResourceAgeMinutes", 30)).resourcePoolEnabled(this.getBooleanProperty("resource.poolEnabled", true)).resourcePoolMaxSize(this.getIntProperty("resource.poolMaxSize", 100)).resourcePoolInitialSize(this.getIntProperty("resource.poolInitialSize", 10)).build();
    }

    private <T> Object createConfiguration(Class<T> configType) {
        throw new IllegalArgumentException("Unknown configuration type: " + configType.getSimpleName());
    }
}

